/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ChokedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ChokingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ClientItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ConnectedTimeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DLedFromOthersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DiscardedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.HostNameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.InterestedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.InterestingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.IpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.OptimisticUnchokeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PortItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.SnubbedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.StatUpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.StateItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TimeToSendPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TotalDownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UniquePieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpDownRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpSpeedItem;

public class PeersView
extends TableView
implements DownloadManagerPeerListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new IpItem(), new ClientItem(), new TypeItem(), new PiecesItem(), new PercentItem(), new DownSpeedItem(), new UpSpeedItem(), new HostNameItem(), new PortItem(), new InterestedItem(), new ChokedItem(), new DownItem(), new InterestingItem(), new ChokingItem(), new OptimisticUnchokeItem(), new UpItem(), new UpDownRatioItem(), new StatUpItem(), new SnubbedItem(), new TotalDownSpeedItem(), new DiscardedItem(), new UniquePieceItem(), new TimeToSendPieceItem(), new DLedFromOthersItem(), new UpRatioItem(), new StateItem(), new ConnectedTimeItem()};
    private DownloadManager manager;

    public PeersView(DownloadManager manager) {
        super("Peers", "PeersView", basicItems, "pieces", 65538);
        this.manager = manager;
        this.iCellHeight = 16;
    }

    public void initialize(Composite composite) {
        super.initialize(composite);
        this.manager.addPeerListener(this);
    }

    public void tableStructureChanged() {
        this.manager.removePeerListener(this);
        super.tableStructureChanged();
        this.manager.addPeerListener(this);
    }

    public void fillMenu(Menu menu) {
        final MenuItem block_item = new MenuItem(menu, 32);
        menu.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                PEPeer peer = (PEPeer)PeersView.this.getFirstSelectedDataSource();
                if (peer == null || !peer.getManager().getDownloadManager().isDownloadComplete()) {
                    block_item.setSelection(false);
                    block_item.setEnabled(false);
                    return;
                }
                block_item.setEnabled(true);
                block_item.setSelection(peer.isSnubbed());
            }
        });
        Messages.setLanguageText((Widget)block_item, "PeersView.menu.blockupload");
        block_item.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                ((PEPeer)row.getDataSource(true)).setSnubbed(block_item.getSelection());
            }
        });
        MenuItem ban_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)ban_item, "PeersView.menu.kickandban");
        ban_item.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                PEPeer peer = (PEPeer)row.getDataSource(true);
                String msg = MessageText.getString("PeersView.menu.kickandban.reason");
                IpFilterManagerFactory.getSingleton().getIPFilter().ban(peer.getIp(), msg);
                peer.getManager().removePeer(peer);
            }
        });
        new MenuItem(menu, 2);
        super.fillMenu(menu);
    }

    public void delete() {
        this.manager.removePeerListener(this);
        super.delete();
    }

    public void peerAdded(PEPeer created) {
        this.addDataSource(created);
    }

    public void peerRemoved(PEPeer removed) {
        this.removeDataSource(removed);
    }

    public void pieceAdded(PEPiece piece) {
    }

    public void pieceRemoved(PEPiece piece) {
    }

    public void peerManagerAdded(PEPeerManager manager) {
    }

    public void peerManagerRemoved(PEPeerManager manager) {
    }
}

