/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.importtorrent.wizard;

import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.importtorrent.wizard.ImportTorrentWizard;
import org.gudy.azureus2.ui.swt.importtorrent.wizard.ImportTorrentWizardOutputPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class ImportTorrentWizardInputPanel
extends AbstractWizardPanel {
    protected boolean file_valid = false;

    public ImportTorrentWizardInputPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("importTorrentWizard.importfile.title"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 380;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "importTorrentWizard.importfile.message");
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "importTorrentWizard.importfile.path");
        final Text textPath = new Text(panel, 2048);
        gridData = new GridData(768);
        textPath.setLayoutData((Object)gridData);
        textPath.setText("");
        Button browse = new Button(panel, 8);
        Messages.setLanguageText((Widget)browse, "importTorrentWizard.importfile.browse");
        browse.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                FileDialog fd = new FileDialog(ImportTorrentWizardInputPanel.this.wizard.getWizardWindow());
                fd.setFileName(textPath.getText());
                fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String path = fd.open();
                if (path != null) {
                    textPath.setText(path);
                }
            }
        });
        textPath.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String path = textPath.getText();
                ((ImportTorrentWizard)ImportTorrentWizardInputPanel.this.wizard).setImportFile(path);
                ImportTorrentWizardInputPanel.this.file_valid = false;
                try {
                    File f = new File(path);
                    if (f.exists()) {
                        if (f.isFile()) {
                            ImportTorrentWizardInputPanel.this.file_valid = true;
                            ImportTorrentWizardInputPanel.this.wizard.setErrorMessage("");
                        } else {
                            ImportTorrentWizardInputPanel.this.wizard.setErrorMessage(MessageText.getString("importTorrentWizard.importfile.invalidPath"));
                        }
                    }
                }
                catch (Exception e) {
                    ImportTorrentWizardInputPanel.this.wizard.setErrorMessage(MessageText.getString("importTorrentWizard.importfile.invalidPath"));
                }
                ImportTorrentWizardInputPanel.this.wizard.setNextEnabled(ImportTorrentWizardInputPanel.this.file_valid);
            }
        });
        textPath.setText(((ImportTorrentWizard)this.wizard).getImportFile());
        textPath.setFocus();
    }

    public IWizardPanel getNextPanel() {
        return new ImportTorrentWizardOutputPanel(this.wizard, this);
    }

    public boolean isNextEnabled() {
        return this.file_valid;
    }

    public boolean isFinishEnabled() {
        return false;
    }
}

