/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;

public class IntParameter
extends Parameter {
    Text inputField;
    int iMinValue = 0;
    int iMaxValue = -1;
    int iDefaultValue;
    String sParamName;
    boolean allowZero = false;
    boolean generateIntermediateEvents = true;
    boolean value_is_changing_internally;

    public IntParameter(Composite composite, String name) {
        this.iDefaultValue = COConfigurationManager.getIntParameter(name);
        this.initialize(composite, name);
    }

    public IntParameter(Composite composite, String name, int defaultValue) {
        this.iDefaultValue = defaultValue;
        this.initialize(composite, name);
    }

    public IntParameter(Composite composite, String name, int defaultValue, boolean generateIntermediateEvents) {
        this.iDefaultValue = defaultValue;
        this.generateIntermediateEvents = generateIntermediateEvents;
        this.initialize(composite, name);
    }

    public IntParameter(Composite composite, String name, int minValue, int maxValue, boolean allowZero) {
        this.iDefaultValue = COConfigurationManager.getIntParameter(name);
        this.initialize(composite, name);
        this.iMinValue = minValue;
        this.iMaxValue = maxValue;
        this.allowZero = allowZero;
    }

    public void initialize(Composite composite, String name) {
        this.sParamName = name;
        this.inputField = new Text(composite, 2048);
        int value = COConfigurationManager.getIntParameter(name, this.iDefaultValue);
        this.inputField.setText(String.valueOf(value));
        this.inputField.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        if (this.generateIntermediateEvents) {
            this.inputField.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    IntParameter.this.checkValue();
                }
            });
        }
        this.inputField.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                IntParameter.this.checkValue();
            }
        });
    }

    public void setAllowZero(boolean allow) {
        this.allowZero = allow;
    }

    public void setMinimumValue(int value) {
        this.iMinValue = value;
    }

    protected void checkValue() {
        try {
            int new_val;
            int old_val = COConfigurationManager.getIntParameter(this.sParamName, -1);
            int original_new_val = new_val = Integer.parseInt(this.inputField.getText());
            if (!(new_val >= this.iMinValue || this.allowZero && new_val == 0)) {
                new_val = this.iMinValue;
            }
            if (new_val > this.iMaxValue && this.iMaxValue > -1) {
                new_val = this.iMaxValue;
            }
            if (new_val != old_val) {
                COConfigurationManager.setParameter(this.sParamName, new_val);
                if (new_val != original_new_val) {
                    this.inputField.setText(String.valueOf(new_val));
                }
                int i = 0;
                while (i < this.change_listeners.size()) {
                    ((ParameterChangeListener)this.change_listeners.get(i)).parameterChanged(this, this.value_is_changing_internally);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValue(int value) {
        if (this.getValue() != value) {
            try {
                this.value_is_changing_internally = true;
                this.inputField.setText(String.valueOf(value));
            }
            finally {
                this.value_is_changing_internally = false;
            }
        }
    }

    public int getValue() {
        return COConfigurationManager.getIntParameter(this.sParamName, this.iDefaultValue);
    }

    public void setLayoutData(Object layoutData) {
        this.inputField.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.inputField;
    }
}

