/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.tracker;

import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerPeer;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPTrackerTorrent
extends RPObject
implements TrackerTorrent {
    protected transient TrackerTorrent delegate;
    public RPTorrent torrent;
    public int status;
    public long total_uploaded;
    public long total_downloaded;
    public long average_uploaded;
    public long average_downloaded;
    public long total_left;
    public long completed_count;
    public long total_bytes_in;
    public long average_bytes_in;
    public long total_bytes_out;
    public long average_bytes_out;
    public long scrape_count;
    public long announce_count;
    public int seed_count;
    public int leecher_count;
    public int bad_NAT_count;

    public static RPTrackerTorrent create(TrackerTorrent _delegate) {
        RPTrackerTorrent res = (RPTrackerTorrent)RPObject._lookupLocal(_delegate);
        if (res == null) {
            res = new RPTrackerTorrent(_delegate);
        }
        return res;
    }

    protected RPTrackerTorrent(TrackerTorrent _delegate) {
        super(_delegate);
        if (this.delegate.getTorrent() != null) {
            this.torrent = (RPTorrent)RPObject._lookupLocal(this.delegate.getTorrent());
            if (this.torrent == null) {
                this.torrent = RPTorrent.create(this.delegate.getTorrent());
            }
        }
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (TrackerTorrent)_delegate;
        this.status = this.delegate.getStatus();
        this.total_uploaded = this.delegate.getTotalUploaded();
        this.total_downloaded = this.delegate.getTotalDownloaded();
        this.average_uploaded = this.delegate.getAverageUploaded();
        this.average_downloaded = this.delegate.getAverageDownloaded();
        this.total_left = this.delegate.getTotalLeft();
        this.completed_count = this.delegate.getCompletedCount();
        this.total_bytes_in = this.delegate.getTotalBytesIn();
        this.average_bytes_in = this.delegate.getAverageBytesIn();
        this.total_bytes_out = this.delegate.getTotalBytesOut();
        this.average_bytes_out = this.delegate.getAverageBytesOut();
        this.scrape_count = this.delegate.getScrapeCount();
        this.announce_count = this.delegate.getAnnounceCount();
        this.seed_count = this.delegate.getSeedCount();
        this.leecher_count = this.delegate.getLeecherCount();
        this.bad_NAT_count = this.delegate.getBadNATCount();
    }

    public Object _setLocal() throws RPException {
        Object res = this._fixupLocal();
        if (this.torrent != null) {
            this.torrent._setLocal();
        }
        return res;
    }

    public void _setRemote(RPRequestDispatcher dispatcher) {
        super._setRemote(dispatcher);
        if (this.torrent != null) {
            this.torrent._setRemote(dispatcher);
        }
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        throw new RPException("Unknown method: " + method);
    }

    public void remove() throws TrackerTorrentRemovalVetoException {
        this.notSupported();
    }

    public boolean canBeRemoved() throws TrackerTorrentRemovalVetoException {
        this.notSupported();
        return false;
    }

    public Torrent getTorrent() {
        return this.torrent;
    }

    public TrackerPeer[] getPeers() {
        this.notSupported();
        return null;
    }

    public int getStatus() {
        this.notSupported();
        return this.status;
    }

    public long getTotalUploaded() {
        this.notSupported();
        return this.total_uploaded;
    }

    public long getTotalDownloaded() {
        this.notSupported();
        return this.total_downloaded;
    }

    public long getAverageUploaded() {
        this.notSupported();
        return this.average_uploaded;
    }

    public long getAverageDownloaded() {
        this.notSupported();
        return this.average_downloaded;
    }

    public long getTotalLeft() {
        this.notSupported();
        return this.total_left;
    }

    public long getCompletedCount() {
        this.notSupported();
        return this.completed_count;
    }

    public long getTotalBytesIn() {
        this.notSupported();
        return this.total_bytes_in;
    }

    public long getAverageBytesIn() {
        this.notSupported();
        return this.average_bytes_in;
    }

    public long getTotalBytesOut() {
        this.notSupported();
        return this.total_bytes_out;
    }

    public long getAverageBytesOut() {
        this.notSupported();
        return this.average_bytes_out;
    }

    public long getScrapeCount() {
        this.notSupported();
        return this.scrape_count;
    }

    public long getAnnounceCount() {
        this.notSupported();
        return this.announce_count;
    }

    public int getSeedCount() {
        this.notSupported();
        return this.seed_count;
    }

    public int getLeecherCount() {
        this.notSupported();
        return this.leecher_count;
    }

    public int getBadNATCount() {
        this.notSupported();
        return this.bad_NAT_count;
    }

    public void disableReplyCaching() {
        this.notSupported();
    }

    public void addListener(TrackerTorrentListener listener) {
    }

    public void removeListener(TrackerTorrentListener listener) {
    }

    public void addRemovalListener(TrackerTorrentWillBeRemovedListener listener) {
    }

    public void removeRemovalListener(TrackerTorrentWillBeRemovedListener listener) {
    }
}

