/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPPluginInterface;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestAccessController;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadManager;

public class RPRequestHandler {
    protected PluginInterface plugin_interface;
    protected Map reply_cache = new HashMap();

    public RPRequestHandler(PluginInterface _pi) {
        this.plugin_interface = _pi;
    }

    public RPReply processRequest(RPRequest request2) {
        return this.processRequest(request2, null);
    }

    public RPReply processRequest(RPRequest request2, RPRequestAccessController access_controller) {
        replyCache cached_reply;
        Long connection_id = new Long(request2.getConnectionId());
        replyCache replyCache2 = cached_reply = connection_id == 0L ? null : (replyCache)this.reply_cache.get(connection_id);
        if (cached_reply != null && cached_reply.getId() == request2.getRequestId()) {
            return cached_reply.getReply();
        }
        RPReply reply = this.processRequestSupport(request2, access_controller);
        this.reply_cache.put(connection_id, new replyCache(request2.getRequestId(), reply));
        return reply;
    }

    protected RPReply processRequestSupport(RPRequest request2, RPRequestAccessController access_controller) {
        try {
            RPObject object = request2.getObject();
            String method = request2.getMethod();
            if (object == null && method.equals("getSingleton")) {
                RPReply reply = new RPReply(RPPluginInterface.create(this.plugin_interface));
                return reply;
            }
            if (object == null && method.equals("getDownloads")) {
                RPPluginInterface pi = RPPluginInterface.create(this.plugin_interface);
                RPDownloadManager dm = (RPDownloadManager)pi._process(new RPRequest(null, "getDownloadManager", null)).getResponse();
                RPReply rep = dm._process(new RPRequest(null, "getDownloads", null));
                rep.setProperty("azureus_name", pi.azureus_name);
                rep.setProperty("azureus_version", pi.azureus_version);
                return rep;
            }
            if (object == null) {
                throw new RPException("Object identifier missing from request");
            }
            object = RPObject._lookupLocal(object._getOID());
            object._setLocal();
            if (method.equals("_refresh")) {
                RPReply reply = new RPReply(object);
                return reply;
            }
            String name = object._getName();
            if (access_controller != null) {
                access_controller.checkAccess(name, request2);
            }
            RPReply reply = object._process(request2);
            if (name.equals("IPFilter") && method.equals("setInRangeAddressesAreAllowed[boolean]") && request2.getClientIP() != null) {
                String client_ip = request2.getClientIP();
                boolean b = (Boolean)request2.getParams()[0];
                LoggerChannel[] channels = this.plugin_interface.getLogger().getChannels();
                IPFilter filter = this.plugin_interface.getIPFilter();
                if (b) {
                    if (filter.isInRange(client_ip)) {
                        int i = 0;
                        while (i < channels.length) {
                            channels[i].log(1, "Adding range for client '" + client_ip + "' as allow/deny flag changed to allow");
                            ++i;
                        }
                        filter.createAndAddRange("auto-added for remote interface", client_ip, client_ip, false);
                        filter.save();
                        this.plugin_interface.getPluginconfig().save();
                    }
                } else {
                    IPRange[] ranges = filter.getRanges();
                    int i = 0;
                    while (i < ranges.length) {
                        if (ranges[i].isInRange(client_ip)) {
                            int j = 0;
                            while (j < channels.length) {
                                channels[j].log(1, "deleting range '" + ranges[i].getStartIP() + "-" + ranges[i].getEndIP() + "' for client '" + client_ip + "' as allow/deny flag changed to deny");
                                ++j;
                            }
                            ranges[i].delete();
                        }
                        ++i;
                    }
                    filter.save();
                    this.plugin_interface.getPluginconfig().save();
                }
            }
            return reply;
        }
        catch (RPException e) {
            return new RPReply(e);
        }
        catch (Throwable e) {
            return new RPReply(new RPException("server execution fails", e));
        }
    }

    protected static class replyCache {
        protected long id;
        protected RPReply reply;

        protected replyCache(long _id, RPReply _reply) {
            this.id = _id;
            this.reply = _reply;
        }

        protected long getId() {
            return this.id;
        }

        protected RPReply getReply() {
            return this.reply;
        }
    }
}

