/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;

public abstract class ResourceDownloaderBaseImpl
implements ResourceDownloader {
    protected List listeners = new ArrayList();
    protected boolean result_informed;
    protected Object result_informed_data;
    protected ResourceDownloaderBaseImpl parent;
    protected List children = new ArrayList();
    protected boolean download_cancelled;
    protected AEMonitor this_mon = new AEMonitor("ResourceDownloader");

    protected ResourceDownloaderBaseImpl(ResourceDownloaderBaseImpl _parent) {
        this.parent = _parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public abstract ResourceDownloader getClone(ResourceDownloaderBaseImpl var1);

    protected void setParent(ResourceDownloader _parent) {
        ResourceDownloaderBaseImpl old_parent = this.parent;
        this.parent = (ResourceDownloaderBaseImpl)_parent;
        if (old_parent != null) {
            old_parent.removeChild(this);
        }
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    protected ResourceDownloaderBaseImpl getParent() {
        return this.parent;
    }

    protected void addChild(ResourceDownloaderBaseImpl kid) {
        this.children.add(kid);
    }

    protected void removeChild(ResourceDownloaderBaseImpl kid) {
        this.children.remove(kid);
    }

    protected List getChildren() {
        return this.children;
    }

    protected String getLogIndent() {
        String indent = "";
        ResourceDownloaderBaseImpl pos = this.parent;
        while (pos != null) {
            indent = String.valueOf(indent) + "  ";
            pos = pos.getParent();
        }
        return indent;
    }

    protected void addReportListener(ResourceDownloader rd) {
        rd.addListener(new ResourceDownloaderAdapter(){

            public void reportActivity(ResourceDownloader downloader, String activity) {
                ResourceDownloaderBaseImpl.this.informActivity(activity);
            }

            public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                ResourceDownloaderBaseImpl.this.informActivity(String.valueOf(downloader.getName()) + ":" + e.getMessage());
            }
        });
    }

    protected void informPercentDone(int percentage) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ResourceDownloaderListener)this.listeners.get(i)).reportPercentComplete(this, percentage);
            ++i;
        }
    }

    public void reportActivity(String str) {
        this.informActivity(str);
    }

    protected void informActivity(String activity) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ResourceDownloaderListener)this.listeners.get(i)).reportActivity(this, activity);
            ++i;
        }
    }

    protected boolean informComplete(InputStream is) {
        if (!this.result_informed) {
            int i = 0;
            while (i < this.listeners.size()) {
                if (!((ResourceDownloaderListener)this.listeners.get(i)).completed(this, is)) {
                    return false;
                }
                ++i;
            }
            this.result_informed = true;
            this.result_informed_data = is;
        }
        return true;
    }

    protected void informFailed(ResourceDownloaderException e) {
        if (!this.result_informed) {
            this.result_informed = true;
            this.result_informed_data = e;
            int i = 0;
            while (i < this.listeners.size()) {
                ((ResourceDownloaderListener)this.listeners.get(i)).failed(this, e);
                ++i;
            }
        }
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.informActivity(activity);
    }

    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
        this.informPercentDone(percentage);
    }

    protected void setCancelled() {
        this.download_cancelled = true;
    }

    public boolean isCancelled() {
        return this.download_cancelled;
    }

    public void addListener(ResourceDownloaderListener l) {
        this.listeners.add(l);
        if (this.result_informed) {
            if (this.result_informed_data instanceof InputStream) {
                l.completed(this, (InputStream)this.result_informed_data);
            } else {
                l.failed(this, (ResourceDownloaderException)this.result_informed_data);
            }
        }
    }

    public void removeListener(ResourceDownloaderListener l) {
        this.listeners.remove(l);
    }
}

