/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class PasswordParameterImpl
extends ParameterImpl
implements PasswordParameter {
    protected byte[] defaultValue;
    protected int encoding_type;

    public PasswordParameterImpl(PluginConfig config, String key, String label, int _encoding_type, byte[] _defaultValue) {
        super(config, key, label);
        if (_defaultValue == null) {
            this.defaultValue = new byte[0];
        } else {
            this.defaultValue = _defaultValue;
            if (_encoding_type == 2) {
                SHA1Hasher hasher = new SHA1Hasher();
                this.defaultValue = hasher.calculateHash(this.defaultValue);
            }
        }
        COConfigurationManager.setByteDefault(this.getKey(), this.defaultValue);
        this.encoding_type = _encoding_type;
    }

    public byte[] getDefaultValue() {
        return this.defaultValue;
    }

    public int getEncodingType() {
        return this.encoding_type;
    }

    public byte[] getValue() {
        return this.config.getByteParameter(this.getKey(), this.getDefaultValue());
    }
}

