/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerPeer;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerPeerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentRequestImpl;

public class TrackerTorrentImpl
implements TrackerTorrent,
TRHostTorrentListener,
TRHostTorrentWillBeRemovedListener {
    protected TRHostTorrent host_torrent;
    protected List listeners = new ArrayList();
    protected List removal_listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TrackerTorrent");

    public TrackerTorrentImpl(TRHostTorrent _host_torrent) {
        this.host_torrent = _host_torrent;
    }

    protected TRHostTorrent getHostTorrent() {
        return this.host_torrent;
    }

    public void remove() throws TrackerTorrentRemovalVetoException {
        try {
            this.host_torrent.remove();
        }
        catch (TRHostTorrentRemovalVetoException e) {
            throw new TrackerTorrentRemovalVetoException(e.getMessage());
        }
    }

    public boolean canBeRemoved() throws TrackerTorrentRemovalVetoException {
        try {
            this.host_torrent.canBeRemoved();
        }
        catch (TRHostTorrentRemovalVetoException e) {
            throw new TrackerTorrentRemovalVetoException(e.getMessage());
        }
        return true;
    }

    public Torrent getTorrent() {
        return new TorrentImpl(this.host_torrent.getTorrent());
    }

    public TrackerPeer[] getPeers() {
        TRHostPeer[] peers = this.host_torrent.getPeers();
        TrackerPeer[] res = new TrackerPeer[peers.length];
        int i = 0;
        while (i < peers.length) {
            res[i] = new TrackerPeerImpl(peers[i]);
            ++i;
        }
        return res;
    }

    public int getStatus() {
        int status = this.host_torrent.getStatus();
        switch (status) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        throw new RuntimeException("TrackerTorrent: status invalid");
    }

    public long getTotalUploaded() {
        return this.host_torrent.getTotalUploaded();
    }

    public long getTotalDownloaded() {
        return this.host_torrent.getTotalDownloaded();
    }

    public long getAverageUploaded() {
        return this.host_torrent.getAverageUploaded();
    }

    public long getAverageDownloaded() {
        return this.host_torrent.getAverageDownloaded();
    }

    public long getTotalLeft() {
        return this.host_torrent.getTotalLeft();
    }

    public long getCompletedCount() {
        return this.host_torrent.getCompletedCount();
    }

    public long getTotalBytesIn() {
        return this.host_torrent.getTotalBytesIn();
    }

    public long getAverageBytesIn() {
        return this.host_torrent.getAverageBytesIn();
    }

    public long getTotalBytesOut() {
        return this.host_torrent.getTotalBytesOut();
    }

    public long getAverageBytesOut() {
        return this.host_torrent.getAverageBytesOut();
    }

    public long getScrapeCount() {
        return this.host_torrent.getScrapeCount();
    }

    public long getAnnounceCount() {
        return this.host_torrent.getAnnounceCount();
    }

    public int getSeedCount() {
        return this.host_torrent.getSeedCount();
    }

    public int getLeecherCount() {
        return this.host_torrent.getLeecherCount();
    }

    public int getBadNATCount() {
        return this.host_torrent.getBadNATCount();
    }

    public void disableReplyCaching() {
        this.host_torrent.disableReplyCaching();
    }

    public void postProcess(TRHostTorrentRequest request2) throws TRHostException {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((TrackerTorrentListener)this.listeners.get(i)).postProcess(new TrackerTorrentRequestImpl(request2));
                }
                catch (TrackerException e) {
                    throw new TRHostException("Post process fails", e);
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListener(TrackerTorrentListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.add(listener);
            if (this.listeners.size() == 1) {
                this.host_torrent.addListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeListener(TrackerTorrentListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.host_torrent.removeListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void torrentWillBeRemoved(TRHostTorrent t) throws TRHostTorrentRemovalVetoException {
        int i = 0;
        while (i < this.removal_listeners.size()) {
            try {
                ((TrackerTorrentWillBeRemovedListener)this.removal_listeners.get(i)).torrentWillBeRemoved(this);
            }
            catch (TrackerTorrentRemovalVetoException e) {
                throw new TRHostTorrentRemovalVetoException(e.getMessage());
            }
            ++i;
        }
    }

    public void addRemovalListener(TrackerTorrentWillBeRemovedListener listener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(listener);
            if (this.removal_listeners.size() == 1) {
                this.host_torrent.addRemovalListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeRemovalListener(TrackerTorrentWillBeRemovedListener listener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(listener);
            if (this.removal_listeners.size() == 0) {
                this.host_torrent.removeRemovalListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

