/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentFile;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAnnounceURLListImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentFileImpl;

public class TorrentImpl
implements Torrent {
    protected TOTorrent torrent;
    protected LocaleUtilDecoder decoder;

    public TorrentImpl(TOTorrent _torrent) {
        this.torrent = _torrent;
        try {
            this.decoder = LocaleUtil.getSingleton().getTorrentEncoding(this.torrent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getName() {
        String name = this.decode(this.torrent.getName());
        name = FileUtil.convertOSSpecificChars(name);
        return name;
    }

    public URL getAnnounceURL() {
        return this.torrent.getAnnounceURL();
    }

    public void setAnnounceURL(URL url) {
        this.torrent.setAnnounceURL(url);
        this.updated();
    }

    public TorrentAnnounceURLList getAnnounceURLList() {
        return new TorrentAnnounceURLListImpl(this);
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public byte[] getHash() {
        try {
            return this.torrent.getHash();
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public long getSize() {
        return this.torrent.getSize();
    }

    public String getComment() {
        return this.decode(this.torrent.getComment());
    }

    public void setComment(String comment) {
        this.torrent.setComment(comment);
    }

    public long getCreationDate() {
        return this.torrent.getCreationDate();
    }

    public String getCreatedBy() {
        return this.decode(this.torrent.getCreatedBy());
    }

    public long getPieceSize() {
        return this.torrent.getPieceLength();
    }

    public long getPieceCount() {
        return this.torrent.getNumberOfPieces();
    }

    public TorrentFile[] getFiles() {
        TOTorrentFile[] files = this.torrent.getFiles();
        TorrentFile[] res = new TorrentFile[files.length];
        int i = 0;
        while (i < res.length) {
            TOTorrentFile tf = files[i];
            byte[][] comps = tf.getPathComponents();
            String name = "";
            int j = 0;
            while (j < comps.length) {
                String comp = this.decode(comps[j]);
                comp = FileUtil.convertOSSpecificChars(comp);
                name = String.valueOf(name) + (j == 0 ? "" : File.separator) + comp;
                ++j;
            }
            res[i] = new TorrentFileImpl(name, tf.getLength());
            ++i;
        }
        return res;
    }

    public String getEncoding() {
        if (this.decoder != null) {
            return this.decoder.getName();
        }
        return "UTF8";
    }

    protected String decode(byte[] data) {
        if (data != null) {
            if (this.decoder != null) {
                try {
                    return this.decoder.decodeString(data);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new String(data);
        }
        return "";
    }

    public Object getAdditionalProperty(String name) {
        return this.torrent.getAdditionalProperty(name);
    }

    public Map writeToMap() throws TorrentException {
        try {
            return this.torrent.serialiseToMap();
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::writeToMap: fails", e);
        }
    }

    public void writeToFile(File file) throws TorrentException {
        try {
            TorrentUtils.writeToFile(this.torrent, file);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::writeToFile: fails", e);
        }
    }

    protected void updated() {
        try {
            DownloadImpl dm = (DownloadImpl)DownloadManagerImpl.getDownloadStatic(this.torrent);
            if (dm != null) {
                dm.torrentChanged();
            }
        }
        catch (DownloadException downloadException) {
            // empty catch block
        }
    }

    public void save() throws TorrentException {
        try {
            TorrentUtils.writeToFile(this.torrent);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::save Fails", e);
        }
    }

    public void setComplete(File data_dir) throws TorrentException {
        try {
            LocaleUtil.getSingleton().setDefaultTorrentEncoding(this.torrent);
            DownloadManagerState download_manager_state = DownloadManagerStateFactory.getDownloadState(this.torrent);
            TorrentUtils.setResumeDataCompletelyValid(download_manager_state, data_dir.toString());
            download_manager_state.save();
        }
        catch (Throwable e) {
            throw new TorrentException("encoding selection fails", e);
        }
    }
}

