/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;

public class DownloadAnnounceResultImpl
implements DownloadAnnounceResult {
    protected DownloadImpl download;
    protected TRTrackerResponse response;

    protected DownloadAnnounceResultImpl(DownloadImpl _download, TRTrackerResponse _response) {
        this.download = _download;
        this.response = _response;
    }

    protected void setContent(TRTrackerResponse _response) {
        this.response = _response;
    }

    public Download getDownload() {
        return this.download;
    }

    public int getResponseType() {
        if (this.response == null) {
            return 2;
        }
        int status = this.response.getStatus();
        if (status == 2) {
            return 1;
        }
        return 2;
    }

    public int getReportedPeerCount() {
        return this.response == null ? 0 : this.response.getPeers().length;
    }

    public int getSeedCount() {
        PEPeerManager pm = this.download.getDownload().getPeerManager();
        if (pm != null) {
            return pm.getNbSeeds();
        }
        return 0;
    }

    public int getNonSeedCount() {
        PEPeerManager pm = this.download.getDownload().getPeerManager();
        if (pm != null) {
            return pm.getNbPeers();
        }
        return 0;
    }

    public String getError() {
        return this.response == null ? "No Response" : this.response.getFailureReason();
    }
}

