/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class TimerEventPeriodic
implements TimerEventPerformer {
    protected Timer timer;
    protected long frequency;
    protected TimerEventPerformer performer;
    protected TimerEvent current_event;
    protected boolean cancelled;

    protected TimerEventPeriodic(Timer _timer, long _frequency, TimerEventPerformer _performer) {
        this.timer = _timer;
        this.frequency = _frequency;
        this.performer = _performer;
        this.current_event = this.timer.addEvent(SystemTime.getCurrentTime() + this.frequency, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(TimerEvent event) {
        if (!this.cancelled) {
            try {
                this.performer.perform(event);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            TimerEventPeriodic timerEventPeriodic = this;
            synchronized (timerEventPeriodic) {
                if (!this.cancelled) {
                    this.current_event = this.timer.addEvent(SystemTime.getCurrentTime() + this.frequency, this);
                }
            }
        }
    }

    public synchronized void cancel() {
        if (this.current_event != null) {
            this.current_event.cancel();
            this.cancelled = true;
        }
    }
}

