/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEDiagnostics {
    public static final boolean ALWAYS_PASS_HASH_CHECKS = false;
    public static final boolean USE_DUMMY_FILE_DATA = false;
    public static final boolean CHECK_DUMMY_FILE_DATA = false;
    public static final boolean DEBUG_MONITOR_SEM_USAGE = false;
    public static final boolean TRACE_DIRECT_BYTE_BUFFERS = false;
    public static final boolean TRACE_DBB_POOL_USAGE = false;
    public static final boolean PRINT_DBB_POOL_USAGE = false;
    private static final int MAX_FILE_SIZE = 131072;
    private static final String CONFIG_KEY = "diagnostics.tidy_close";
    private static File debug_dir;
    private static File debug_save_dir;
    private static boolean started_up;
    private static Map loggers;

    static {
        loggers = new HashMap();
    }

    public static synchronized void startup() {
        block9: {
            if (started_up) {
                return;
            }
            started_up = true;
            try {
                debug_dir = FileUtil.getUserFile("logs");
                debug_save_dir = new File(debug_dir, "save");
                boolean was_tidy = COConfigurationManager.getBooleanParameter(CONFIG_KEY);
                COConfigurationManager.setParameter(CONFIG_KEY, false);
                COConfigurationManager.save();
                if (debug_dir.exists()) {
                    debug_save_dir.mkdir();
                    File[] files = debug_dir.listFiles();
                    if (files != null) {
                        boolean file_moved = false;
                        long now = SystemTime.getCurrentTime();
                        int i = 0;
                        while (i < files.length) {
                            File file = files[i];
                            if (!file.isDirectory() && !was_tidy) {
                                file_moved = true;
                                FileUtil.renameFile(file, new File(debug_save_dir, String.valueOf(now) + "_" + file.getName()));
                            }
                            ++i;
                        }
                        if (file_moved) {
                            LGLogger.logUnrepeatableAlertUsingResource(1, "diagnostics.log_found", new String[]{debug_save_dir.toString()});
                        }
                    }
                } else {
                    debug_dir.mkdir();
                }
            }
            catch (Throwable e) {
                if (e instanceof NoClassDefFoundError) break block9;
                Debug.printStackTrace(e);
            }
        }
    }

    public static synchronized AEDiagnosticsLogger getLogger(String name) {
        AEDiagnosticsLogger logger = (AEDiagnosticsLogger)loggers.get(name);
        if (logger == null) {
            AEDiagnostics.startup();
            logger = new AEDiagnosticsLogger(name);
            try {
                File f1 = AEDiagnostics.getLogFile(logger);
                logger.setFirstFile(false);
                File f2 = AEDiagnostics.getLogFile(logger);
                logger.setFirstFile(true);
                if (f1.exists() && f2.exists() && f1.lastModified() < f2.lastModified()) {
                    logger.setFirstFile(false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            loggers.put(name, logger);
        }
        return logger;
    }

    protected static synchronized void log(AEDiagnosticsLogger logger, String str) {
        try {
            File log_file = AEDiagnostics.getLogFile(logger);
            if (log_file.exists() && log_file.length() >= 131072L) {
                logger.setFirstFile(!logger.isFirstFile());
                log_file = AEDiagnostics.getLogFile(logger);
                if (log_file.exists()) {
                    log_file.delete();
                }
            }
            Calendar now = GregorianCalendar.getInstance();
            String timeStamp = "[" + now.get(11) + ":" + AEDiagnostics.format(now.get(12)) + ":" + AEDiagnostics.format(now.get(13)) + "] ";
            str = String.valueOf(timeStamp) + str;
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(log_file, true));
                pw.println(str);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static File getLogFile(AEDiagnosticsLogger logger) {
        return new File(debug_dir, String.valueOf(logger.getName()) + "_" + (logger.isFirstFile() ? "1" : "2") + ".log");
    }

    private static String format(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    protected static void log(AEDiagnosticsLogger logger, Throwable e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            e.printStackTrace(pw);
            pw.close();
            AEDiagnostics.log(logger, baos.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void shutdown() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, true);
            COConfigurationManager.save();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

