/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.test;

import java.util.Random;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerClientClassicImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class LoadTest {
    static int ST_READY = 0;
    static int ST_STARTED = 1;
    static int ST_COMPLETED = 2;
    static int ST_STOPPED = 3;
    int address1 = 0;
    int address2 = 0;
    int address3 = 0;
    int address4 = 0;
    int num_clients = 100000;
    loadTestClient[] clients;
    Random random = new Random(12345L);
    TRTrackerServerTorrentImpl torrent;

    protected LoadTest() {
        int timeout;
        TRTrackerServerImpl.RETRY_MINIMUM_SECS = timeout = 10;
        TRTrackerServerImpl.RETRY_MINIMUM_MILLIS = timeout * 1000;
        TRTrackerServerImpl.TIMEOUT_CHECK = timeout * 1000;
        TRTrackerServerImpl.max_seed_retention = 3000;
        TRTrackerServerImpl server = new TRTrackerServerImpl("test"){

            public int getPort() {
                return 1234;
            }

            public String getHost() {
                return "fred";
            }

            public boolean isSSL() {
                return false;
            }

            public void addRequestListener(TRTrackerServerRequestListener l) {
            }

            public void removeRequestListener(TRTrackerServerRequestListener l) {
            }
        };
        try {
            this.torrent = (TRTrackerServerTorrentImpl)server.permit("jkjkjkj".getBytes(), true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.clients = new loadTestClient[this.num_clients];
        int i = 0;
        while (i < this.clients.length) {
            this.clients[i] = new loadTestClient();
            ++i;
        }
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        long initial_mem = rt.totalMemory() - rt.freeMemory();
        long initial_time = System.currentTimeMillis() - 1L;
        System.out.println("used = " + initial_mem);
        int loop = 0;
        while (true) {
            loadTestClient client;
            int state;
            if (++loop % 10000 == 0) {
                System.out.println(String.valueOf(loop) + ": peers = " + this.torrent.getPeerCount() + ",seeds = " + this.torrent.getSeedCount() + ", leechers = " + this.torrent.getLeecherCount());
                rt.gc();
                long current_mem = rt.totalMemory() - rt.freeMemory();
                long mem_per_peer = (current_mem - initial_mem) / (long)this.torrent.getPeerCount();
                long now = System.currentTimeMillis();
                System.out.println("used = " + (rt.totalMemory() - rt.freeMemory()) + ": per peer = " + mem_per_peer + ", per sec = " + (long)loop * 1000L / (now - initial_time));
            }
            if ((state = (client = this.clients[(int)(this.random.nextDouble() * (double)this.clients.length)]).getState()) == ST_READY) {
                client.start();
                continue;
            }
            if (state == ST_STARTED) {
                if (this.chance(2)) {
                    client.update();
                    continue;
                }
                if (this.chance(10)) {
                    client.changeAddress();
                    continue;
                }
                if (this.chance(10)) {
                    client.reset();
                    continue;
                }
                if (this.chance(20)) {
                    this.address4 = 0;
                    continue;
                }
                client.complete();
                continue;
            }
            if (state == ST_COMPLETED) {
                client.stop();
                continue;
            }
            if (state != ST_STOPPED) continue;
            client.reset();
        }
    }

    protected boolean chance(int one_in) {
        return (int)(this.random.nextDouble() * (double)one_in) == 0;
    }

    public static void main(String[] args) {
        new LoadTest();
    }

    class loadTestClient {
        int state = ST_READY;
        HashWrapper peer_id;
        String key;
        String address;
        int uploaded;
        int downloaded;
        int left = 100;
        int interval = 10;
        int num_want = 100;

        loadTestClient() {
            try {
                this.peer_id = new HashWrapper(TRTrackerClientClassicImpl.createPeerID());
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            this.key = TRTrackerClientClassicImpl.createKeyID();
            this.changeAddress();
        }

        int getState() {
            return this.state;
        }

        void setState(int _state) {
            this.state = _state;
        }

        void changeAddress() {
            this.address = String.valueOf(LoadTest.this.address1) + "." + LoadTest.this.address2 + "." + LoadTest.this.address3 + "." + LoadTest.this.address4;
            if (++LoadTest.this.address4 == 256) {
                LoadTest.this.address4 = 0;
                if (++LoadTest.this.address3 == 256) {
                    LoadTest.this.address3 = 0;
                    if (++LoadTest.this.address2 == 256) {
                        LoadTest.this.address2 = 0;
                        ++LoadTest.this.address1;
                    }
                }
            }
        }

        void reset() {
            this.state = ST_READY;
            this.left = 100;
            try {
                this.peer_id = new HashWrapper(TRTrackerClientClassicImpl.createPeerID());
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        void start() {
            try {
                LoadTest.this.torrent.peerContact("started", this.peer_id, 6881, this.address, false, this.key, this.uploaded, this.downloaded, this.left, this.interval);
                LoadTest.this.torrent.exportAnnounceToMap(null, true, this.num_want, 4L, true, true);
                this.state = ST_STARTED;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        void stop() {
            try {
                LoadTest.this.torrent.peerContact("stopped", this.peer_id, 6881, this.address, false, this.key, this.uploaded, this.downloaded, this.left, this.interval);
                this.state = ST_STOPPED;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        void update() {
            try {
                this.left = 0;
                this.uploaded += 10000;
                LoadTest.this.torrent.peerContact(null, this.peer_id, 6881, this.address, false, this.key, this.uploaded, this.downloaded, this.left, this.interval);
                LoadTest.this.torrent.exportAnnounceToMap(null, true, this.num_want, 4L, true, true);
                this.state = ST_COMPLETED;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        void complete() {
            try {
                this.left = 0;
                LoadTest.this.torrent.peerContact("complete", this.peer_id, 6881, this.address, false, this.key, this.uploaded, this.downloaded, this.left, this.interval);
                LoadTest.this.torrent.exportAnnounceToMap(null, true, this.num_want, 4L, true, true);
                this.state = ST_COMPLETED;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

