/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerRequestImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;

public class TRTrackerServerTCP
extends TRTrackerServerImpl {
    protected static int THREAD_POOL_SIZE = COConfigurationManager.getIntParameter("Tracker Max Threads");
    public static long PROCESSING_GET_LIMIT = COConfigurationManager.getIntParameter("Tracker Max GET Time") * 1000;
    public static int PROCESSING_POST_MULTIPLIER = COConfigurationManager.getIntParameter("Tracker Max POST Time Multiplier");
    protected String name;
    protected boolean ssl;
    protected int port;
    protected boolean apply_ip_filter;
    protected Vector request_listeners = new Vector();
    protected ThreadPool thread_pool;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServerTCP");
    int req_num;
    static boolean LOG_DOS_TO_FILE;
    protected static File dos_log_file;
    protected static AEMonitor class_mon;
    Map DOS_map = new LinkedHashMap(1000, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return TRTrackerServerTCP.this.checkDOSRemove(eldest);
        }
    };
    List dos_list = new ArrayList(128);
    long last_dos_check = 0L;
    long MAX_DOS_ENTRIES = 10000L;
    long MAX_DOS_RETENTION = 10000L;
    int DOS_CHECK_DEAD_WOOD_COUNT = 512;
    int DOS_MIN_INTERVAL = 1000;
    int dos_check_count = 0;

    static {
        if (THREAD_POOL_SIZE <= 0) {
            THREAD_POOL_SIZE = 1;
        }
        if (PROCESSING_GET_LIMIT < 0L) {
            PROCESSING_GET_LIMIT = 0L;
        }
        if (PROCESSING_POST_MULTIPLIER < 0) {
            PROCESSING_POST_MULTIPLIER = 0;
        }
        LOG_DOS_TO_FILE = false;
        LOG_DOS_TO_FILE = System.getProperty("azureus.log.dos") != null;
        class_mon = new AEMonitor("TRTrackerServerTCP:class");
    }

    public TRTrackerServerTCP(String _name, int _port, boolean _ssl, boolean _apply_ip_filter) throws TRTrackerServerException {
        super(_name);
        this.port = _port;
        this.ssl = _ssl;
        this.apply_ip_filter = _apply_ip_filter;
        this.thread_pool = new ThreadPool("TrackerServer:TCP:" + this.port, THREAD_POOL_SIZE);
        if (PROCESSING_GET_LIMIT > 0L) {
            this.thread_pool.setExecutionLimit(PROCESSING_GET_LIMIT);
        }
        this.current_announce_retry_interval = COConfigurationManager.getIntParameter("Tracker Poll Interval Min", 120);
        if (this.current_announce_retry_interval < (long)TRTrackerServerImpl.RETRY_MINIMUM_SECS) {
            this.current_announce_retry_interval = TRTrackerServerImpl.RETRY_MINIMUM_SECS;
        }
        String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
        if (_ssl) {
            try {
                SSLServerSocketFactory factory = SESecurityManager.getSSLServerSocketFactory();
                if (factory == null) {
                    throw new TRTrackerServerException("TRTrackerServer: failed to get SSL factory");
                }
                SSLServerSocket ssl_server_socket = bind_ip.length() < 7 ? (SSLServerSocket)factory.createServerSocket(this.port, 128) : (SSLServerSocket)factory.createServerSocket(this.port, 128, InetAddress.getByName(bind_ip));
                String[] cipherSuites = ssl_server_socket.getSupportedCipherSuites();
                ssl_server_socket.setEnabledCipherSuites(cipherSuites);
                ssl_server_socket.setNeedClientAuth(false);
                ssl_server_socket.setReuseAddress(true);
                final SSLServerSocket f_ss = ssl_server_socket;
                AEThread accept_thread = new AEThread("TRTrackerServer:accept.loop(ssl)"){

                    public void runSupport() {
                        TRTrackerServerTCP.this.acceptLoop(f_ss);
                    }
                };
                accept_thread.setDaemon(true);
                accept_thread.start();
                LGLogger.log("TRTrackerServer: SSL listener established on port " + this.port);
            }
            catch (Throwable e) {
                LGLogger.logUnrepeatableAlertUsingResource(3, "Tracker.alert.listenfail", new String[]{"" + this.port});
                LGLogger.log("TRTrackerServer: SSL listener failed on port " + this.port, e);
                if (e instanceof TRTrackerServerException) {
                    throw (TRTrackerServerException)e;
                }
                throw new TRTrackerServerException("TRTrackerServer: accept fails: " + e.toString());
            }
        }
        try {
            ServerSocket ss = bind_ip.length() < 7 ? new ServerSocket(this.port, 128) : new ServerSocket(this.port, 128, InetAddress.getByName(bind_ip));
            ss.setReuseAddress(true);
            final ServerSocket f_ss = ss;
            AEThread accept_thread = new AEThread("TRTrackerServer:accept.loop"){

                public void runSupport() {
                    TRTrackerServerTCP.this.acceptLoop(f_ss);
                }
            };
            accept_thread.setDaemon(true);
            accept_thread.start();
            LGLogger.log("TRTrackerServer: listener established on port " + this.port);
        }
        catch (Throwable e) {
            LGLogger.logUnrepeatableAlertUsingResource(3, "Tracker.alert.listenfail", new String[]{"" + this.port});
            LGLogger.log("TRTrackerServer: listener failed on port " + this.port, e);
            throw new TRTrackerServerException("TRTrackerServer: accept fails: " + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void acceptLoop(ServerSocket ss) {
        long successfull_accepts = 0L;
        long failed_accepts = 0L;
        while (true) {
            try {
                while (true) {
                    Socket socket = ss.accept();
                    ++successfull_accepts;
                    String ip = socket.getInetAddress().getHostAddress();
                    if (!this.apply_ip_filter || !this.ip_filter.isInRange(ip, "Tracker")) {
                        this.thread_pool.run(new TRTrackerServerProcessorTCP(this, socket));
                        continue;
                    }
                    socket.close();
                }
            }
            catch (Throwable e) {
                LGLogger.log("TRTrackerServer: listener failed on port " + this.port, e);
                if (++failed_accepts <= 100L || successfull_accepts != 0L) continue;
                LGLogger.logUnrepeatableAlertUsingResource(3, "Network.alert.acceptfail", new String[]{"" + this.port, "TCP"});
                return;
            }
            break;
        }
    }

    protected boolean checkDOS(String ip) throws UnknownHostException {
        boolean res;
        InetAddress inet_address = InetAddress.getByName(ip);
        if (inet_address.isLoopbackAddress() || InetAddress.getLocalHost().equals(inet_address)) {
            return false;
        }
        this.last_dos_check = SystemTime.getCurrentTime();
        DOSEntry entry2 = (DOSEntry)this.DOS_map.get(ip);
        if (entry2 == null) {
            entry2 = new DOSEntry(ip);
            this.DOS_map.put(ip, entry2);
            res = false;
        } else {
            boolean bl = res = this.last_dos_check - entry2.last_time < (long)this.DOS_MIN_INTERVAL;
            if (res && LOG_DOS_TO_FILE) {
                this.dos_list.add(entry2);
            }
            entry2.last_time = this.last_dos_check;
        }
        ++this.dos_check_count;
        if (this.dos_check_count == this.DOS_CHECK_DEAD_WOOD_COUNT) {
            this.dos_check_count = 0;
            Iterator it = this.DOS_map.values().iterator();
            while (it.hasNext()) {
                DOSEntry this_entry = (DOSEntry)it.next();
                if (this.last_dos_check - this_entry.last_time <= this.MAX_DOS_RETENTION) break;
                it.remove();
            }
            if (this.dos_list.size() > 0) {
                try {
                    class_mon.enter();
                    if (dos_log_file == null) {
                        dos_log_file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "dos.log");
                    }
                    PrintWriter pw = null;
                    try {
                        try {
                            pw = new PrintWriter(new FileWriter(dos_log_file, true));
                            int i = 0;
                            while (i < this.dos_list.size()) {
                                DOSEntry this_entry = (DOSEntry)this.dos_list.get(i);
                                String ts = new SimpleDateFormat("hh:mm:ss - ").format(new Date(this_entry.last_time));
                                pw.println(String.valueOf(ts) + this_entry.ip);
                                ++i;
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    finally {
                        this.dos_list.clear();
                        if (pw != null) {
                            try {
                                pw.close();
                            }
                            catch (Throwable e) {}
                        }
                    }
                }
                finally {
                    class_mon.exit();
                }
            }
        }
        return res;
    }

    protected boolean checkDOSRemove(Map.Entry eldest) {
        boolean res = (long)this.DOS_map.size() > this.MAX_DOS_ENTRIES || this.last_dos_check - ((DOSEntry)eldest.getValue()).last_time > this.MAX_DOS_RETENTION;
        return res;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    public boolean isSSL() {
        return this.ssl;
    }

    protected boolean handleExternalRequest(String client_address, String url, String header, InputStream is, OutputStream os) throws IOException {
        int i = 0;
        while (i < this.listeners.size()) {
            TRTrackerServerListener listener;
            try {
                this.this_mon.enter();
                if (i >= this.listeners.size()) {
                    this.this_mon.exit();
                    break;
                }
                listener = (TRTrackerServerListener)this.listeners.elementAt(i);
            }
            finally {
                this.this_mon.exit();
            }
            if (listener.handleExternalRequest(client_address, url, header, is, os)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void postProcess(TRTrackerServerPeerImpl peer, TRTrackerServerTorrentImpl torrent, int type, Map response) throws TRTrackerServerException {
        if (this.request_listeners.size() > 0) {
            TRTrackerServerRequestImpl req = new TRTrackerServerRequestImpl(this, peer, torrent, type, response);
            int i = 0;
            while (i < this.request_listeners.size()) {
                ((TRTrackerServerRequestListener)this.request_listeners.elementAt(i)).postProcess(req);
                ++i;
            }
        }
    }

    public void addRequestListener(TRTrackerServerRequestListener l) {
        this.request_listeners.addElement(l);
    }

    public void removeRequestListener(TRTrackerServerRequestListener l) {
        this.request_listeners.removeElement(l);
    }

    protected class DOSEntry {
        String ip;
        long last_time;

        protected DOSEntry(String _ip) {
            this.ip = _ip;
            this.last_time = TRTrackerServerTCP.this.last_dos_check;
        }
    }
}

