/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.Permission;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SEKeyDetails;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerBC;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.Ignore;

public class SESecurityManagerImpl {
    protected static SESecurityManagerImpl singleton = new SESecurityManagerImpl();
    protected String keystore_name;
    protected String truststore_name;
    protected List certificate_listeners = new ArrayList();
    protected List password_listeners = new ArrayList();
    protected Map password_handlers = new HashMap();
    protected boolean exit_vm_permitted = false;
    protected AEMonitor this_mon = new AEMonitor("SESecurityManager");

    public static SESecurityManagerImpl getSingleton() {
        return singleton;
    }

    public void initialise() {
        this.keystore_name = FileUtil.getUserFile(".keystore").getAbsolutePath();
        this.truststore_name = FileUtil.getUserFile(".certs").getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", this.truststore_name);
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        this.installAuthenticator();
        try {
            Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            SESecurityManagerBC.initialise();
        }
        catch (Throwable e) {
            LGLogger.log(3, "Bouncy Castle not available");
        }
        this.installSecurityManager();
    }

    public String getKeystoreName() {
        return this.keystore_name;
    }

    public String getKeystorePassword() {
        return "changeit";
    }

    protected void installSecurityManager() {
        try {
            final SecurityManager old_sec_man = System.getSecurityManager();
            System.setSecurityManager(new SecurityManager(){

                public void checkExit(int status) {
                    if (old_sec_man != null) {
                        old_sec_man.checkExit(status);
                    }
                    if (!SESecurityManagerImpl.this.exit_vm_permitted) {
                        throw new SecurityException("VM exit operation prohibited");
                    }
                }

                public void checkPermission(Permission perm) {
                    if (perm instanceof RuntimePermission && perm.getName().equals("stopThread")) {
                        throw new SecurityException("Thread.stop operation prohibited");
                    }
                    if (old_sec_man != null) {
                        old_sec_man.checkPermission(perm);
                    }
                }

                public void checkPermission(Permission perm, Object context) {
                    if (perm instanceof RuntimePermission && perm.getName().equals("stopThread")) {
                        throw new SecurityException("Thread.stop operation prohibited");
                    }
                    if (old_sec_man != null) {
                        old_sec_man.checkPermission(perm, context);
                    }
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void exitVM(int status) {
        try {
            this.exit_vm_permitted = true;
            System.exit(status);
        }
        finally {
            this.exit_vm_permitted = false;
        }
    }

    public void installAuthenticator() {
        Authenticator.setDefault(new Authenticator(){
            protected AEMonitor auth_mon = new AEMonitor("SESecurityManager:auth");

            protected PasswordAuthentication getPasswordAuthentication() {
                try {
                    PasswordAuthentication res;
                    this.auth_mon.enter();
                    PasswordAuthentication passwordAuthentication = res = SESecurityManagerImpl.this.getAuthentication(this.getRequestingPrompt(), this.getRequestingProtocol(), this.getRequestingHost(), this.getRequestingPort());
                    this.auth_mon.exit();
                    return passwordAuthentication;
                }
                catch (Throwable throwable) {
                    this.auth_mon.exit();
                    throw throwable;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        try {
            try {
                this.this_mon.enter();
                URL tracker_url = new URL(String.valueOf(protocol) + "://" + host + ":" + port + "/");
                PasswordAuthentication passwordAuthentication = this.getPasswordAuthentication(realm, tracker_url);
                this.this_mon.exit();
                return passwordAuthentication;
            }
            catch (MalformedURLException e) {
                Debug.printStackTrace(e);
                PasswordAuthentication passwordAuthentication = null;
                this.this_mon.exit();
                return passwordAuthentication;
            }
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected boolean checkKeyStoreHasEntry() {
        File f = new File(this.keystore_name);
        if (!f.exists()) {
            LGLogger.logUnrepeatableAlertUsingResource(3, "Security.keystore.empty", new String[]{this.keystore_name});
            return false;
        }
        try {
            KeyStore key_store = this.loadKeyStore();
            Enumeration<String> enumx = key_store.aliases();
            if (!enumx.hasMoreElements()) {
                LGLogger.logUnrepeatableAlertUsingResource(3, "Security.keystore.empty", new String[]{this.keystore_name});
                return false;
            }
        }
        catch (Throwable e) {
            LGLogger.logUnrepeatableAlertUsingResource(3, "Security.keystore.corrupt", new String[]{this.keystore_name});
            return false;
        }
        return true;
    }

    protected KeyStore loadKeyStore() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        return this.loadKeyStore(keyManagerFactory);
    }

    protected KeyStore loadKeyStore(KeyManagerFactory keyManagerFactory) throws Exception {
        KeyStore key_store = KeyStore.getInstance("JKS");
        if (!new File(this.keystore_name).exists()) {
            key_store.load(null, null);
        } else {
            FileInputStream kis = null;
            try {
                kis = new FileInputStream(this.keystore_name);
                key_store.load(kis, "changeit".toCharArray());
            }
            finally {
                if (kis != null) {
                    ((InputStream)kis).close();
                }
            }
        }
        keyManagerFactory.init(key_store, "changeit".toCharArray());
        return key_store;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() throws Exception {
        if (!this.checkKeyStoreHasEntry()) {
            return null;
        }
        SSLContext context = SSLContext.getInstance("SSL");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.loadKeyStore(keyManagerFactory);
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        SSLServerSocketFactory factory = context.getServerSocketFactory();
        return factory;
    }

    public SEKeyDetails getKeyDetails(String alias) throws Exception {
        KeyStore key_store = this.loadKeyStore();
        final Key key = key_store.getKey(alias, "changeit".toCharArray());
        if (key == null) {
            return null;
        }
        Certificate[] chain = key_store.getCertificateChain(alias);
        final X509Certificate[] res = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            if (!(chain[i] instanceof X509Certificate)) {
                throw new Exception("Certificate chain must be comprised of X509Certificate entries");
            }
            res[i] = (X509Certificate)chain[i];
            ++i;
        }
        return new SEKeyDetails(){

            public Key getKey() {
                return key;
            }

            public X509Certificate[] getCertificateChain() {
                return res;
            }
        };
    }

    public void createSelfSignedCertificate(String alias, String cert_dn, int strength) throws Exception {
        SESecurityManagerBC.createSelfSignedCertificate(this, alias, cert_dn, strength);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean installServerCertificates(URL https_url) {
        try {
            this.this_mon.enter();
            String host = https_url.getHost();
            int port = https_url.getPort();
            if (port == -1) {
                port = 443;
            }
            Socket socket = null;
            try {
                void var13_19;
                X509Certificate x509_cert;
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory factory = sc.getSocketFactory();
                socket = (SSLSocket)factory.createSocket(host, port);
                ((SSLSocket)socket).startHandshake();
                Certificate[] serverCerts = ((SSLSocket)socket).getSession().getPeerCertificates();
                if (serverCerts.length == 0) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    this.this_mon.exit();
                    return false;
                }
                Certificate cert = serverCerts[0];
                if (cert instanceof X509Certificate) {
                    x509_cert = (X509Certificate)cert;
                } else {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    x509_cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                }
                String resource = https_url.toString();
                int param_pos = resource.indexOf("?");
                if (param_pos != -1) {
                    resource = resource.substring(0, param_pos);
                }
                int i = 0;
                while (var13_19 < this.certificate_listeners.size()) {
                    if (((SECertificateListener)this.certificate_listeners.get(i)).trustCertificate(resource, x509_cert)) {
                        String alias = host.concat(":").concat(String.valueOf(port));
                        this.addCertToTrustStore(alias, cert);
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        this.this_mon.exit();
                        return true;
                    }
                    ++var13_19;
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                this.this_mon.exit();
                return false;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable e2) {
                        Debug.printStackTrace(e2);
                    }
                }
                this.this_mon.exit();
                return false;
            }
            catch (Throwable throwable) {
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void addCertToKeyStore(String alias, Key public_key, Certificate[] certChain) throws Exception {
        try {
            this.this_mon.enter();
            KeyStore key_store = this.loadKeyStore();
            if (key_store.containsAlias(alias)) {
                key_store.deleteEntry(alias);
            }
            key_store.setKeyEntry(alias, public_key, "changeit".toCharArray(), certChain);
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(this.keystore_name);
                    key_store.store(out, "changeit".toCharArray());
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void addCertToTrustStore(String alias, Certificate cert) throws Exception {
        try {
            this.this_mon.enter();
            KeyStore keystore = KeyStore.getInstance("JKS");
            if (!new File(this.truststore_name).exists()) {
                keystore.load(null, null);
            } else {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(this.truststore_name);
                    keystore.load(in, "changeit".toCharArray());
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            if (cert != null) {
                if (keystore.containsAlias(alias)) {
                    keystore.deleteEntry(alias);
                }
                keystore.setCertificateEntry(alias, cert);
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.truststore_name);
                    keystore.store(out, "changeit".toCharArray());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keystore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        }
        finally {
            this.this_mon.exit();
        }
    }

    public PasswordAuthentication getPasswordAuthentication(String realm, URL tracker) {
        Object[] handler = (Object[])this.password_handlers.get(tracker.toString());
        if (handler != null) {
            return ((SEPasswordListener)handler[0]).getAuthentication(realm, (URL)handler[1]);
        }
        int i = 0;
        while (i < this.password_listeners.size()) {
            PasswordAuthentication res = ((SEPasswordListener)this.password_listeners.get(i)).getAuthentication(realm, tracker);
            if (res != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public void setPasswordAuthenticationOutcome(String realm, URL tracker, boolean success) {
        int i = 0;
        while (i < this.password_listeners.size()) {
            ((SEPasswordListener)this.password_listeners.get(i)).setAuthenticationOutcome(realm, tracker, success);
            ++i;
        }
    }

    public void addPasswordListener(SEPasswordListener l) {
        try {
            this.this_mon.enter();
            this.password_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removePasswordListener(SEPasswordListener l) {
        try {
            this.this_mon.enter();
            this.password_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addPasswordHandler(URL url, SEPasswordListener l) {
        String url_s = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + url.getPort() + "/";
        this.password_handlers.put(url_s, new Object[]{l, url});
    }

    public void removePasswordHandler(URL url, SEPasswordListener l) {
        Ignore.ignore(l);
        String url_s = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + url.getPort() + "/";
        this.password_handlers.remove(url_s);
    }

    public void addCertificateListener(SECertificateListener l) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeCertificateListener(SECertificateListener l) {
        try {
            this.this_mon.enter();
            this.certificate_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public static void main(String[] args) {
        SESecurityManagerImpl man = SESecurityManagerImpl.getSingleton();
        man.initialise();
        try {
            man.createSelfSignedCertificate("SomeAlias", "CN=fred,OU=wap,O=wip,L=here,ST=there,C=GB", 1000);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

