/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import org.gudy.azureus2.core3.peer.PEPiece;

public class EndGameModeChunk {
    private int blockNumber;
    private int pieceNumber;
    private int length;
    private int offset;

    public EndGameModeChunk(PEPiece piece, int blockNumber) {
        this.blockNumber = blockNumber;
        this.pieceNumber = piece.getPieceNumber();
        this.length = piece.getBlockSize(blockNumber);
        this.offset = 16384 * blockNumber;
    }

    public boolean compare(int pieceNumber, int offset) {
        return this.pieceNumber == pieceNumber && this.offset == offset;
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }
}

