/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.net.UnknownHostException;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;

public class IpRangeImpl
implements IpRange {
    private byte[] description;
    private Object startIp;
    private Object endIp;
    private boolean sessionOnly;
    private boolean added_to_range_list;
    private static final byte[][] frequent_words = new byte[][]{"ap2p".getBytes(), "city".getBytes(), "of".getBytes(), "proxy".getBytes(), "spider".getBytes(), ".com".getBytes(), "ads".getBytes(), "customer".getBytes(), "software".getBytes(), "government".getBytes(), "gmbh".getBytes(), "interconnexion".getBytes(), "backbone".getBytes()};

    public IpRangeImpl(String _description, String _startIp, String _endIp) {
        this(_description, _startIp, _endIp, true);
    }

    public IpRangeImpl(String _description, String _startIp, String _endIp, boolean _sessionOnly) {
        this.sessionOnly = _sessionOnly;
        if (_startIp == null || _endIp == null) {
            throw new RuntimeException("Invalid start/end values - null not supported");
        }
        this.startIp = _startIp.trim();
        this.endIp = _endIp.trim();
        this.internDescription(_description);
        this.checkValid();
    }

    public void checkValid() {
        if (this.startIp != null && this.endIp != null) {
            if (this.startIp instanceof String) {
                try {
                    this.startIp = new Integer(PRHelpers.addressToInt((String)this.startIp));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.endIp instanceof String) {
                try {
                    this.endIp = new Integer(PRHelpers.addressToInt((String)this.endIp));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        ((IpFilterImpl)IpFilterImpl.getInstance()).setValidOrNot(this, this.isValid());
    }

    public boolean isValid() {
        if (this.startIp instanceof Integer && this.endIp instanceof Integer) {
            long start_address = ((Integer)this.startIp).intValue();
            long end_address = ((Integer)this.endIp).intValue();
            if (start_address < 0L) {
                start_address += 0x100000000L;
            }
            if (end_address < 0L) {
                end_address += 0x100000000L;
            }
            return end_address >= start_address;
        }
        return false;
    }

    public boolean isInRange(String ipAddress) {
        if (!this.isValid()) {
            return false;
        }
        try {
            long int_address = PRHelpers.addressToInt(ipAddress);
            if (int_address < 0L) {
                int_address += 0x100000000L;
            }
            long start_address = ((Integer)this.startIp).intValue();
            long end_address = ((Integer)this.endIp).intValue();
            if (start_address < 0L) {
                start_address += 0x100000000L;
            }
            if (end_address < 0L) {
                end_address += 0x100000000L;
            }
            return int_address >= start_address && int_address <= end_address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public String getDescription() {
        return this.externDescription();
    }

    public void setDescription(String str) {
        this.internDescription(str);
    }

    protected void internDescription(String description_str) {
        if (description_str == null) {
            this.description = null;
            return;
        }
        byte[] bytes = description_str.toLowerCase().getBytes();
        int word_start = 0;
        this.description = new byte[bytes.length];
        int desc_pos = 0;
        int i = 0;
        while (i < bytes.length + 1) {
            int b;
            int n = b = i == bytes.length ? 32 : bytes[i];
            if (b < 0) {
                b = 95;
            }
            if (b == 32 || b == 46 || b == 45) {
                int j;
                int word_len = i - word_start;
                boolean hit = false;
                if (word_len > 1) {
                    j = 0;
                    while (j < frequent_words.length) {
                        byte[] fw = frequent_words[j];
                        if (fw.length == word_len) {
                            hit = true;
                            int k = word_start;
                            while (k < i) {
                                if (bytes[k] != fw[k - word_start]) {
                                    hit = false;
                                    break;
                                }
                                ++k;
                            }
                        }
                        if (hit) {
                            this.description[desc_pos++] = (byte)(128 + j);
                            break;
                        }
                        ++j;
                    }
                }
                if (!hit) {
                    j = word_start;
                    while (j < i) {
                        this.description[desc_pos++] = bytes[j] < 0 ? 95 : bytes[j];
                        ++j;
                    }
                }
                if (i < bytes.length) {
                    this.description[desc_pos++] = b;
                }
                word_start = i + 1;
            }
            ++i;
        }
        if (desc_pos < this.description.length) {
            byte[] d = new byte[desc_pos];
            System.arraycopy(this.description, 0, d, 0, desc_pos);
            this.description = d;
        }
    }

    protected String externDescription() {
        if (this.description == null) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < this.description.length) {
            byte b = this.description[i];
            if (b < 0) {
                res.append(new String(frequent_words[128 + b]));
            } else {
                res.append((char)b);
            }
            ++i;
        }
        return res.toString();
    }

    public String getStartIp() {
        return this.startIp instanceof Integer ? PRHelpers.intToAddress((Integer)this.startIp) : (String)this.startIp;
    }

    protected long getStartIpLong() {
        if (this.startIp instanceof Integer) {
            long val = ((Integer)this.startIp).intValue();
            if (val < 0L) {
                val += 0x100000000L;
            }
            return val;
        }
        return -1L;
    }

    public void setStartIp(String str) {
        if (str == null) {
            throw new RuntimeException("Invalid start value - null not supported");
        }
        if (str.equals(this.getStartIp())) {
            return;
        }
        this.startIp = str;
        this.checkValid();
    }

    public String getEndIp() {
        return this.endIp instanceof Integer ? PRHelpers.intToAddress((Integer)this.endIp) : (String)this.endIp;
    }

    protected long getEndIpLong() {
        if (this.endIp instanceof Integer) {
            long val = ((Integer)this.endIp).intValue();
            if (val < 0L) {
                val += 0x100000000L;
            }
            return val;
        }
        return -1L;
    }

    public void setEndIp(String str) {
        if (str == null) {
            throw new RuntimeException("Invalid end value - null not supported");
        }
        if (str.equals(this.getEndIp())) {
            return;
        }
        this.endIp = str;
        this.checkValid();
    }

    public String toString() {
        return String.valueOf(this.getDescription()) + " : " + this.getStartIp() + " - " + this.getEndIp();
    }

    public boolean isSessionOnly() {
        return this.sessionOnly;
    }

    public void setSessionOnly(boolean _sessionOnly) {
        this.sessionOnly = _sessionOnly;
    }

    public int compareStartIpTo(IpRange other) {
        long l = this.getStartIpLong() - ((IpRangeImpl)other).getStartIpLong();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    public int compareEndIpTo(IpRange other) {
        long l = this.getEndIpLong() - ((IpRangeImpl)other).getEndIpLong();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    public int compareDescription(IpRange other) {
        byte[] other_description = ((IpRangeImpl)other).description;
        if (this.description == null || other_description == null) {
            return 0;
        }
        int pos = 0;
        byte[] this_b = this.description;
        byte[] other_b = other_description;
        while (pos != this_b.length && pos != other_b.length) {
            byte[] new_b;
            int word_len;
            byte[] word;
            byte b1 = this_b[pos];
            byte b2 = other_b[pos];
            ++pos;
            if (b1 == b2) continue;
            if (b1 < 0) {
                word = frequent_words[128 + b1];
                word_len = word.length;
                new_b = new byte[word_len + this_b.length];
                System.arraycopy(word, 0, new_b, --pos, word_len);
                System.arraycopy(this_b, pos, new_b, pos + word_len, this_b.length - pos);
                this_b = new_b;
                b1 = this_b[pos++];
            }
            if (b2 < 0) {
                word = frequent_words[128 + b2];
                word_len = word.length;
                new_b = new byte[word_len + other_b.length];
                System.arraycopy(word, 0, new_b, --pos, word_len);
                System.arraycopy(other_b, pos, new_b, pos + word_len, other_b.length - pos);
                other_b = new_b;
                b2 = other_b[pos++];
            }
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return this_b.length - other_b.length;
    }

    protected void setAddedToRangeList(boolean b) {
        this.added_to_range_list = b;
    }

    protected boolean getAddedToRangeList() {
        return this.added_to_range_list;
    }
}

