/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import java.util.Arrays;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.util.Debug;

class GlobalManagerHostSupport
implements TRHostTorrentFinder {
    protected GlobalManager gm;
    protected TRHost host;

    protected GlobalManagerHostSupport(GlobalManager _gm) {
        this.gm = _gm;
        this.host = TRHostFactory.getSingleton();
        this.host.initialise(this);
    }

    public TOTorrent lookupTorrent(byte[] hash) {
        List managers = this.gm.getDownloadManagers();
        int i = 0;
        while (i < managers.size()) {
            DownloadManager dm = (DownloadManager)managers.get(i);
            TOTorrent t = dm.getTorrent();
            if (t != null) {
                try {
                    if (Arrays.equals(hash, t.getHash())) {
                        return t;
                    }
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
            ++i;
        }
        return null;
    }

    protected void destroy() {
        this.host.close();
    }
}

