/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAValidationParameters;

public class DSAParametersGenerator {
    private int size;
    private int certainty;
    private SecureRandom random;
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private static BigInteger TWO = BigInteger.valueOf(2L);

    public void init(int size, int certainty, SecureRandom random) {
        this.size = size;
        this.certainty = certainty;
        this.random = random;
    }

    private void add(byte[] a, byte[] b, int value) {
        int x = (b[b.length - 1] & 0xFF) + value;
        a[b.length - 1] = (byte)x;
        x >>>= 8;
        int i = b.length - 2;
        while (i >= 0) {
            a[i] = (byte)(x += b[i] & 0xFF);
            x >>>= 8;
            --i;
        }
    }

    public DSAParameters generateParameters() {
        BigInteger h;
        byte[] seed = new byte[20];
        byte[] part1 = new byte[20];
        byte[] part2 = new byte[20];
        byte[] u = new byte[20];
        SHA1Digest sha1 = new SHA1Digest();
        int n = (this.size - 1) / 160;
        byte[] w = new byte[this.size / 8];
        BigInteger q = null;
        BigInteger p = null;
        BigInteger g = null;
        int counter = 0;
        boolean primesFound = false;
        block0: while (!primesFound) {
            do {
                this.random.nextBytes(seed);
                sha1.update(seed, 0, seed.length);
                sha1.doFinal(part1, 0);
                System.arraycopy(seed, 0, part2, 0, seed.length);
                this.add(part2, seed, 1);
                sha1.update(part2, 0, part2.length);
                sha1.doFinal(part2, 0);
                int i = 0;
                while (i != u.length) {
                    u[i] = (byte)(part1[i] ^ part2[i]);
                    ++i;
                }
                u[0] = (byte)(u[0] | 0xFFFFFF80);
                u[19] = (byte)(u[19] | 1);
            } while (!(q = new BigInteger(1, u)).isProbablePrime(this.certainty));
            counter = 0;
            int offset = 2;
            while (counter < 4096) {
                int k = 0;
                while (k < n) {
                    this.add(part1, seed, offset + k);
                    sha1.update(part1, 0, part1.length);
                    sha1.doFinal(part1, 0);
                    System.arraycopy(part1, 0, w, w.length - (k + 1) * part1.length, part1.length);
                    ++k;
                }
                this.add(part1, seed, offset + n);
                sha1.update(part1, 0, part1.length);
                sha1.doFinal(part1, 0);
                System.arraycopy(part1, part1.length - (w.length - n * part1.length), w, 0, w.length - n * part1.length);
                w[0] = (byte)(w[0] | 0xFFFFFF80);
                BigInteger x = new BigInteger(1, w);
                BigInteger c = x.mod(q.multiply(TWO));
                p = x.subtract(c.subtract(ONE));
                if (p.testBit(this.size - 1) && p.isProbablePrime(this.certainty)) {
                    primesFound = true;
                    continue block0;
                }
                ++counter;
                offset += n + 1;
            }
        }
        BigInteger pMinusOneOverQ = p.subtract(ONE).divide(q);
        while ((h = new BigInteger(this.size, this.random)).compareTo(ONE) <= 0 || h.compareTo(p.subtract(ONE)) >= 0 || (g = h.modPow(pMinusOneOverQ, p)).compareTo(ONE) <= 0) {
        }
        return new DSAParameters(p, q, g, new DSAValidationParameters(seed, counter));
    }
}

