/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.device;

import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPRootDeviceImpl
implements UPnPRootDevice {
    protected UPnPImpl upnp;
    protected InetAddress local_address;
    protected URL location;
    protected URL url_base_for_relative_urls;
    protected UPnPDevice root_device;
    protected List listeners = new ArrayList();

    public UPnPRootDeviceImpl(UPnPImpl _upnp, InetAddress _local_address, URL _location) throws UPnPException {
        this.upnp = _upnp;
        this.local_address = _local_address;
        this.location = _location;
        SimpleXMLParserDocument doc = this.upnp.downloadXML(this.location);
        SimpleXMLParserDocumentNode url_base_node = doc.getChild("URLBase");
        try {
            String url_str;
            if (url_base_node != null && (url_str = url_base_node.getValue().trim()).length() > 0) {
                this.url_base_for_relative_urls = new URL(url_str);
            }
            this.upnp.log("Relative URL base is " + (this.url_base_for_relative_urls == null ? "unspecified" : this.url_base_for_relative_urls.toString()));
        }
        catch (MalformedURLException e) {
            this.upnp.log("Invalid URLBase - " + url_base_node.getValue());
            this.upnp.log(e);
            Debug.printStackTrace(e);
        }
        this.root_device = new UPnPDeviceImpl(this, "", doc.getChild("Device"));
    }

    protected String getAbsoluteURL(String url) {
        String lc_url = url.toLowerCase().trim();
        if (lc_url.startsWith("http://") || lc_url.startsWith("https://")) {
            return url;
        }
        if (this.url_base_for_relative_urls != null) {
            String abs_url = this.url_base_for_relative_urls.toString();
            if (!abs_url.endsWith("/")) {
                abs_url = String.valueOf(abs_url) + "/";
            }
            abs_url = url.startsWith("/") ? String.valueOf(abs_url) + url.substring(1) : String.valueOf(abs_url) + url;
            return abs_url;
        }
        String abs_url = this.location.toString();
        int p1 = abs_url.indexOf("://") + 3;
        p1 = abs_url.indexOf("/", p1);
        abs_url = abs_url.substring(0, p1);
        return String.valueOf(abs_url) + (url.startsWith("/") ? "" : "/") + url;
    }

    public UPnP getUPnP() {
        return this.upnp;
    }

    public InetAddress getLocalAddress() {
        return this.local_address;
    }

    public URL getLocation() {
        return this.location;
    }

    public UPnPDevice getDevice() {
        return this.root_device;
    }

    public void destroy(boolean replaced) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((UPnPRootDeviceListener)this.listeners.get(i)).lost(this, replaced);
            ++i;
        }
    }

    public void addListener(UPnPRootDeviceListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UPnPRootDeviceListener l) {
        this.listeners.remove(l);
    }
}

