/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.socks.impl;

import com.aelitis.azureus.core.proxy.AEProxyState;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LGLogger;

public class AESocksProxyState
implements AEProxyState {
    private AESocksProxyConnection socks_connection;
    protected ByteBuffer buffer;

    protected AESocksProxyState(AESocksProxyConnection _socks_connection) {
        this.socks_connection = _socks_connection;
        LGLogger.log(String.valueOf(this.socks_connection.getConnection().getName()) + ":" + this.getStateName());
    }

    public String getStateName() {
        String state = this.getClass().getName();
        int pos = state.indexOf("$");
        state = state.substring(pos + 1);
        return state;
    }

    public final void read(SocketChannel sc) throws IOException {
        try {
            this.readSupport(sc);
        }
        finally {
            this.trace();
        }
    }

    protected void readSupport(SocketChannel sc) throws IOException {
        throw new IOException("Read not supported: " + sc);
    }

    public final void write(SocketChannel sc) throws IOException {
        try {
            this.writeSupport(sc);
        }
        finally {
            this.trace();
        }
    }

    protected void writeSupport(SocketChannel sc) throws IOException {
        throw new IOException("Write not supported: " + sc);
    }

    public final void connect(SocketChannel sc) throws IOException {
        try {
            this.connectSupport(sc);
        }
        finally {
            this.trace();
        }
    }

    protected void connectSupport(SocketChannel sc) throws IOException {
        throw new IOException("Connect not supported: " + sc);
    }

    protected void trace() {
        LGLogger.log(String.valueOf(this.socks_connection.getConnection().getName()) + ":" + this.getStateName() + ", " + this.buffer);
    }
}

