/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.proxy.AEProxy;
import com.aelitis.azureus.core.proxy.AEProxyException;
import com.aelitis.azureus.core.proxy.AEProxyHandler;
import com.aelitis.azureus.core.proxy.impl.AEProxyConnectionImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEProxyImpl
implements AEProxy,
VirtualChannelSelector.VirtualSelectorListener {
    protected int port;
    protected long connect_timeout;
    protected long read_timeout;
    protected AEProxyHandler proxy_handler;
    protected VirtualChannelSelector read_selector = new VirtualChannelSelector(1);
    protected VirtualChannelSelector connect_selector = new VirtualChannelSelector(8);
    protected VirtualChannelSelector write_selector = new VirtualChannelSelector(4);
    protected Map processors = new WeakHashMap();
    protected AEMonitor this_mon = new AEMonitor("AEProxyImpl");

    public AEProxyImpl(int _port, long _connect_timeout, long _read_timeout, AEProxyHandler _proxy_handler) throws AEProxyException {
        this.port = _port;
        this.connect_timeout = _connect_timeout;
        this.read_timeout = _read_timeout;
        this.proxy_handler = _proxy_handler;
        try {
            final ServerSocketChannel ssc = ServerSocketChannel.open();
            ServerSocket ss = ssc.socket();
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.port), 128);
            if (this.port == 0) {
                this.port = ss.getLocalPort();
            }
            AEThread connect_thread = new AEThread("AEProxy:connect.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.connect_selector);
                }
            };
            connect_thread.setDaemon(true);
            connect_thread.start();
            AEThread read_thread = new AEThread("AEProxy:read.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.read_selector);
                }
            };
            read_thread.setDaemon(true);
            read_thread.start();
            AEThread write_thread = new AEThread("AEProxy:write.loop"){

                public void runSupport() {
                    AEProxyImpl.this.selectLoop(AEProxyImpl.this.write_selector);
                }
            };
            write_thread.setDaemon(true);
            write_thread.start();
            AEThread accept_thread = new AEThread("AEProxy:accept.loop"){

                public void runSupport() {
                    AEProxyImpl.this.acceptLoop(ssc);
                }
            };
            accept_thread.setDaemon(true);
            accept_thread.start();
            LGLogger.log("AEProxy: listener established on port " + this.port);
        }
        catch (Throwable e) {
            LGLogger.logUnrepeatableAlertUsingResource(3, "Tracker.alert.listenfail", new String[]{"" + this.port});
            LGLogger.log("AEProxy: listener failed on port " + this.port, e);
            throw new AEProxyException("AEProxy: accept fails: " + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void acceptLoop(ServerSocketChannel ssc) {
        long successfull_accepts = 0L;
        long failed_accepts = 0L;
        while (true) {
            try {
                while (true) {
                    SocketChannel socket_channel = ssc.accept();
                    ++successfull_accepts;
                    if (!socket_channel.socket().getInetAddress().isLoopbackAddress()) {
                        LGLogger.log("AEProxy: incoming connection from '" + socket_channel.socket().getInetAddress() + "' - closed as not local");
                        socket_channel.close();
                    }
                    socket_channel.configureBlocking(false);
                    AEProxyConnectionImpl processor = new AEProxyConnectionImpl(this, socket_channel, this.proxy_handler);
                    try {
                        this.this_mon.enter();
                        this.processors.put(processor, "");
                        LGLogger.log("AEProxy: num processors = " + this.processors.size());
                    }
                    finally {
                        this.this_mon.exit();
                    }
                    this.read_selector.register(socket_channel, this, processor);
                }
            }
            catch (Throwable e) {
                LGLogger.log("AEProxy: listener failed on port " + this.port, e);
                if (++failed_accepts <= 100L || successfull_accepts != 0L) continue;
                LGLogger.logUnrepeatableAlertUsingResource(3, "Network.alert.acceptfail", new String[]{"" + this.port, "TCP"});
                return;
            }
            break;
        }
    }

    protected void close(AEProxyConnectionImpl processor) {
        try {
            this.this_mon.enter();
            this.processors.remove(processor);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void selectLoop(VirtualChannelSelector selector) {
        long last_time = 0L;
        while (true) {
            try {
                selector.select(100L);
                if (selector != this.read_selector) continue;
                long now = SystemTime.getCurrentTime();
                if (now < last_time) {
                    last_time = now;
                    continue;
                }
                if (now - last_time < 5000L) continue;
                last_time = now;
                this.checkTimeouts();
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    protected void checkTimeouts() {
        if (this.connect_timeout <= 0L && this.read_timeout <= 0L) {
            return;
        }
        ArrayList<AEProxyConnectionImpl> closes = new ArrayList<AEProxyConnectionImpl>();
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            Iterator it = this.processors.keySet().iterator();
            while (it.hasNext()) {
                AEProxyConnectionImpl processor = (AEProxyConnectionImpl)it.next();
                long diff = now - processor.getTimeStamp();
                if (this.connect_timeout > 0L && diff >= this.connect_timeout && !processor.isConnected()) {
                    closes.add(processor);
                    continue;
                }
                if (this.read_timeout <= 0L || diff < this.read_timeout || !processor.isConnected()) continue;
                closes.add(processor);
            }
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < closes.size()) {
            ((AEProxyConnectionImpl)closes.get(i)).failed(new Throwable("timeout"));
            ++i;
        }
    }

    protected void requestWriteSelect(AEProxyConnectionImpl processor, SocketChannel sc) {
        this.write_selector.register(sc, this, processor);
    }

    protected void cancelWriteSelect(SocketChannel sc) {
        this.write_selector.cancel(sc);
    }

    protected void requestReadSelect(AEProxyConnectionImpl processor, SocketChannel sc) {
        this.read_selector.register(sc, this, processor);
    }

    protected void cancelReadSelect(SocketChannel sc) {
        this.read_selector.cancel(sc);
    }

    protected void requestConnectSelect(AEProxyConnectionImpl processor, SocketChannel sc) {
        this.connect_selector.register(sc, this, processor);
    }

    protected void cancelConnectSelect(SocketChannel sc) {
        this.connect_selector.cancel(sc);
    }

    public void selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
        AEProxyConnectionImpl processor = (AEProxyConnectionImpl)attachment;
        if (selector == this.read_selector) {
            processor.read(sc);
        } else if (selector == this.write_selector) {
            processor.write(sc);
        } else {
            processor.connect(sc);
        }
    }

    public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
        AEProxyConnectionImpl processor = (AEProxyConnectionImpl)attachment;
        processor.failed(msg);
    }

    public int getPort() {
        return this.port;
    }
}

