/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class PeerIDByteDecoder {
    static final boolean LOG_UNKNOWN;

    static {
        String prop = System.getProperty("log.unknown.peerids");
        LOG_UNKNOWN = prop != null && prop.equals("1");
    }

    protected static String decode(byte[] peer_id) {
        String decoded = null;
        byte[] peerID = new byte[peer_id.length];
        System.arraycopy(peer_id, 0, peerID, 0, peer_id.length);
        FileWriter log = null;
        File logFile = FileUtil.getUserFile("identification.log");
        int iFirstNonZeroPos = 0;
        try {
            String upnp;
            String bitspirit;
            decoded = PeerIDByteDecoder.decodeAzStyle(peerID, "AZ", "Azureus");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeAzStyle(peerID, "LT", "libtorrent");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeAzStyle(peerID, "TS", "TorrentStorm");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeAzStyle(peerID, "MT", "MoonlightTorrent");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeAzStyle(peerID, "XT", "XanTorrent");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeAzStyle(peerID, "bk", "BitKitten (libtorrent)");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeTornadoStyle(peerID, "T", "BitTornado");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeTornadoStyle(peerID, "A", "ABC");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeMainlineStyle(peerID, "M", "Mainline");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "martini", "Martini Man");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "oernu", "BTugaXP");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "BTDWV-", "Deadman Walking");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "PRC.P---", "BitTorrent Plus! II");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "P87.P---", "BitTorrent Plus!");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "S587Plus", "BitTorrent Plus!");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 5, "Azureus", "Azureus 2.0.3.2");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "-G3", "G3 Torrent");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 4, "btfans", "SimpleBT");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "btuga", "BTugaXP");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "DansClient", "XanTorrent");
            if (decoded != null) {
                return decoded;
            }
            decoded = PeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "Deadman Walking-", "Deadman");
            if (decoded != null) {
                return decoded;
            }
            String burst = new String(peerID, 0, 5, "ISO-8859-1");
            if (burst.equals("Mbrst")) {
                String major = new String(peerID, 5, 1, "ISO-8859-1");
                String minor = new String(peerID, 7, 1, "ISO-8859-1");
                String sub = new String(peerID, 9, 1, "ISO-8859-1");
                return "Burst! " + major + "." + minor + "." + sub;
            }
            String turbobt = new String(peerID, 0, 7, "ISO-8859-1");
            if (turbobt.equals("turbobt")) {
                return "TurboBT " + new String(peerID, 7, 5, "ISO-8859-1");
            }
            String plus = new String(peerID, 0, 4, "ISO-8859-1");
            if (plus.equals("Plus")) {
                String v1 = new String(peerID, 4, 1, "ISO-8859-1");
                String v2 = new String(peerID, 5, 1, "ISO-8859-1");
                String v3 = new String(peerID, 6, 1, "ISO-8859-1");
                return "Plus! " + v1 + "." + v2 + "." + v3;
            }
            String xbt = new String(peerID, 0, 3, "ISO-8859-1");
            if (xbt.equals("XBT")) {
                String v1 = new String(peerID, 3, 1, "ISO-8859-1");
                String v2 = new String(peerID, 4, 1, "ISO-8859-1");
                String v3 = new String(peerID, 5, 1, "ISO-8859-1");
                return "XBT " + v1 + "." + v2 + "." + v3;
            }
            String shadow = new String(peerID, 0, 1, "ISO-8859-1");
            if (shadow.equals("S")) {
                if (peerID[6] == 45 && peerID[7] == 45 && peerID[8] == 45) {
                    String name = "Shad0w ";
                    int i = 1;
                    while (i < 3) {
                        String v = new String(peerID, i, 1, "ISO-8859-1");
                        name = name.concat(String.valueOf(Integer.parseInt(v, 16)) + ".");
                        ++i;
                    }
                    String v = new String(peerID, 3, 1, "ISO-8859-1");
                    name = name.concat("" + Integer.parseInt(v, 16));
                    return name;
                }
                if (peerID[8] == 0) {
                    String name = "Shad0w ";
                    int i = 1;
                    while (i < 3) {
                        name = name.concat(String.valueOf(String.valueOf(peerID[i])) + ".");
                        ++i;
                    }
                    name = String.valueOf(name) + String.valueOf(peerID[3]);
                    return name;
                }
            }
            if ((bitspirit = new String(peerID, 2, 2, "ISO-8859-1")).equals("BS")) {
                if (peerID[1] == 0) {
                    return "BitSpirit v1";
                }
                if (peerID[1] == 2) {
                    return "BitSpirit v2";
                }
            }
            if ((upnp = new String(peerID, 0, 1, "ISO-8859-1")).equals("U") && peerID[8] == 45) {
                String version = new String(peerID, 1, 3, "ISO-8859-1");
                String name = "UPnP ";
                int i = 0;
                while (i < 2) {
                    name = name.concat(String.valueOf(version.charAt(i)) + ".");
                    ++i;
                }
                name = String.valueOf(name) + version.charAt(2);
                return name;
            }
            String bitcomet = new String(peerID, 0, 4, "ISO-8859-1");
            if (bitcomet.equals("exbc")) {
                String name = "BitComet ";
                name = name.concat(String.valueOf(String.valueOf(peerID[4])) + ".");
                name = name.concat(String.valueOf(peerID[5] / 10));
                name = name.concat(String.valueOf(peerID[5] % 10));
                return name;
            }
            boolean bShareaza = true;
            int i = 0;
            while (i < 16) {
                if (peerID[i] == 0) {
                    bShareaza = false;
                    break;
                }
                ++i;
            }
            if (bShareaza) {
                i = 16;
                while (i < 20) {
                    if (peerID[i] != (peerID[i % 16] ^ peerID[15 - i % 16])) {
                        bShareaza = false;
                        break;
                    }
                    ++i;
                }
                return "Shareaza";
            }
            iFirstNonZeroPos = 20;
            i = 0;
            while (i < 20) {
                if (peerID[i] != 0) {
                    iFirstNonZeroPos = i;
                    break;
                }
                ++i;
            }
            byte three = 3;
            if (iFirstNonZeroPos == 9 && peerID[9] == three && peerID[10] == three && peerID[11] == three) {
                return "Snark";
            }
            if (iFirstNonZeroPos == 12 && peerID[12] == 97 && peerID[13] == 97) {
                return "Experimental 3.2.1b2";
            }
            if (iFirstNonZeroPos == 12 && peerID[12] == 0 && peerID[13] == 0) {
                return "Experimental 3.1";
            }
            if (iFirstNonZeroPos == 12) {
                return "Mainline";
            }
        }
        catch (Exception e) {
            Debug.out(e.toString());
        }
        if (LOG_UNKNOWN) {
            try {
                try {
                    log = new FileWriter(logFile, true);
                    String text = new String(peerID, 0, 20, "ISO-8859-1");
                    text = text.replace('\f', ' ');
                    text = text.replace('\n', ' ');
                    log.write("[" + text + "] ");
                    int i = 0;
                    while (i < 20) {
                        log.write(String.valueOf(i) + "=" + peerID[i] + " ");
                        ++i;
                    }
                    log.write("\n");
                }
                catch (Exception e) {
                    Debug.out(e.toString());
                }
            }
            finally {
                try {
                    if (log != null) {
                        log.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        String sPeerID = PeerIDByteDecoder.getPrintablePeerID(peerID, iFirstNonZeroPos);
        return String.valueOf(MessageText.getString("PeerSocket.unknown")) + " " + iFirstNonZeroPos + "[" + sPeerID + "]";
    }

    private static String decodeAzStyle(byte[] id, String ident, String name) {
        try {
            String decoded;
            if (id[0] == 45 && id[7] == 45 && (decoded = new String(id, 1, 2, "ISO-8859-1")).equals(ident)) {
                String v1 = new String(id, 3, 1, "ISO-8859-1");
                String v2 = new String(id, 4, 1, "ISO-8859-1");
                String v3 = new String(id, 5, 1, "ISO-8859-1");
                String v4 = new String(id, 6, 1, "ISO-8859-1");
                return String.valueOf(name) + " " + v1 + "." + v2 + "." + v3 + "." + v4;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static String decodeTornadoStyle(byte[] id, String ident, String name) {
        try {
            String decoded;
            if (id[4] == 45 && id[5] == 45 && id[6] == 45 && id[7] == 45 && id[8] == 45 && (decoded = new String(id, 0, 1, "ISO-8859-1")).equals(ident)) {
                int v1 = Integer.parseInt(new String(id, 1, 1, "ISO-8859-1"), 16);
                int v2 = Integer.parseInt(new String(id, 2, 1, "ISO-8859-1"), 16);
                int v3 = Integer.parseInt(new String(id, 3, 1, "ISO-8859-1"), 16);
                return String.valueOf(name) + " " + v1 + "." + v2 + "." + v3;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static String decodeSimpleStyle(byte[] id, int start_pos, String ident, String name) {
        try {
            String decoded = new String(id, start_pos, ident.length(), "ISO-8859-1");
            if (decoded.equals(ident)) {
                return name;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static String decodeMainlineStyle(byte[] id, String ident, String name) {
        try {
            String decoded;
            if (id[2] == 45 && id[4] == 45 && id[6] == 45 && id[7] == 45 && (decoded = new String(id, 0, 1, "ISO-8859-1")).equals(ident)) {
                String v1 = new String(id, 1, 1, "ISO-8859-1");
                String v2 = new String(id, 3, 1, "ISO-8859-1");
                String v3 = new String(id, 5, 1, "ISO-8859-1");
                return String.valueOf(name) + " " + v1 + "." + v2 + "." + v3;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    protected static String getPrintablePeerID(byte[] peerID, int iStartAtPos) {
        String sPeerID = "";
        try {
            int i = iStartAtPos;
            while (i < peerID.length) {
                int b = 0xFF & peerID[i];
                if (b < 32 || b > 127) {
                    peerID[i] = 45;
                }
                ++i;
            }
            sPeerID = new String(peerID, iStartAtPos, peerID.length - iStartAtPos, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sPeerID;
    }
}

