/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.SelectorGuard;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class VirtualChannelSelector {
    public static final int OP_CONNECT = 8;
    public static final int OP_READ = 1;
    public static final int OP_WRITE = 4;
    private static final int SELECTOR_FAIL_COUNT_MAX = 10000;
    private Selector selector;
    private final SelectorGuard selector_guard;
    private final ArrayList register_cancel_list = new ArrayList();
    private final AEMonitor register_cancel_list_mon = new AEMonitor("VirtualChannelSelector:RCL");
    private final int INTEREST_OP;

    public VirtualChannelSelector(int interest_op) {
        this.INTEREST_OP = interest_op;
        this.selector_guard = new SelectorGuard(10000);
        try {
            this.selector = Selector.open();
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    public void register(SocketChannel channel, VirtualSelectorListener listener, Object attachment) {
        this.addRegOrCancel(new RegistrationData(channel, listener, attachment));
        this.selector.wakeup();
    }

    public void cancel(SocketChannel channel) {
        this.addRegOrCancel(channel);
    }

    protected void addRegOrCancel(Object obj_to_add) {
        try {
            this.register_cancel_list_mon.enter();
            int i = 0;
            while (i < this.register_cancel_list.size()) {
                Object obj = this.register_cancel_list.get(i);
                boolean remove_it = false;
                if (obj_to_add instanceof SocketChannel) {
                    if (obj_to_add == obj || obj instanceof RegistrationData && ((RegistrationData)obj).channel == obj_to_add) {
                        remove_it = true;
                    }
                } else {
                    RegistrationData rd = (RegistrationData)obj_to_add;
                    if (rd.channel == obj || obj instanceof RegistrationData && ((RegistrationData)obj).channel == rd.channel) {
                        remove_it = true;
                    }
                }
                if (remove_it) {
                    this.register_cancel_list.remove(i);
                    if (!(obj instanceof RegistrationData)) break;
                    RegistrationData data = (RegistrationData)obj;
                    data.listener.selectFailure(this, data.channel, data.attachment, new Throwable("registration superceded"));
                    break;
                }
                ++i;
            }
            this.register_cancel_list.add(obj_to_add);
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    public int select(long timeout) {
        try {
            this.register_cancel_list_mon.enter();
            Iterator reg_can_it = this.register_cancel_list.iterator();
            while (reg_can_it.hasNext()) {
                SelectionKey key;
                Object obj = reg_can_it.next();
                if (obj instanceof SocketChannel) {
                    SocketChannel canceled_channel = (SocketChannel)obj;
                    key = canceled_channel.keyFor(this.selector);
                    if (key == null) continue;
                    key.cancel();
                    continue;
                }
                RegistrationData data = (RegistrationData)obj;
                try {
                    if (data.channel.isOpen()) {
                        key = data.channel.keyFor(this.selector);
                        if (key != null) {
                            key.attach(data);
                            continue;
                        }
                        data.channel.register(this.selector, this.INTEREST_OP, data);
                        continue;
                    }
                    data.listener.selectFailure(this, data.channel, data.attachment, new Throwable("channel is closed"));
                }
                catch (Throwable t) {
                    data.listener.selectFailure(this, data.channel, data.attachment, t);
                    Debug.printStackTrace(t);
                }
            }
            this.register_cancel_list.clear();
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
        int count = 0;
        this.selector_guard.markPreSelectTime();
        try {
            count = this.selector.select(timeout);
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
        if (!this.selector_guard.isSelectorOK(count, 10L)) {
            this.selector = this.selector_guard.repairSelector(this.selector);
        }
        if (count > 0) {
            Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
            while (i.hasNext()) {
                SelectionKey key = i.next();
                i.remove();
                RegistrationData data = (RegistrationData)key.attachment();
                if (key.isValid()) {
                    if (this.INTEREST_OP != 1) {
                        key.cancel();
                    }
                    data.listener.selectSuccess(this, data.channel, data.attachment);
                    continue;
                }
                key.cancel();
                data.listener.selectFailure(this, data.channel, data.attachment, new Throwable("key is invalid"));
            }
        }
        return count;
    }

    private static class RegistrationData {
        private final SocketChannel channel;
        private final VirtualSelectorListener listener;
        private final Object attachment;

        RegistrationData(SocketChannel channel, VirtualSelectorListener listener, Object attach) {
            this.channel = channel;
            this.listener = listener;
            this.attachment = attach;
        }
    }

    public interface VirtualSelectorListener {
        public void selectSuccess(VirtualChannelSelector var1, SocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, SocketChannel var2, Object var3, Throwable var4);
    }
}

