/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public int handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int HANDLE = 8;
    static final int DISABLED = 16;
    static final int MENU = 32;
    static final int OBSCURED = 64;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ACTIVATE = 1;
    static final int BUTTON_PRESS_EVENT = 2;
    static final int BUTTON_RELEASE_EVENT = 3;
    static final int CHANGED = 4;
    static final int CLICKED = 5;
    static final int COMMIT = 6;
    static final int CONFIGURE_EVENT = 7;
    static final int DELETE_EVENT = 8;
    static final int DELETE_RANGE = 9;
    static final int DELETE_TEXT = 10;
    static final int ENTER_NOTIFY_EVENT = 11;
    static final int EVENT = 12;
    static final int EVENT_AFTER = 13;
    static final int EXPOSE_EVENT = 14;
    static final int FOCUS = 15;
    static final int FOCUS_IN_EVENT = 16;
    static final int FOCUS_OUT_EVENT = 17;
    static final int HIDE = 18;
    static final int INSERT_TEXT = 19;
    static final int KEY_PRESS_EVENT = 20;
    static final int KEY_RELEASE_EVENT = 21;
    static final int LEAVE_NOTIFY_EVENT = 22;
    static final int MAP = 23;
    static final int MAP_EVENT = 24;
    static final int MNEMONIC_ACTIVATE = 25;
    static final int MOTION_NOTIFY_EVENT = 26;
    static final int MOVE_FOCUS = 27;
    static final int POPUP_MENU = 28;
    static final int PREEDIT_CHANGED = 29;
    static final int REALIZE = 30;
    static final int ROW_ACTIVATED = 31;
    static final int SCROLL_CHILD = 32;
    static final int SELECT = 33;
    static final int SHOW = 34;
    static final int SHOW_HELP = 35;
    static final int SIZE_ALLOCATE = 36;
    static final int STYLE_SET = 37;
    static final int SWITCH_PAGE = 38;
    static final int TEST_COLLAPSE_ROW = 39;
    static final int TEST_EXPAND_ROW = 40;
    static final int TOGGLED = 41;
    static final int UNMAP = 42;
    static final int UNMAP_EVENT = 43;
    static final int UNREALIZE = 44;
    static final int VALUE_CHANGED = 45;
    static final int VISIBILITY_NOTIFY_EVENT = 46;
    static final int WINDOW_STATE_EVENT = 47;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
    }

    public void addListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, handler);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    int textCellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        return 0;
    }

    int pixbufCellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        return 0;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        parent.checkWidget();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int index) {
    }

    void createWidget(int index) {
        this.createHandle(index);
        this.setOrientation();
        this.hookEvents();
        this.register();
    }

    void deregister() {
        if (this.handle == 0) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.removeWidget(this.handle);
        }
    }

    void destroyWidget() {
        int topHandle = this.topHandle();
        this.releaseHandle();
        if (topHandle != 0 && (this.state & 8) != 0) {
            OS.gtk_widget_destroy((int)topHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.releaseChild();
        this.releaseWidget();
        this.destroyWidget();
    }

    void error(int code) {
        SWT.error(code);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.length();
        while (--index > 0 && string.charAt(index) != '.') {
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    int gtk_activate(int widget) {
        return 0;
    }

    int gtk_button_press_event(int widget, int event) {
        return 0;
    }

    int gtk_button_release_event(int widget, int event) {
        return 0;
    }

    int gtk_changed(int widget) {
        return 0;
    }

    int gtk_clicked(int widget) {
        return 0;
    }

    int gtk_commit(int imcontext, int text) {
        return 0;
    }

    int gtk_configure_event(int widget, int event) {
        return 0;
    }

    int gtk_delete_event(int widget, int event) {
        return 0;
    }

    int gtk_delete_range(int widget, int iter1, int iter2) {
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        return 0;
    }

    int gtk_enter_notify_event(int widget, int event) {
        return 0;
    }

    int gtk_event(int widget, int event) {
        return 0;
    }

    int gtk_event_after(int widget, int event) {
        return 0;
    }

    int gtk_expose_event(int widget, int event) {
        return 0;
    }

    int gtk_focus(int widget, int event) {
        return 0;
    }

    int gtk_focus_in_event(int widget, int event) {
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        return 0;
    }

    int gtk_hide(int widget) {
        return 0;
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        return 0;
    }

    int gtk_key_release_event(int widget, int event) {
        return 0;
    }

    int gtk_leave_notify_event(int widget, int event) {
        return 0;
    }

    int gtk_map(int widget) {
        return 0;
    }

    int gtk_map_event(int widget, int event) {
        return 0;
    }

    int gtk_mnemonic_activate(int widget, int arg1) {
        return 0;
    }

    int gtk_motion_notify_event(int widget, int event) {
        return 0;
    }

    int gtk_move_focus(int widget, int event) {
        return 0;
    }

    int gtk_popup_menu(int widget) {
        return 0;
    }

    int gtk_preedit_changed(int imcontext) {
        return 0;
    }

    int gtk_realize(int widget) {
        return 0;
    }

    int gtk_row_activated(int tree, int path, int column) {
        return 0;
    }

    int gtk_scroll_child(int widget, int scrollType, int horizontal) {
        return 0;
    }

    int gtk_select(int item) {
        return 0;
    }

    int gtk_show(int widget) {
        return 0;
    }

    int gtk_show_help(int widget, int helpType) {
        return 0;
    }

    int gtk_size_allocate(int widget, int allocation) {
        return 0;
    }

    int gtk_style_set(int widget, int previousStyle) {
        return 0;
    }

    int gtk_switch_page(int widget, int page, int page_num) {
        return 0;
    }

    int gtk_test_collapse_row(int tree, int iter, int path) {
        return 0;
    }

    int gtk_test_expand_row(int tree, int iter, int path) {
        return 0;
    }

    int gtk_timer() {
        return 0;
    }

    int gtk_toggled(int renderer, int pathStr) {
        return 0;
    }

    int gtk_unmap(int widget) {
        return 0;
    }

    int gtk_unmap_event(int widget, int event) {
        return 0;
    }

    int gtk_unrealize(int widget) {
        return 0;
    }

    int gtk_value_changed(int adjustment) {
        return 0;
    }

    int gtk_visibility_notify_event(int widget, int event) {
        return 0;
    }

    int gtk_window_state_event(int widget, int event) {
        return 0;
    }

    int fontHeight(int font, int widgetHandle) {
        int context = OS.gtk_widget_get_pango_context((int)widgetHandle);
        int lang = OS.pango_context_get_language((int)context);
        int metrics = OS.pango_context_get_metrics((int)context, (int)font, (int)lang);
        int ascent = OS.pango_font_metrics_get_ascent((int)metrics);
        int descent = OS.pango_font_metrics_get_descent((int)metrics);
        OS.pango_font_metrics_unref((int)metrics);
        return OS.PANGO_PIXELS((int)(ascent + descent));
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    int filterProc(int xEvent, int gdkEvent, int data) {
        return 0;
    }

    int fixedMapProc(int widget) {
        return 0;
    }

    char[] fixMnemonic(String string) {
        int length = string.length();
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        int i = 0;
        int j = 0;
        char[] result = new char[length * 2];
        while (i < length) {
            switch (text[i]) {
                case '&': {
                    if (i + 1 < length && text[i + 1] == '&') break;
                    text[i] = 95;
                    break;
                }
                case '_': {
                    result[j++] = 95;
                }
            }
            int n = j++;
            int n2 = ++i;
            ++i;
            result[n] = text[n2];
        }
        return result;
    }

    public boolean isDisposed() {
        if (this.handle != 0) {
            return false;
        }
        if ((this.state & 8) != 0) {
            return true;
        }
        return (this.state & 1) != 0;
    }

    protected boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    boolean isValidWidget() {
        if (this.handle != 0) {
            return true;
        }
        if ((this.state & 8) != 0) {
            return false;
        }
        return (this.state & 1) == 0;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    int hoverProc(int widget) {
        return 0;
    }

    int menuPositionProc(int menu, int x, int y, int push_in, int user_data) {
        return 0;
    }

    boolean mnemonicHit(int mnemonicHandle, char key) {
        if (!this.mnemonicMatch(mnemonicHandle, key)) {
            return false;
        }
        OS.g_signal_handlers_block_matched((int)mnemonicHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)25);
        boolean result = OS.gtk_widget_mnemonic_activate((int)mnemonicHandle, (boolean)false);
        OS.g_signal_handlers_unblock_matched((int)mnemonicHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)25);
        return result;
    }

    boolean mnemonicMatch(int mnemonicHandle, char key) {
        int keyval2;
        int keyval1 = OS.gdk_keyval_to_lower((int)OS.gdk_unicode_to_keyval((int)key));
        return keyval1 == (keyval2 = OS.gdk_keyval_to_lower((int)OS.gtk_label_get_mnemonic_keyval((int)mnemonicHandle)));
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void register() {
        if (this.handle == 0) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.addWidget(this.handle, this);
        }
    }

    void releaseChild() {
    }

    void releaseHandle() {
        this.handle = 0;
        this.state |= 1;
        this.display = null;
    }

    void releaseResources() {
        this.releaseWidget();
        this.releaseHandle();
    }

    void releaseWidget() {
        this.sendEvent(12);
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
    }

    boolean setInputState(Event event, int state) {
        if ((state & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((state & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((state & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((state & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((state & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((state & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event event, GdkEventKey keyEvent) {
        if (keyEvent.length > 1) {
            return false;
        }
        boolean isNull = false;
        event.keyCode = Display.translateKey(keyEvent.keyval);
        switch (keyEvent.keyval) {
            case 65288: {
                event.character = (char)8;
                break;
            }
            case 65290: {
                event.character = (char)10;
                break;
            }
            case 65293: 
            case 65421: {
                event.character = (char)13;
                break;
            }
            case 65439: 
            case 65535: {
                event.character = (char)127;
                break;
            }
            case 65307: {
                event.character = (char)27;
                break;
            }
            case 65056: 
            case 65289: {
                event.character = (char)9;
                break;
            }
            default: {
                if (event.keyCode == 0) {
                    int[] keyval = new int[1];
                    int[] effective_group = new int[1];
                    int[] level = new int[1];
                    int[] consumed_modifiers = new int[1];
                    if (OS.gdk_keymap_translate_keyboard_state((int)OS.gdk_keymap_get_default(), (int)keyEvent.hardware_keycode, (int)0, (int)keyEvent.group, (int[])keyval, (int[])effective_group, (int[])level, (int[])consumed_modifiers)) {
                        event.keyCode = OS.gdk_keyval_to_unicode((int)keyval[0]);
                    }
                }
                int key = keyEvent.keyval;
                if ((keyEvent.state & 4) != 0 && key >= 0 && key <= 127) {
                    if (97 <= key && key <= 122) {
                        key -= 32;
                    }
                    if (64 <= key && key <= 95) {
                        key -= 64;
                    }
                    event.character = (char)key;
                    isNull = keyEvent.keyval == 64 && key == 0;
                    break;
                }
                event.character = (char)OS.gdk_keyval_to_unicode((int)key);
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        return this.setInputState(event, keyEvent.state);
    }

    void setOrientation() {
    }

    int shellMapProc(int handle, int arg0, int user_data) {
        return 0;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int topHandle() {
        return this.handle;
    }

    int timerProc(int widget) {
        return 0;
    }

    int treeSelectionProc(int model, int path, int iter, int[] selection, int length) {
        return 0;
    }

    boolean translateTraversal(int event) {
        return false;
    }

    int windowProc(int handle, int user_data) {
        switch (user_data) {
            case 1: {
                return this.gtk_activate(handle);
            }
            case 4: {
                return this.gtk_changed(handle);
            }
            case 5: {
                return this.gtk_clicked(handle);
            }
            case 18: {
                return this.gtk_hide(handle);
            }
            case 23: {
                return this.gtk_map(handle);
            }
            case 28: {
                return this.gtk_popup_menu(handle);
            }
            case 29: {
                return this.gtk_preedit_changed(handle);
            }
            case 30: {
                return this.gtk_realize(handle);
            }
            case 33: {
                return this.gtk_select(handle);
            }
            case 34: {
                return this.gtk_show(handle);
            }
            case 45: {
                return this.gtk_value_changed(handle);
            }
            case 42: {
                return this.gtk_unmap(handle);
            }
            case 44: {
                return this.gtk_unrealize(handle);
            }
        }
        return 0;
    }

    int windowProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case -14: {
                return (this.state & 0x40) != 0 ? 1 : 0;
            }
            case -26: 
            case -3: 
            case -2: {
                return 1;
            }
            case 2: {
                return this.gtk_button_press_event(handle, arg0);
            }
            case 3: {
                return this.gtk_button_release_event(handle, arg0);
            }
            case 6: {
                return this.gtk_commit(handle, arg0);
            }
            case 7: {
                return this.gtk_configure_event(handle, arg0);
            }
            case 8: {
                return this.gtk_delete_event(handle, arg0);
            }
            case 11: {
                return this.gtk_enter_notify_event(handle, arg0);
            }
            case 12: {
                return this.gtk_event(handle, arg0);
            }
            case 13: {
                return this.gtk_event_after(handle, arg0);
            }
            case 14: {
                return this.gtk_expose_event(handle, arg0);
            }
            case 15: {
                return this.gtk_focus(handle, arg0);
            }
            case 16: {
                return this.gtk_focus_in_event(handle, arg0);
            }
            case 17: {
                return this.gtk_focus_out_event(handle, arg0);
            }
            case 20: {
                return this.gtk_key_press_event(handle, arg0);
            }
            case 21: {
                return this.gtk_key_release_event(handle, arg0);
            }
            case 22: {
                return this.gtk_leave_notify_event(handle, arg0);
            }
            case 24: {
                return this.gtk_map_event(handle, arg0);
            }
            case 25: {
                return this.gtk_mnemonic_activate(handle, arg0);
            }
            case 26: {
                return this.gtk_motion_notify_event(handle, arg0);
            }
            case 27: {
                return this.gtk_move_focus(handle, arg0);
            }
            case 35: {
                return this.gtk_show_help(handle, arg0);
            }
            case 36: {
                return this.gtk_size_allocate(handle, arg0);
            }
            case 37: {
                return this.gtk_style_set(handle, arg0);
            }
            case 41: {
                return this.gtk_toggled(handle, arg0);
            }
            case 43: {
                return this.gtk_unmap_event(handle, arg0);
            }
            case 46: {
                return this.gtk_visibility_notify_event(handle, arg0);
            }
            case 47: {
                return this.gtk_window_state_event(handle, arg0);
            }
        }
        return 0;
    }

    int windowProc(int handle, int arg0, int arg1, int user_data) {
        switch (user_data) {
            case 9: {
                return this.gtk_delete_range(handle, arg0, arg1);
            }
            case 10: {
                return this.gtk_delete_text(handle, arg0, arg1);
            }
            case 31: {
                return this.gtk_row_activated(handle, arg0, arg1);
            }
            case 32: {
                return this.gtk_scroll_child(handle, arg0, arg1);
            }
            case 38: {
                return this.gtk_switch_page(handle, arg0, arg1);
            }
            case 39: {
                return this.gtk_test_collapse_row(handle, arg0, arg1);
            }
            case 40: {
                return this.gtk_test_expand_row(handle, arg0, arg1);
            }
        }
        return 0;
    }

    int windowProc(int handle, int arg0, int arg1, int arg2, int user_data) {
        switch (user_data) {
            case 19: {
                return this.gtk_insert_text(handle, arg0, arg1, arg2);
            }
        }
        return 0;
    }
}

