/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TableColumn
extends Item {
    int boxHandle;
    int labelHandle;
    int imageHandle;
    int buttonHandle;
    Table parent;
    int modelIndex;
    int lastButton;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int index) {
        this.parent.createItem(this, index);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_resizable((int)this.handle);
    }

    public int getWidth() {
        this.checkWidget();
        if (!OS.gtk_tree_view_column_get_visible((int)this.handle)) {
            return 0;
        }
        return OS.gtk_tree_view_column_get_width((int)this.handle);
    }

    int gtk_clicked(int widget) {
        boolean doubleClick = false;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove((GdkEventButton)gdkEvent, (int)eventPtr, (int)GdkEventButton.sizeof);
            switch (gdkEvent.type) {
                case 7: {
                    int clickTime = this.display.getDoubleClickTime();
                    int eventTime = gdkEvent.time;
                    int eventButton = gdkEvent.button;
                    if (this.lastButton == eventButton && this.lastTime != 0 && Math.abs(this.lastTime - eventTime) <= clickTime) {
                        doubleClick = true;
                    }
                    this.lastTime = eventTime == 0 ? 1 : eventTime;
                    this.lastButton = eventButton;
                }
            }
            OS.gdk_event_free((int)eventPtr);
        }
        this.postEvent(doubleClick ? 14 : 13);
        return 0;
    }

    int gtk_mnemonic_activate(int widget, int arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    int gtk_size_allocate(int widget, int allocation) {
        boolean mapped = OS.GTK_WIDGET_MAPPED((int)widget);
        int x = OS.GTK_WIDGET_X((int)widget);
        int width = OS.GTK_WIDGET_WIDTH((int)widget);
        if (width != this.lastWidth) {
            this.lastWidth = width;
            if (mapped) {
                this.sendEvent(11);
            }
        }
        if (x != this.lastX) {
            this.lastX = x;
            if (mapped) {
                this.sendEvent(10);
            }
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect((int)this.handle, (byte[])OS.clicked, (int)this.display.windowProc2, (int)5);
        if (this.buttonHandle != 0) {
            OS.g_signal_connect((int)this.buttonHandle, (byte[])OS.size_allocate, (int)this.display.windowProc3, (int)36);
        }
        if (this.labelHandle != 0) {
            OS.g_signal_connect((int)this.labelHandle, (byte[])OS.mnemonic_activate, (int)this.display.windowProc3, (int)25);
        }
    }

    public void pack() {
        this.checkWidget();
        int width = 0;
        if (this.buttonHandle != 0) {
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)this.buttonHandle, (GtkRequisition)requisition);
            width = requisition.width;
        }
        if ((this.parent.style & 0x10000000) == 0) {
            int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter_first((int)this.parent.modelHandle, (int)iter)) {
                do {
                    width = Math.max(width, this.parent.calculateWidth(this.handle, iter));
                } while (OS.gtk_tree_model_iter_next((int)this.parent.modelHandle, (int)iter));
            }
            OS.g_free((int)iter);
        }
        this.setWidth(width);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, index == 0, this.style);
    }

    void setFontDescription(int font) {
        OS.gtk_widget_modify_font((int)this.labelHandle, (int)font);
        OS.gtk_widget_modify_font((int)this.imageHandle, (int)font);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)image.pixmap, (int)image.mask);
            OS.gtk_widget_show((int)this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)0, (int)0);
            OS.gtk_widget_hide((int)this.imageHandle);
        }
        if (this.buttonHandle != 0) {
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)this.buttonHandle, (GtkRequisition)requisition);
        }
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_resizable((int)this.handle, (boolean)resizable);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic((int)this.labelHandle, (byte[])buffer);
        if (string.length() != 0) {
            OS.gtk_widget_show((int)this.labelHandle);
        } else {
            OS.gtk_widget_hide((int)this.labelHandle);
        }
        if (this.buttonHandle != 0) {
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)this.buttonHandle, (GtkRequisition)requisition);
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width > 0) {
            OS.gtk_tree_view_column_set_fixed_width((int)this.handle, (int)width);
            OS.gtk_tree_view_column_set_visible((int)this.handle, (boolean)true);
        } else {
            OS.gtk_tree_view_column_set_visible((int)this.handle, (boolean)false);
        }
    }
}

