/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    int clientHandle() {
        return this.handle;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = 0;
        if (this.fixedHandle != 0) {
            border += OS.gtk_container_get_border_width((int)this.fixedHandle);
        }
        if (this.scrolledHandle != 0) {
            border += OS.gtk_container_get_border_width((int)this.scrolledHandle);
        }
        int trimX = x - border;
        int trimY = y - border;
        int trimWidth = width + border * 2;
        int trimHeight = height + border * 2;
        trimHeight += this.hScrollBarWidth();
        trimWidth += this.vScrollBarWidth();
        if (this.scrolledHandle != 0 && OS.gtk_scrolled_window_get_shadow_type((int)this.scrolledHandle) != 0) {
            int style = OS.gtk_widget_get_style((int)this.scrolledHandle);
            int xthickness = OS.gtk_style_get_xthickness((int)style);
            int ythickness = OS.gtk_style_get_ythickness((int)style);
            trimX -= xthickness;
            trimY -= ythickness;
            trimWidth += xthickness * 2;
            trimHeight += ythickness * 2;
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    ScrollBar createScrollBar(int style) {
        if (this.scrolledHandle == 0) {
            return null;
        }
        ScrollBar bar = new ScrollBar();
        bar.parent = this;
        bar.style = style;
        bar.display = this.display;
        bar.state |= 8;
        bar.handle = (style & 0x100) != 0 ? OS.gtk_scrolled_window_get_hadjustment((int)this.scrolledHandle) : OS.gtk_scrolled_window_get_vadjustment((int)this.scrolledHandle);
        bar.hookEvents();
        bar.register();
        return bar;
    }

    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    public int getBorderWidth() {
        this.checkWidget();
        int border = 0;
        if (this.fixedHandle != 0) {
            border += OS.gtk_container_get_border_width((int)this.fixedHandle);
        }
        if (this.scrolledHandle != 0) {
            border += OS.gtk_container_get_border_width((int)this.scrolledHandle);
            if (OS.gtk_scrolled_window_get_shadow_type((int)this.scrolledHandle) != 0) {
                border += OS.gtk_style_get_xthickness((int)OS.gtk_widget_get_style((int)this.scrolledHandle));
            }
        }
        return border;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int clientHandle = this.clientHandle();
        int width = OS.GTK_WIDGET_WIDTH((int)clientHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)clientHandle);
        if ((this.state & 2) != 0) {
            return new Rectangle(0, 0, width, height);
        }
        int x = OS.GTK_WIDGET_X((int)clientHandle);
        int y = OS.GTK_WIDGET_Y((int)clientHandle);
        return new Rectangle(x, y, width, height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    int hScrollBarWidth() {
        if (this.horizontalBar == null) {
            return 0;
        }
        int hBarHandle = OS.GTK_SCROLLED_WINDOW_HSCROLLBAR((int)this.scrolledHandle);
        if (hBarHandle == 0) {
            return 0;
        }
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)hBarHandle, (GtkRequisition)requisition);
        int spacing = OS.GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING((int)this.scrolledHandle);
        return requisition.height + spacing;
    }

    void setOrientation() {
        if ((this.style & 0x4000000) != 0 && this.scrolledHandle != 0) {
            OS.gtk_scrolled_window_set_placement((int)this.scrolledHandle, (int)2);
        }
    }

    void register() {
        super.register();
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.scrolledHandle = 0;
    }

    void releaseWidget() {
        if (this.horizontalBar != null) {
            this.horizontalBar.releaseResources();
        }
        if (this.verticalBar != null) {
            this.verticalBar.releaseResources();
        }
        this.verticalBar = null;
        this.horizontalBar = null;
        super.releaseWidget();
    }

    void resizeHandle(int width, int height) {
        if (this.fixedHandle != 0) {
            OS.gtk_widget_set_size_request((int)this.fixedHandle, (int)width, (int)height);
        }
        GtkRequisition requisition = new GtkRequisition();
        if (this.scrolledHandle != 0) {
            OS.gtk_widget_set_size_request((int)this.scrolledHandle, (int)width, (int)height);
            OS.gtk_widget_size_request((int)this.scrolledHandle, (GtkRequisition)requisition);
        } else {
            OS.gtk_widget_set_size_request((int)this.handle, (int)width, (int)height);
            OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
        }
    }

    void showWidget() {
        super.showWidget();
        if (this.scrolledHandle != 0) {
            OS.gtk_widget_show((int)this.scrolledHandle);
        }
    }

    int topHandle() {
        if (this.fixedHandle != 0) {
            return this.fixedHandle;
        }
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        return super.topHandle();
    }

    int vScrollBarWidth() {
        if (this.verticalBar == null) {
            return 0;
        }
        int vBarHandle = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR((int)this.scrolledHandle);
        if (vBarHandle == 0) {
            return 0;
        }
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)vBarHandle, (GtkRequisition)requisition);
        int spacing = OS.GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING((int)this.scrolledHandle);
        return requisition.width + spacing;
    }
}

