/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = System.getProperty("file.separator");

    public DirectoryDialog(Shell parent) {
        this(parent, 32768);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        int response;
        Object[] buffer;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        int handle = OS.gtk_file_selection_new((byte[])titleBytes);
        if (this.parent != null) {
            OS.gtk_window_set_transient_for((int)handle, (int)this.parent.topHandle());
        }
        String answer = null;
        if (this.filterPath != null) {
            String path = this.filterPath;
            if (path.length() > 0 && !path.endsWith(SEPARATOR)) {
                path = String.valueOf(path) + SEPARATOR;
            }
            int length = path.length();
            buffer = new char[length + 1];
            path.getChars(0, length, (char[])buffer, 0);
            int utf8Ptr = OS.g_utf16_to_utf8((char[])buffer, (int)-1, null, null, null);
            int fileNamePtr = OS.g_filename_from_utf8((int)utf8Ptr, (int)-1, null, null, null);
            OS.gtk_file_selection_set_filename((int)handle, (int)fileNamePtr);
            OS.g_free((int)utf8Ptr);
            OS.g_free((int)fileNamePtr);
        }
        GtkFileSelection selection = new GtkFileSelection();
        OS.memmove((GtkFileSelection)selection, (int)handle);
        OS.gtk_file_selection_hide_fileop_buttons((int)handle);
        int fileListParent = OS.gtk_widget_get_parent((int)selection.file_list);
        OS.gtk_widget_hide((int)selection.file_list);
        OS.gtk_widget_hide((int)fileListParent);
        if (this.message.length() > 0) {
            buffer = Converter.wcsToMbcs(null, this.message, true);
            int labelHandle = OS.gtk_label_new((byte[])buffer);
            OS.gtk_label_set_line_wrap((int)labelHandle, (boolean)true);
            OS.gtk_misc_set_alignment((int)labelHandle, (float)0.0f, (float)0.0f);
            OS.gtk_container_add((int)selection.main_vbox, (int)labelHandle);
            OS.gtk_widget_show((int)labelHandle);
        }
        if ((response = OS.gtk_dialog_run((int)handle)) == -5) {
            int fileNamePtr = OS.gtk_file_selection_get_filename((int)handle);
            int utf8Ptr = OS.g_filename_to_utf8((int)fileNamePtr, (int)-1, null, null, null);
            int[] items_written = new int[1];
            int utf16Ptr = OS.g_utf8_to_utf16((int)utf8Ptr, (int)-1, null, (int[])items_written, null);
            int length = items_written[0];
            char[] buffer2 = new char[length];
            OS.memmove((char[])buffer2, (int)utf16Ptr, (int)(length * 2));
            String osAnswer = new String(buffer2);
            OS.g_free((int)utf16Ptr);
            OS.g_free((int)utf8Ptr);
            if (osAnswer != null) {
                if (!osAnswer.equals(SEPARATOR) && osAnswer.endsWith(SEPARATOR)) {
                    osAnswer = osAnswer.substring(0, osAnswer.length() - 1);
                }
                answer = this.filterPath = osAnswer;
            }
        }
        OS.gtk_widget_destroy((int)handle);
        return answer;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

