/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.Locale;

/**
 * Maps the locale using the standard Java mapping: en-US would be mapped to
 * file ending with en_US.
 *
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version CVS $Revision: 1.6 $ $Date: 2002/01/02 19:04:56 $ $Author: neeme $
 */

public class DirectoryMapper extends DefaultMapper {

    /**
     * Get the URI for the bundle, based on locale and filename.
     *
     * @return      the URI
     */
    public String map(BundleInfo bundleInfo) {
        String name = bundleInfo.getName();
        Locale loc = bundleInfo.getLocale();
        StringBuffer sb = new StringBuffer(getPrefix());
        if (loc != null) {
            String lang = loc.getLanguage();
            String country = loc.getCountry();
            String variant = loc.getVariant();

            if (lang.length() > 0) sb.append("/").append(lang);
            if (country.length() > 0) sb.append("/").append(country);
            if (variant.length() > 0) sb.append("/").append(variant);
        }
        sb.append("/").append(name).append(getSuffix());

        String result = sb.toString();
        return result;
    }

}
