/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.ElementCache;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelInfo;

public class JavaModelCache {
    public static final int BASE_VALUE = 20;
    public static final int DEFAULT_PROJECT_SIZE = 5;
    public static final int DEFAULT_ROOT_SIZE = 200;
    public static final int DEFAULT_PKG_SIZE = 2000;
    public static final int DEFAULT_OPENABLE_SIZE = 2000;
    public static final int DEFAULT_CHILDREN_SIZE = 40000;
    protected JavaModelInfo modelInfo;
    protected HashMap projectCache = new HashMap(5);
    protected ElementCache rootCache = new ElementCache(200);
    protected ElementCache pkgCache = new ElementCache(2000);
    protected ElementCache openableCache = new ElementCache(2000);
    protected Map childrenCache = new HashMap(40000);

    protected void ensureSpaceLimit(Map newElements) {
        int rootSize = 0;
        IJavaElement project = null;
        int pkgSize = 0;
        IJavaElement root = null;
        int openableSize = 0;
        IJavaElement pkg = null;
        Iterator iterator = newElements.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement element = (IJavaElement)iterator.next();
            switch (element.getElementType()) {
                case 3: {
                    project = element.getParent();
                    ++rootSize;
                    break;
                }
                case 4: {
                    root = element.getParent();
                    ++pkgSize;
                    break;
                }
                case 5: 
                case 6: {
                    pkg = element.getParent();
                    ++openableSize;
                }
            }
        }
        this.rootCache.ensureSpaceLimit(rootSize, project);
        this.pkgCache.ensureSpaceLimit(pkgSize, root);
        this.openableCache.ensureSpaceLimit(openableSize, pkg);
    }

    protected void resetSpaceLimit(IJavaElement element) {
        switch (element.getElementType()) {
            case 2: {
                this.rootCache.resetSpaceLimit(200, element);
                break;
            }
            case 3: {
                this.pkgCache.resetSpaceLimit(2000, element);
                break;
            }
            case 4: {
                this.openableCache.resetSpaceLimit(2000, element);
            }
        }
    }

    public Object getInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.get(element);
            }
            case 4: {
                return this.pkgCache.get(element);
            }
            case 5: 
            case 6: {
                return this.openableCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected Object peekAtInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.peek(element);
            }
            case 4: {
                return this.pkgCache.peek(element);
            }
            case 5: 
            case 6: {
                return this.openableCache.peek(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected void putInfo(IJavaElement element, Object info) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = (JavaModelInfo)info;
                break;
            }
            case 2: {
                this.projectCache.put(element, info);
                break;
            }
            case 3: {
                this.rootCache.put(element, info);
                break;
            }
            case 4: {
                this.pkgCache.put(element, info);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.put(element, info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    protected void removeInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: {
                this.projectCache.remove(element);
                break;
            }
            case 3: {
                this.rootCache.remove(element);
                break;
            }
            case 4: {
                this.pkgCache.remove(element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.remove(element);
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }

    public String toStringFillingRation(String prefix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append("Project cache: ");
        buffer.append(this.projectCache.size());
        buffer.append(" projects\n");
        buffer.append(prefix);
        buffer.append("Root cache: ");
        buffer.append(NumberFormat.getInstance().format(this.rootCache.fillingRatio()));
        buffer.append("%\n");
        buffer.append(prefix);
        buffer.append("Package cache: ");
        buffer.append(NumberFormat.getInstance().format(this.pkgCache.fillingRatio()));
        buffer.append("%\n");
        buffer.append(prefix);
        buffer.append("Openable cache: ");
        buffer.append(NumberFormat.getInstance().format(this.openableCache.fillingRatio()));
        buffer.append("%\n");
        return buffer.toString();
    }
}

