/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IInitializer;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.ISourceRange;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMNode;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.Member;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.runtime.IProgressMonitor;

class Initializer
extends Member
implements IInitializer {
    protected Initializer(JavaElement parent, int count) {
        super(parent);
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        this.occurrenceCount = count;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Initializer)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean equalsDOMNode(IDOMNode node) {
        if (node.getNodeType() == 7) {
            try {
                return node.getContents().trim().equals(this.getSource());
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    public int getElementType() {
        return 10;
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.occurrenceCount);
    }

    protected char getHandleMementoDelimiter() {
        return '|';
    }

    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.occurrenceCount);
    }

    public String readableName() {
        return ((JavaElement)((Object)this.getDeclaringType())).readableName();
    }

    public void rename(String newName, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    public ISourceRange getNameRange() {
        return null;
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && ((cu = (CompilationUnit)this.getAncestor(5)) == null || cu.isPrimary())) {
            return this;
        }
        IJavaElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getInitializer(this.occurrenceCount);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append("<initializer #");
            buffer.append(this.occurrenceCount);
            buffer.append("> (not open)");
        } else if (info == JavaElement.NO_INFO) {
            buffer.append("<initializer #");
            buffer.append(this.occurrenceCount);
            buffer.append(">");
        } else {
            try {
                buffer.append("<");
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                buffer.append("initializer #");
                buffer.append(this.occurrenceCount);
                buffer.append(">");
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

