/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IImportDeclaration;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMNode;
import org.aspectj.org.eclipse.jdt.internal.core.Assert;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.ImportContainer;
import org.aspectj.org.eclipse.jdt.internal.core.ImportDeclarationElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.SourceRefElement;

class ImportDeclaration
extends SourceRefElement
implements IImportDeclaration {
    protected String name;

    protected ImportDeclaration(ImportContainer parent, String name) {
        super(parent);
        this.name = name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImportDeclaration)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean equalsDOMNode(IDOMNode node) {
        return node.getNodeType() == 3 && this.getElementName().equals(node.getName());
    }

    public String getElementName() {
        return this.name;
    }

    public int getElementType() {
        return 13;
    }

    public int getFlags() throws JavaModelException {
        ImportDeclarationElementInfo info = (ImportDeclarationElementInfo)this.getElementInfo();
        return info.getModifiers();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        this.escapeMementoName(buff, this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        Assert.isTrue(false, "Should not be called");
        return '\u0000';
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu = (CompilationUnit)this.parent.getParent();
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return cu.getImport(this.name);
    }

    public boolean isOnDemand() {
        return this.name.endsWith(".*");
    }

    public String readableName() {
        return null;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append("import ");
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

