/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.dom.BindingKeyScanner;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnitResolver;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

class BindingKey {
    char[][] compoundName;
    int dimension;
    BindingKeyScanner scanner;
    CompilationUnitResolver resolver;
    LookupEnvironment environment;

    BindingKey(String key, CompilationUnitResolver resolver) {
        this.scanner = new BindingKeyScanner(key.toCharArray());
        this.resolver = resolver;
        this.environment = resolver.lookupEnvironment;
        this.reset();
    }

    char[][] compoundName() {
        if (this.compoundName == null) {
            switch (this.scanner.nextToken()) {
                case 0: 
                case 1: {
                    this.compoundName = CharOperation.splitOn('/', this.scanner.getTokenSource());
                    break;
                }
                case 4: {
                    this.dimension = this.scanner.getTokenSource().length;
                    if (this.scanner.nextToken() == 1) {
                        this.compoundName = CharOperation.splitOn('/', this.scanner.getTokenSource());
                        break;
                    }
                    this.compoundName = CharOperation.NO_CHAR_CHAR;
                    break;
                }
                default: {
                    this.compoundName = CharOperation.NO_CHAR_CHAR;
                }
            }
        }
        return this.compoundName;
    }

    Binding getArrayBinding(int dim, TypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (dim == 0) {
            return binding;
        }
        return this.environment.createArrayType(binding, dim);
    }

    TypeBinding getBaseTypeBinding(char[] signature) {
        switch (signature[0]) {
            case 'I': {
                return BaseTypes.IntBinding;
            }
            case 'Z': {
                return BaseTypes.BooleanBinding;
            }
            case 'V': {
                return BaseTypes.VoidBinding;
            }
            case 'C': {
                return BaseTypes.CharBinding;
            }
            case 'D': {
                return BaseTypes.DoubleBinding;
            }
            case 'B': {
                return BaseTypes.ByteBinding;
            }
            case 'F': {
                return BaseTypes.FloatBinding;
            }
            case 'J': {
                return BaseTypes.LongBinding;
            }
            case 'S': {
                return BaseTypes.ShortBinding;
            }
        }
        return null;
    }

    Binding getBinaryBinding() {
        ReferenceBinding binding = this.environment.getType(this.compoundName);
        return this.getArrayBinding(this.dimension, binding);
    }

    CompilationUnitDeclaration getCompilationUnitDeclaration() {
        char[][] name = this.compoundName();
        if (name.length == 0) {
            return null;
        }
        ReferenceBinding binding = this.environment.getType(name);
        if (!(binding instanceof SourceTypeBinding)) {
            return null;
        }
        return ((SourceTypeBinding)binding).scope.compilationUnitScope().referenceContext;
    }

    Binding getCompilerBinding(CompilationUnitDeclaration parsedUnit) {
        switch (this.scanner.token) {
            case 0: {
                return new PackageBinding(this.compoundName, null, this.environment);
            }
            case 1: {
                TypeBinding baseTypeBinding;
                if (this.compoundName.length == 1 && this.compoundName[0].length == 1 && (baseTypeBinding = this.getBaseTypeBinding(this.compoundName[0])) != null) {
                    return this.getArrayBinding(this.dimension, baseTypeBinding);
                }
                if (parsedUnit == null) {
                    return this.getBinaryBinding();
                }
                char[] typeName = this.compoundName[this.compoundName.length - 1];
                int dim = this.dimension;
                TypeBinding binding = this.getTypeBinding(parsedUnit, parsedUnit.types, typeName);
                if (binding == null) {
                    return null;
                }
                TypeBinding typeBinding = null;
                if (this.scanner.isAtParametersStart()) {
                    if (this.scanner.isAtTypeParameterStart()) {
                        typeBinding = this.getGenericTypeBinding((SourceTypeBinding)binding);
                    } else if (this.scanner.isAtTypeStart() || this.scanner.isAtWildCardStart()) {
                        typeBinding = this.getParameterizedTypeBinding((ReferenceBinding)binding, null);
                    }
                } else {
                    typeBinding = binding.typeVariables().length > 0 ? this.environment.createRawType((ReferenceBinding)binding, null) : binding;
                }
                if (this.scanner.isAtFieldOrMethodStart()) {
                    switch (this.scanner.nextToken()) {
                        case 2: {
                            return this.getFieldBinding(((ReferenceBinding)typeBinding).fields());
                        }
                        case 3: {
                            MethodBinding methodBinding = this.getMethodBinding(((ReferenceBinding)typeBinding).methods());
                            if (this.scanner.isAtParametersStart()) {
                                methodBinding = this.getParameterizedGenericMethodBinding(methodBinding);
                            }
                            if (this.scanner.isAtLocalVariableStart()) {
                                MethodScope methodScope = methodBinding.sourceMethod().scope;
                                return this.getLocalVariableBinding(methodScope);
                            }
                            return methodBinding;
                        }
                    }
                    return null;
                }
                return this.getArrayBinding(dim, typeBinding);
            }
        }
        return null;
    }

    Binding getCompilerBinding() {
        char[] fileName;
        CompilationUnitDeclaration parsedUnit = this.getCompilationUnitDeclaration();
        if (parsedUnit != null && !this.resolver.requestedKeys.containsKey(fileName = parsedUnit.compilationResult.getFileName()) && !this.resolver.requestedSources.containsKey(fileName)) {
            this.resolver.process(parsedUnit, this.resolver.totalUnits + 1);
        }
        return this.getCompilerBinding(parsedUnit);
    }

    FieldBinding getFieldBinding(FieldBinding[] fields) {
        if (fields == null) {
            return null;
        }
        char[] fieldName = this.scanner.getTokenSource();
        int i = 0;
        int length = fields.length;
        while (i < length) {
            FieldBinding field = fields[i];
            if (CharOperation.equals(fieldName, field.name)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    SourceTypeBinding getGenericTypeBinding(SourceTypeBinding typeBinding) {
        TypeVariableBinding[] typeVariableBindings = typeBinding.typeVariables();
        int i = 0;
        int length = typeVariableBindings.length;
        while (i < length) {
            TypeVariableBinding typeVariableBinding = typeVariableBindings[i];
            if (this.scanner.nextToken() != 1) {
                return null;
            }
            char[] typeVariableName = this.scanner.getTokenSource();
            if (!CharOperation.equals(typeVariableName, typeVariableBinding.sourceName())) {
                return null;
            }
            ++i;
        }
        return typeBinding;
    }

    String getKey() {
        return new String(this.scanner.source);
    }

    LocalVariableBinding getLocalVariableBinding(BlockScope scope) {
        if (this.scanner.nextToken() != 6) {
            return null;
        }
        char[] varName = this.scanner.getTokenSource();
        if (Character.isDigit(varName[0])) {
            int index = Integer.parseInt(new String(varName));
            if (index >= scope.subscopeCount) {
                return null;
            }
            if (!this.scanner.isAtLocalVariableStart()) {
                return null;
            }
            return this.getLocalVariableBinding((BlockScope)scope.subscopes[index]);
        }
        int i = 0;
        while (i < scope.localIndex) {
            LocalVariableBinding local = scope.locals[i];
            if (CharOperation.equals(varName, local.name)) {
                return local;
            }
            ++i;
        }
        return null;
    }

    MethodBinding getMethodBinding(MethodBinding[] methods) {
        if (methods == null) {
            return null;
        }
        char[] selector = this.scanner.getTokenSource();
        this.scanner.skipMethodSignature();
        char[] signature = this.scanner.getTokenSource();
        int i = 0;
        int methodLength = methods.length;
        while (i < methodLength) {
            MethodBinding method = methods[i];
            if (CharOperation.equals(selector, method.selector) || selector.length == 0 && method.isConstructor()) {
                if (CharOperation.equals(signature, method.genericSignature())) {
                    return method;
                }
                return method;
            }
            ++i;
        }
        return null;
    }

    ParameterizedGenericMethodBinding getParameterizedGenericMethodBinding(MethodBinding methodBinding) {
        int length = methodBinding.typeVariables().length;
        TypeBinding[] arguments = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            this.reset();
            Binding argument = this.getCompilerBinding();
            if (argument == null) {
                return null;
            }
            arguments[i] = (TypeBinding)argument;
            ++i;
        }
        return new ParameterizedGenericMethodBinding(methodBinding, arguments, this.environment);
    }

    ParameterizedTypeBinding getParameterizedTypeBinding(ReferenceBinding genericType, ReferenceBinding enclosingType) {
        TypeVariableBinding[] typeVariableBindings = genericType.typeVariables();
        int length = typeVariableBindings.length;
        TypeBinding[] arguments = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            TypeBinding argument;
            if (this.scanner.isAtWildCardStart()) {
                argument = this.getWildCardBinding(genericType, i);
            } else {
                this.reset();
                argument = (TypeBinding)this.getCompilerBinding();
            }
            if (argument == null) {
                return this.environment.createRawType(genericType, enclosingType);
            }
            arguments[i] = argument;
            ++i;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment.createParameterizedType(genericType, arguments, enclosingType);
        this.scanner.skipParametersEnd();
        if (this.scanner.isAtMemberTypeStart() && this.scanner.nextToken() == 1) {
            char[] typeName = this.scanner.getTokenSource();
            ReferenceBinding memberType = genericType.getMemberType(typeName);
            return this.getParameterizedTypeBinding(memberType, parameterizedTypeBinding);
        }
        return parameterizedTypeBinding;
    }

    TypeBinding getTypeBinding(CompilationUnitDeclaration parsedUnit, TypeDeclaration[] types, char[] typeName) {
        if (Character.isDigit(typeName[0])) {
            int nextToken = 1;
            while (this.scanner.isAtMemberTypeStart()) {
                nextToken = this.scanner.nextToken();
            }
            typeName = nextToken == 7 ? this.scanner.source : CharOperation.subarray(this.scanner.source, 0, this.scanner.index + 1);
            LocalTypeBinding[] localTypeBindings = parsedUnit.localTypes;
            int i = 0;
            while (i < parsedUnit.localTypeCount) {
                if (CharOperation.equals(typeName, localTypeBindings[i].signature())) {
                    return localTypeBindings[i];
                }
                ++i;
            }
            return null;
        }
        if (types == null) {
            return null;
        }
        int i = 0;
        int length = types.length;
        while (i < length) {
            TypeDeclaration declaration = types[i];
            if (CharOperation.equals(typeName, declaration.name)) {
                if (this.scanner.isAtMemberTypeStart() && this.scanner.nextToken() == 1) {
                    return this.getTypeBinding(parsedUnit, declaration.memberTypes, this.scanner.getTokenSource());
                }
                return declaration.binding;
            }
            ++i;
        }
        return null;
    }

    TypeBinding getWildCardBinding(ReferenceBinding genericType, int rank) {
        if (this.scanner.nextToken() != 1) {
            return null;
        }
        char[] source = this.scanner.getTokenSource();
        if (source.length == 0) {
            return null;
        }
        int kind = -1;
        TypeBinding bound = null;
        switch (source[0]) {
            case '*': {
                kind = 0;
                break;
            }
            case '+': {
                this.reset();
                kind = 1;
                bound = (TypeBinding)this.getCompilerBinding();
                break;
            }
            case '-': {
                this.reset();
                kind = 2;
                bound = (TypeBinding)this.getCompilerBinding();
            }
        }
        if (kind == -1) {
            return null;
        }
        return this.environment.createWildcard(genericType, rank, bound, kind);
    }

    void reset() {
        this.compoundName = null;
        this.dimension = 0;
    }

    public String toString() {
        return this.getKey();
    }
}

