/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Ant", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */ 

package org.apache.tools.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

/**
 * Filters filenames to determine whether or not the file is desirable.
 *
 * @author Jason Hunter [jhunter@servlets.com]
 * @author james@x180.com
 */
public class DesirableFilter implements FilenameFilter {

    /**
     * Test the given filename to determine whether or not it's desirable.
     * This helps tasks filter temp files and files used by CVS.
     */

    public boolean accept(File dir, String name) {
        
        // emacs save file
        if (name.endsWith("~")) {
            return false;
        }

        // emacs autosave file
        if (name.startsWith("#") && name.endsWith("#")) {
            return false;
        }

        // openwindows text editor does this I think
        if (name.startsWith("%") && name.endsWith("%")) {
            return false;
        }

        /* CVS stuff -- hopefully there won't be a case with
         * an all cap file/dir named "CVS" that somebody wants
         * to keep around...
         */
        
        if (name.equals("CVS")) {
            return false;
        }
        
        /* If we are going to ignore CVS might as well ignore 
         * this one as well...
         */
        if (name.equals(".cvsignore")){
            return false;
        }

        // CVS merge autosaves.
        if (name.startsWith(".#")) {
            return false;
        }

        // SCCS/CSSC/TeamWare:
        if (name.equals("SCCS")) {
            return false;
        }
    
        // Visual Source Save
        if (name.equals("vssver.scc")) {
            return false;
        }

        // default
        return true;
    }
}







