
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
 //                                                                        \\
 //                 Centre for Speech Technology Research                  \\
 //                      University of Edinburgh, UK                       \\
 //                        Copyright (c) 1996,1997                         \\
 //                         All Rights Reserved.                           \\
 //   Permission to use, copy, modify, distribute this software and its    \\
 //   documentation for research, educational and individual use only, is  \\
 //   hereby granted without fee, subject to the following conditions:     \\
 //    1. The code must retain the above copyright notice, this list of    \\
 //       conditions and the following disclaimer.                         \\
 //    2. Any modifications must be clearly marked as such.                \\
 //    3. Original authors' names are not deleted.                         \\
 //   This software may not be used for commercial purposes without        \\
 //   specific prior written permission from the authors.                  \\
 //   THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        \\
 //   DISCLAIM ALL WARRANTIES With REGARD TO THIS SOFTWARE, INCLUDING      \\
 //   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   \\
 //   SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     \\
 //   FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    \\
 //   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   \\
 //   AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          \\
 //   ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       \\
 //   THIS SOFTWARE.                                                       \\
 //                                                                        \\
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\
 //                                                                        \\
 //                  Author: Richard Caley (rjc@cstr.ed.ac.uk)             \\
 //                    Date: Friday 12th September 1997                    \\
 //  --------------------------------------------------------------------  \\
 //  Wrapper around the EST_Track class.                                   \\
 //                                                                        \\
 //\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\


package cstr.est.cpp;

import java.util.*;
import java.lang.*;
import java.io.*;

public class Track
{
  private long cpp_handle;

  public Track()
    {
      create_cpp_track();
    }

  protected void finalize() throws Throwable
    {
      destroy_cpp_track();
      super.finalize();
    }

  private native String cpp_name();

  public String name()
    {
      return cpp_name();
    }

  private native String cpp_load(String filename);

  public void load(String filename) throws FileNotFoundException
    {
      String res = cpp_load(filename);

      if (!res.equals(""))
	  throw new FileNotFoundException(res);
    }

  private native String cpp_save(String filename, String format);

  public void save(String filename, String format) throws IOException 
    {
      String res = cpp_save(filename, format);

      if (!res.equals(""))
	  throw new IOException(res);
    }

  private native int cpp_num_frames();

  public int num_frames()
    {
      return cpp_num_frames();
    }

  private native int cpp_num_channels();

  public int num_channels()
    {
      return cpp_num_channels();
    }

  private native String cpp_channelName(int i);

  public String channelName(int i)
    {
      return cpp_channelName(i);
    }

  private native int cpp_channelPosition(String n);

  public int channelPosition(String n)
    {
      return cpp_channelPosition(n);
    }

  private native float cpp_a(int i, int c);
  
  public float a(int i, int c)
    {
      return cpp_a(i,c);
    }

  private native float cpp_t(int i);
  
  public float t(int i)
    {
      return cpp_t(i);
    }

  private native int cpp_findItem(float time);
  
  public int findItem(float time)
    {
      return cpp_findItem(time);
    }

  private native float cpp_getEndTime();

  public float getEndTime()
    {
      return cpp_getEndTime();
    }

  private native static boolean initialise_cpp();
  private native static boolean finalise_cpp();
  private native boolean create_cpp_track();
  private native boolean destroy_cpp_track();

  static {
    System.loadLibrary("estjava");
    if (!initialise_cpp())
	throw new ExceptionInInitializerError("Track C++ fails");
  }
}
