 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/

#if !defined(__SUBTYPEDOBJECT_H__)
#define __SUBTYPEDOBJECT_H__

#include "SchemeObject.h"

/** Template class implementing objects visible from Scheme which can have
  * multiple implementations. For instance the type `UnitDatabase'
  * can be implemented in a number of ways to deal with different
  * physical representations of the database. We call each of these
  * implementations a subtype.
  * <p>
  * Implements recognising a file containing such an object in
  * and creating one by type name.  
  *
  * @see UnitDatabase, an example
  * @see DummyObject, a skeleton to start from
  * @author Richard Caley <rjc@cstr.ed.ac.uk>
  * @version $Id: SubtypedObject.h,v 1.1 1998/08/12 09:35:52 awb Exp $
  */

template<class BaseClass> 
class SubtypedObject : public SchemeObject {

public:

  /** Record used to store the name of a sub-type and how to 
    * recognise and how to create one.
    */
  typedef 
  struct subtype {
    char *name;
    bool (*recognise)(FILE *stream);
    BaseClass *(*create)();
  } 
  Subtype;

protected:

  /// Table of available subtypes of this type.
  static const Subtype *subtypes;

public:

  /// Name of the type.
  virtual EST_String type_name(void) const;

  /// Name of the subtype.
  virtual EST_String subtype_name(void) const {return "ABSTRACT";}

  /// Create an object of the specified subtype.
  static BaseClass *create(EST_String type);

  /// Is this a subtype name known to the system?
  static int legal_type(EST_String name);

  /// Get an object from the stream, recognises which subtype it is.
  static BaseClass *open(EST_String filename); 

#if 0
  /**@name Subtype functions.
    *  These routines should be defined by specific subtypes.
    */
  //@{
  /// Recognise an object in the stream. Not implemented in SubtypedObject.
  static bool recognise(FILE *stream);
  /// Create an object. Not implemented in SubtypedObject.
  static BaseClass *create(void);
  //@}
#endif


#if defined(INCLUDE_LISP)

  /**@name Scheme interface
    * These are the functions which are imported into Scheme. 
    */
  //@{

protected:
  /// The type tag used in Scheme cells copntaining this type of object.
  static int s_lisp_type;

public:

  /// Make an object of the given subtype.
  static LISP lisp_make(LISP type, LISP properties);
  /// Get an object form the file.
  static LISP lisp_open(LISP filename);

  /// Print out.
  static void lisp_print(LISP, FILE *);
  /// Print to string.
  static void lisp_print_string(LISP, char *);
#endif
};
#endif

