 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;                                                                       ;;
 ;;                Centre for Speech Technology Research                  ;;
 ;;                     University of Edinburgh, UK                       ;;
 ;;                       Copyright (c) 1996,1997                         ;;
 ;;                        All Rights Reserved.                           ;;
 ;;                                                                       ;;
 ;;  Permission to use, copy, modify, distribute this software and its    ;;
 ;;  documentation for research, educational and individual use only, is  ;;
 ;;  hereby granted without fee, subject to the following conditions:     ;;
 ;;   1. The code must retain the above copyright notice, this list of    ;;
 ;;      conditions and the following disclaimer.                         ;;
 ;;   2. Any modifications must be clearly marked as such.                ;;
 ;;   3. Original authors' names are not deleted.                         ;;
 ;;  This software may not be used for commercial purposes without        ;;
 ;;  specific prior written permission from the authors.                  ;;
 ;;                                                                       ;;
 ;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
 ;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
 ;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
 ;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
 ;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
 ;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
 ;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
 ;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
 ;;  THIS SOFTWARE.                                                       ;;
 ;;                                                                       ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;                                                                       ;;
 ;;                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             ;;
 ;;                   Date: Fri Aug 15 1997                               ;;
 ;; -------------------------------------------------------------------   ;;
 ;; Support routines for dealing with unit database.                      ;;
 ;;                                                                       ;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar unit-database-priority-list
  '(".*\\.udb"
    )
  "unit-database-priority-list
   List of patterns matched in order against unit databases to decide which
   to load.")

(define (choose_unitdatabase dbpat dir)
  "(choose_unitdatabase PAT DIR)
   Select what looks like the best unit database matching PAT in the directory."

  (let ((files (directory-entries dir))
	(formatpats unit-database-priority-list)
	file formatpat
	(result nil))
    (while (and formatpats (not result))
	   (set! formatpat (car formatpats))
	   (while (and files (not result))
		  (set! file (car files))
		  (if (and (string-matches file formatpat) (string-matches file dbpat)) (set! result file))
		  (set! files (cdr files))
		  )
	   (set! formatpats (cdr formatpats))
	   )
    (if result 
	(path-append dir result)
	(error "no databases in directory" dir)
	)
    )
  )

(provide 'unitdatabase)



