#ifndef CS_H		/*					CS.H	*/
#define CS_H (1)
#include <stdlib.h>
#include <stdio.h>
#include "sysdep.h"

#include "version.h"

#define VMSGS 1
#if VMSGS
#define VMSG(x) if (odebug) x
#else
#define VMSG(x)
#endif

#define	INSTR	  1
#define	ENDIN	  2
#define	LABEL	  3
#define SETBEG    4
#define STRSET    4
#define PSET      5
#define SETEND    6
/* #define VSET      6 */
/* #define GVSET     7 */
/* #define VDIM      8 */
/* #define VPROGS    9 */
/* #define DVPROGS   10 */
/* #define PGMINIT   17 */
/* #define DPGMINIT  18 */

#define MAXINSNO 200
extern  int maxinsno; 
#define	PMAX	 800
#define VARGMAX  801

#define	ORTXT	   h.optext->t
#define	INCOUNT	   ORTXT.inlist->count
#define	OUTCOUNT   ORTXT.outlist->count
#define	INOCOUNT   ORTXT.inoffs->count
#define	OUTOCOUNT  ORTXT.outoffs->count
#define	XINCODE	   ORTXT.xincod
#define	STRARG	   ORTXT.strarg

#define	MAXLEN	   0x1000000L
#ifdef sol
#undef PMASK
#endif
#define	PMASK	   0x0FFFFFFL
#define	PFRAC(x)   ((float)((x) & ftp->lomask) * ftp->lodiv)
#define MAXPOS     0x7FFFFFFFL

#define BYTREVS(n) (n>>8  & 0xFF | n<<8 & 0xFF00)
#define BYTREVL(n) (n>>24 & 0xFF | n>>8 & 0xFF00L | n<<8 & 0xFF0000L | n<<24 & 0xFF000000L)

#define NOCTS      20
#define OCTRES     8192
#define RESMASK    8191L
#define RESHIFT    13
#define CPSOCTL(n) cpsocint[n >> RESHIFT] * cpsocfrc[n & RESMASK]

#define LOBITS     10
#define LOFACT     1024
#define LOMASK     1023

#define SSTRCOD    0xFFFFFL
#define SSTRSIZ    200
#define ALLCHNLS   9
#define DFLT_SR    44100.0f
#define DFLT_KR    4410.0f
#define DFLT_KSMPS 10
#define DFLT_NCHNLS 1
#define MAXCHNLS   8

#define MAXNAME 128

typedef	struct {
	int	odebug, initonly;
	int	sfread, sfwrite, sfheader, filetyp;
	int	inbufsamps, outbufsamps;
	int	informat, outformat;
	int	insampsiz, outsampsiz;
	int	displays, graphsoff, postscript, msglevel;
	int	Beatmode, cmdTempo, oMaxLag;
	int	usingcscore, Linein, Midiin, FMidiin;
	int	RTevents, ksensing, SusPThresh;
	int	ringbell, termifend, stdoutfd;
	int	rewrt_hdr, heartbeat, gen01defer;
#ifdef LINUX
	int     Volume;		/* Jonathan Mohr  1995 Oct 17 */
#endif
	long	sr_override, kr_override;
	long	instxtcount, optxtsize;
	long	poolcount, gblfixed, gblacount;
	long	argoffsize, strargsize, filnamsize;
	char	*argoffspace, *strargspace, *filnamspace;
	char	*infilename, *outfilename, *playscore;
	char	*Linename, *Midiname, *FMidiname;
} OPARMS;

#ifndef __cplusplus

typedef struct polish {
	char	opcod[12];
	short	incount;
	char	arg[4][12];
} POLISH;

typedef struct arglst {
	short	count;
	char	*arg[1];
} ARGLST;

typedef struct argoffs {
	short	count;
	short	indx[1];
} ARGOFFS;

typedef struct text {
	short	linenum;
	short	opnum;
	char	*opcod;
	char	*strarg;
	ARGLST	*inlist;
	ARGLST	*outlist;
	ARGOFFS	*inoffs;
	ARGOFFS	*outoffs;
	short	xincod;
	char	intype;
	char	pftype;
} TEXT;	
	
typedef struct instr {
	struct op * nxtop;
	TEXT	t;
	short	pmax, vmax, pextrab;
        short	mdepends;
	short	lclkcnt, lcldcnt;
	short	lclwcnt, lclacnt;
	short	lclfixed, optxtcount;
	long	localen;
	long	opdstot;
	long    *inslist;
	float   *psetdata;
	struct insds * instance;
	struct instr * nxtinstxt;
} INSTRTXT;

typedef struct op {
	struct op * nxtop;
	TEXT	t;
} OPTXT;

typedef struct fdch {
	struct fdch * nxtchp;
        int    fd;
} FDCH;

typedef struct auxch {
	struct auxch * nxtchp;
	long   size;
        char   *auxp, *endp;
} AUXCH;

typedef struct monblk {
	short  pch;
	struct monblk *prv;
} MONPCH;

typedef struct {
	int     notnum[4];
} DPEXCL;

typedef struct {
	DPEXCL dpexcl[8];
	int    exclset[75];     /* for keys 25-99 */
} DPARM;

typedef struct dklst {
	struct dklst *nxtlst;
	long   pgmno;
	float  keylst[1];       /* cnt + keynos */
} DKLST;

#define DKBAS  25

typedef struct mchnblk {
	short  pgmno;
	short  insno;
/* 	short  Omni; */
/* 	short  Poly; */
/*         short  bas_chnl; */
/* 	short  nchnls; */
	short  RegParNo;
	short  mono;
	MONPCH *monobas;
	MONPCH *monocur;
	struct insds *kinsptr[128];
	struct insds *ksusptr[128];
	float  polyaft[128];
	float  ctl_val[128];    /* ... with GS vib_rate,, stored in c102-c109 */
/* 	float  katouch[128]; */
/* 	short  ctl_byt[128]; */
	short  ksuscnt;
	short  sustaining;
	float  aftouch;
/* 	float  chnpress; */
	float  pchbend;
	float  posbend;
/* 	float  pbensens; */
	DKLST  *klists;         /* chain of dpgm keylists */
	DPARM  *dparms;         /* drumset params     */
	int    dpmsb;
	int    dplsb;
/* 	float  finetune; */
/* 	float  crsetune; */
  /*	float  tuning; */    /* displ in semitones */
} MCHNBLK;

typedef struct insds {
	struct opds * nxti;
	struct opds * nxtp;
	struct insds * nxtinstance;
	struct insds * prvinstance;
	struct insds * nxtact;
	struct insds * prvact;
	struct insds * nxtoff;
	FDCH	fdch;
	AUXCH	auxch;
	MCHNBLK *m_chnbp;
	short	m_pitch;
	short	m_veloc;
	short   xtratim;
	short   relesing;
	short	insno;
	short	actflg;
	float	offbet;
	float	offtim;
	struct	insds * nxtolap;/* ptr to next overlapping voice */
	/* end of overlap */
	float	p0;
	float	p1;
	float	p2;
	float	p3;
} INSDS;

typedef	void	(*SUBR)(void *);

typedef struct opds {
	struct opds * nxti;
	struct opds * nxtp;
	SUBR	iopadr;
	SUBR	opadr;
	OPTXT   *optext;
	INSDS   *insdshead;
} OPDS;
	
typedef struct lblblk {
	OPDS	h;
	OPDS	*prvi;
	OPDS	*prvp;
} LBLBLK;

typedef struct oentry { 
	char	*opname;
	unsigned short	dsblksiz;
	unsigned short	thread;
	char	*outypes;
	char	*intypes;
	SUBR	iopadr;
	SUBR	kopadr;
	SUBR	aopadr;
} OENTRY;

typedef struct {
	float   *begp, *curp, *endp, feedback[6];
	long    scount;
} OCTDAT;

#define MAXOCTS 8

typedef struct {
	long	npts, nocts, nsamps;
	float   lofrq, hifrq, looct, srate;
	OCTDAT  octdata[MAXOCTS];
	AUXCH	auxch;
} DOWNDAT;

typedef struct {
	long	ktimstamp, ktimprd;
	long	npts, nfreqs, dbout;
	DOWNDAT *downsrcp;
	AUXCH	auxch;
} SPECDAT;

#define AIFF_MAXCHAN 8
typedef struct {
        float   natcps;
        float   gainfac;
        short   loopmode1;
        short   loopmode2;
        long    begin1, end1;
        long    begin2, end2;
        float   maxamps[AIFF_MAXCHAN+1];
} AIFFDAT;

typedef struct {
        float gen01;
        float ifilno;
        float iskptim;
        float iformat;
        float channel;
        char  strarg[SSTRSIZ];
} GEN01ARGS;  

typedef struct {
	long	flen;
	long	lenmask;
	long	lobits;
	long	lomask;
	float	lodiv;
	float	cvtbas, cpscvt;
	short	loopmode1;
	short	loopmode2;
	long	begin1, end1;	/* all these in ..  */
	long	begin2, end2;
	long	soundend, flenfrms; /* .. sample frames */
	long    nchnls;
        long	fno;
        GEN01ARGS gen01args;
	float	ftable[1];
} FUNC;

typedef struct MEMFIL {
	char	filename[64];
	char	*beginp;
	char	*endp;
	long	length;
 struct MEMFIL  *next;
} MEMFIL;

typedef struct event {
	char    *strarg;
	char	opcod;
	short	pcnt;
	float   p2orig;
	float   p3orig;
	float   offtim;
	float   p[PMAX+1];
} EVTBLK;

typedef	struct {
	OPDS	h;
	float	*ktempo, *istartempo;
	float	prvtempo;
} TEMPO;

FUNC   *ftfind(float*);
MEMFIL *ldmemfile(char *);
#if defined CWIN
#elif defined(__MWERKS__) || defined(SYMANTEC)
#define POLL_EVENTS() STasks()
#define __cdecl
#else
#define POLL_EVENTS() 1
#define __cdecl
#endif
#include "prototyp.h"
#ifdef CWIN
#include <stdlib.h>
#define printf cwin_printf
#define err_printf cwin_printf
#undef putchar
#define putchar cwin_putchar
#define exit(n) cwin_exit(n)
extern void cwin_printf(char *, ...);
extern void cwin_fprintf(FILE *, char *, ...);
extern int  cwin_ensure_screen(void);
extern void cwin_putchar(int);
extern void cwin_exit(int);
#define POLL_EVENTS() cwin_ensure_screen()
#else
#define printf dribble_printf
extern void dribble_printf(char *, ...);
extern void err_printf(char *, ...);
#endif /* POLL_EVENTS */
extern FILE* dribble;


#endif /* CWIN */

#endif /* CS_H */
