/* This file is Copyright 1993 by Clifford A. Adams */
/* shdata.c
 *
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "sorder.h"
#include "shelp.h"
#include "shmisc.h"
#include "term.h"
#include "util.h"
#include "INTERN.h"
#include "shdata.h"

/* initialize current context with default values */
void
sh_init_context()
{
    sh_contexts = (SH_CONTEXT*)NULL;
    sh_max_contexts = sh_num_contexts = 0;
}

/* saves the current context then creates and initializes a new context */
void
sh_new_context()
{
    int cnum;
    int i;

    /* save the old context */
    i = sh_num_contexts-1;
    if (i>=0) {			/* there was an old one */
	s_save_context();
	sh_contexts[i].num_ents = sh_num_ents;
	sh_contexts[i].ents_alloc = sh_ents_alloc;
	sh_contexts[i].ents = sh_ents;
	/* save flags here later */
    }

    sh_num_contexts++;
    cnum = s_new_context(S_HELP);
    s_change_context(cnum);
    i = sh_num_contexts-1;
    if (i==0) {		/* first context */
	sh_max_contexts = sh_num_contexts;
	sh_contexts = (SH_CONTEXT*)safemalloc(sizeof(SH_CONTEXT));
    }
    if (sh_num_contexts>sh_max_contexts) {
	sh_contexts = (SH_CONTEXT*)saferealloc((char*)sh_contexts,
			(i+1)*sizeof(SH_CONTEXT));
	sh_max_contexts++;
    }
    sh_contexts[i].cnum = cnum;
    sh_init_ents();

    sh_contexts[i].filename = (char*)NULL;
    sh_contexts[i].title = (char*)NULL;
    /* set flags to defaults (?) later */
    sh_set_screen();
}

/* deletes the current context and restores the last saved one */
void
sh_old_context()
{
    int i;

    /* free the entries (and sub-structures) */
    sh_free_ents();
    /* delete the scan-context */
    s_delete_context(sh_contexts[sh_num_contexts-1].cnum);
    free(sh_contexts[sh_num_contexts-1].title);
    sh_contexts[sh_num_contexts-1].title = (char*)NULL;
    if (sh_contexts[sh_num_contexts-1].filename) {
	free(sh_contexts[sh_num_contexts-1].filename);
	sh_contexts[sh_num_contexts-1].filename = (char*)NULL;
    }
    sh_num_contexts--;

    /* bring back the old context */
    i = sh_num_contexts-1;
    if (i<0)
	return;
    s_change_context(sh_contexts[i].cnum);
    sh_num_ents = sh_contexts[i].num_ents;
    sh_ents_alloc = sh_contexts[i].ents_alloc;
    sh_ents = sh_contexts[i].ents;
    /* restore flags? */
}

bool
sh_init_ents()
{
    sh_num_ents = sh_ents_alloc = 0;
    sh_ents = (SH_ENTRYDATA*)NULL;
    return(TRUE);
}

/* only passes type and dname since other data is type-specific */
/* returns index into sh_ents */
int
sh_add_ent(type,dname)
int type;
char *dname;		/* description name */
{
    int cur;			/* current entry number */

    /* later check for "deleted" entries? */
    sh_num_ents++;
    if (sh_num_ents > sh_ents_alloc) {
	sh_ents_alloc += 100;
	if (sh_ents_alloc==100) {	/* newly allocated */
	    /* don't use number 0--just allocate it and skip it */
	    sh_num_ents = 2;
	    sh_ents = (SH_ENTRYDATA*)safemalloc(sh_ents_alloc*
					sizeof(SH_ENTRYDATA));
        } else {
	    sh_ents = (SH_ENTRYDATA*)saferealloc((char*)sh_ents,
			sh_ents_alloc*sizeof(SH_ENTRYDATA));
	}
    }
    cur = sh_num_ents-1;
    s_order_add(cur);
    sh_ents[cur].type = type;
    /* copy name and free it later */
    sh_ents[cur].name = savestr(dname);
    sh_ents[cur].flags = 0;
    sh_ents[cur].file = (char*)NULL;
    return(cur);
}

/* consider a separate function to free a single entry? */
/* frees the entry structures for the current context */
void
sh_free_ents()
{
    int i;

    /* entry 0 is uninitialized and unused */
    for (i=1;i<sh_num_ents;i++) {
	free(sh_ents[i].name);
	switch (sh_ents[i].type) {
	    case 2:	/* sub-topic */
		free(sh_ents[i].file);
		break;
	}
    }
    if (sh_ents)
	free(sh_ents);
    sh_num_ents = sh_ents_alloc = 0;
}
#endif /* SCAN */
