/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995-1998.  The Regents of the University of California.  All     */
/*   rights reserved.                                                      */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <Xm/Xm.h>

static String non_color_fallbacks[] = {
	"XDir*defaultFontList: *hel*-b*-r-*-12-*,variable",
	"XDir.fixedWidthLayoutFont: 7x13bold",
	"XDir.variableWidthLayoutFont: *hel*-b*-r-*-12-*",
	"XDir*view*text.fontList: 7x13bold,fixed",
	"XDir*borderWidth: 0",
	"XDir.title: Diagnostics",
	"XDir.iconName: Xdir Diag",
	"XDir.form*closeButton.labelString: Close",
	"XDir.form*saveButton.labelString: Save",
	"XDir.form*clearButton.labelString: Clear",
	"XDir.form*helpButton.labelString: Help",
	"XDir.form*diagnosticsLabel1.labelString: Diagnostics",
	"XDir.form*diagnosticsLabel2.labelString: Level",
	"XDir.form*quietToggle.labelString: Quiet",
	"XDir.form*normalToggle.labelString: Normal",
	"XDir.form*verboseToggle.labelString: Verbose",
	"XDir.form*debugToggle.labelString: Debug",
	"XDir.form*diagnosticsFrame.shadowType: SHADOW_ETCHED_IN",
	"XDir.form*log.rows: 8",
	"XDir.form*log.width: 450",
	"XDir*dirWindow.keyboardFocusPolicy: POINTER",
	"XDir*dirWindow.iconName: Xdir Dir",
	"XDir*dirWindow*scrolledWindow.height: 230",
	"XDir*dirWindow*popupAncestorsMenuLabel.labelString: Go to Ancestor",
	"XDir*dirWindow*popupLaunchMenuLabel.labelString: Launch Command",
	"*prefs.title: General Preferences",
	"*prefs.iconName: Xdir GP",
	"*prefs*okButton.labelString: OK",
	"*prefs*applyButton.labelString: Apply",
	"*prefs*cancelButton.labelString: Cancel",
	"*prefs*helpButton.labelString: Help",
	"*prefs*scrolledWindow.height: 250",
	"*prefs*scrolledWindow*rowColumn.frame.shadowType: SHADOW_OUT",
	"*prefs*scrolledWindow*radioBoxFrame.shadowType: SHADOW_ETCHED_IN",
	"*prefs*scrolledWindow.width: 447",
	"*rConnect_popup.title: Connect to Remote",
	"*rConnect.okLabelString: Connect",
	"*rConnect*hostListLabel.labelString: Recently Referenced Hosts:",
	"*rConnect*hostList.visibleItemCount: 6",
	"*rConnect*hostList.scrollBarDisplayPolicy: STATIC",
	"*rConnect*hostNameLabel.labelString: Host Name:",
	"*rConnect*userNameLabel.labelString: User Name:",
	"*aConnect_popup.title: Connect to Anonymous",
	"*aConnect.okLabelString: Connect",
	"*aConnect*hostListLabel.labelString: Recently Referenced Hosts:",
	"*aConnect*hostList.visibleItemCount: 6",
	"*aConnect*hostList.scrollBarDisplayPolicy: STATIC",
	"*aConnect*hostNameLabel.labelString: Host Name:",
	"*aConnect*userNameLabel.labelString: User Name:",
	"*aConnect*passwordLabel.labelString: Password:",
	"*password_popup.title: Password",
	"*password.selectionLabelString: Type password",
	"*account_popup.title: Account",
	"*account.selectionLabelString: Type account",
	"*wildcard_popup.title: Wildcard",
	"*wildcard*listLabel.labelString: Recently Referenced Wildcards:",
	"*wildcard*list.visibleItemCount: 6",
	"*wildcard*list.scrollBarDisplayPolicy: STATIC",
	"*wildcard*list.width: 220",
	"*wildcard*textLabel.labelString: Wildcard to Apply:",
	"*wildcard*replaceToggle.labelString: Replace Selection",
	"*wildcard*addToggle.labelString: Add to Selection",
	"*help_popup.title: Help",
	"*help.width: 500",
	"*help.height: 350",
	"*makeDir_popup.title: Make Directory",
	"*makeDir.selectionLabelString: Directory Name:",
	"*verify_popup.title: Verify Selection",
	"*verify*list.visibleItemCount: 8",
	"*verify*list.scrollBarDisplayPolicy: STATIC",
	"*mpMonitor_popup.title: Monitor",
	"*mpMonitor.width: 500",
	"*gotoDir_popup.title: Go to Directory",
	"*gotoDir.listLabelString: Recently Referenced Directories:",
	"*gotoDir.selectionLabelString: Directory:",
	"*question_popup.title: Question",
	"*question.okLabelString: Yes",
	"*question.cancelLabelString: No",
	"*viewPrefs.title: Viewer Preferences",
	"*viewPrefs.iconName: Xdir VP",
	"*viewPrefs*listLabel.labelString: Extensions:",
	"*viewPrefs*list.visibleItemCount: 8",
	"*viewPrefs*list.scrollBarDisplayPolicy: STATIC",
	"*viewPrefs*extensionLabel.labelString: Extension:",
	"*viewPrefs*commandLineLabel.labelString: Viewer Command Line:",
	"*viewPrefs*editFrame.shadowType: SHADOW_ETCHED_IN",
	"*viewPrefs*addButton.labelString: Add",
	"*viewPrefs*replaceButton.labelString: Replace",
	"*viewPrefs*deleteButton.labelString: Delete",
	"*viewPrefs*messageFrame.shadowType: SHADOW_ETCHED_OUT",
	"*viewPrefs*message1.labelString: If \"Viewer Command Line\" is blank then the built-in",
	"*viewPrefs*message1.alignment: ALIGNMENT_BEGINNING",
	"*viewPrefs*message2.labelString: viewer will be used for that extension.",
	"*viewPrefs*message2.alignment: ALIGNMENT_BEGINNING",
	"*viewPrefs*okButton.labelString: OK",
	"*viewPrefs*applyButton.labelString: Apply",
	"*viewPrefs*cancelButton.labelString: Cancel",
	"*viewPrefs*helpButton.labelString: Help",
	"*firewallPrefs.title: Firewall Preferences",
	"*firewallPrefs.iconName: Xdir FP",
	"*firewallPrefs.width: 500",
	"*firewallPrefs.height: 300",
	"*firewallPrefs*proxyUseToggle.labelString: Use FTP Proxy Server",
	"*firewallPrefs*proxyHostLabel.labelString: Proxy Host",
	"*firewallPrefs*proxyPortLabel.labelString: Proxy Port",
	"*firewallPrefs*proxyDomainsLabel.labelString: Do not use proxy server for these domains:",
	"*firewallPrefs*passiveUseToggle.labelString: Use Passive Mode Data Transfers (PASV)",
	"*firewallPrefs*okButton.labelString: OK",
	"*firewallPrefs*applyButton.labelString: Apply",
	"*firewallPrefs*cancelButton.labelString: Cancel",
	"*firewallPrefs*helpButton.labelString: Help",
	"*xfermon_popup.title: File Transfer Monitor",
	"*xfermon.width: 400",
	"*xfermon*statusLabel.labelString: Status:",
	"*xfermon*nameLabel.labelString: File Name:",
	"*xfermon*lengthLabel.labelString: File Length:",
	"*xfermon*dataRateLabel.labelString: Kbytes/sec:",
	"*rename_popup.title: Rename",
	"*rename.okLabelString: Rename",
	"*rename.applyLabelString: Skip",
	"*rename*dirNameLabel.labelString: Directory:",
	"*rename*oldNameLabel.labelString: Old name:",
	"*rename*newNameLabel.labelString: New name:",
	"*launchPrefs.title: Launcher Preferences",
	"*launchPrefs.iconName: Xdir LP",
	"*launchPrefs*listLabel.labelString: Command Names:",
	"*launchPrefs*list.visibleItemCount: 8",
	"*launchPrefs*list.scrollBarDisplayPolicy: STATIC",
	"*launchPrefs*commandNameLabel.labelString: Command Name:",
	"*launchPrefs*commandLineLabel.labelString: Command Line:",
	"*launchPrefs*editFrame.shadowType: SHADOW_ETCHED_IN",
	"*launchPrefs*addButton.labelString: Add",
	"*launchPrefs*replaceButton.labelString: Replace",
	"*launchPrefs*deleteButton.labelString: Delete",
	"*launchPrefs*messageFrame.shadowType: SHADOW_ETCHED_OUT",
	"*launchPrefs*message1.labelString: In Command Line, use \"%h\" for host, \"%u\" for user, \"%s\"",
	"*launchPrefs*message1.alignment: ALIGNMENT_BEGINNING",
	"*launchPrefs*message2.labelString: for single selected entry, and \"%l\" for all selected entries.",
	"*launchPrefs*message2.alignment: ALIGNMENT_BEGINNING",
	"*launchPrefs*okButton.labelString: OK",
	"*launchPrefs*applyButton.labelString: Apply",
	"*launchPrefs*cancelButton.labelString: Cancel",
	"*launchPrefs*helpButton.labelString: Help",
	"*view.iconName: Xdir View",
	"*view*text.rows: 18",
	"*getFilename.resizePolicy: RESIZE_NONE",
	"*getFilename.width: 350",
	"*quote_popup.title: Send Quoted Command",
	"*quote.okLabelString: Send",
	"*quote*listLabel.labelString: Recently Referenced Commands:",
	"*quote*list.visibleItemCount: 6",
	"*quote*list.scrollBarDisplayPolicy: STATIC",
	"*quote*list.width: 220",
	"*quote*textLabel.labelString: Low-level FTP Command:",
	"*quote*warningLabel.labelString: WARNING!",
	"*quote*warningFrame.shadowType: SHADOW_ETCHED_OUT",
	"*quote*warningMsg1.labelString: Do not send commands directly to the",
	"*quote*warningMsg1.alignment: ALIGNMENT_BEGINNING",
	"*quote*warningMsg2.labelString: FTP server unless you know what you",
	"*quote*warningMsg2.alignment: ALIGNMENT_BEGINNING",
	"*quote*warningMsg3.labelString: are doing.  Press Help for details.",
	"*quote*warningMsg3.alignment: ALIGNMENT_BEGINNING",
	"*about_popup.title: About LLNL XDIR",
	"*about.cancelLabelString: Close",
	"*about.helpLabelString: More",
	"*search_popup.title: Search",
	"*search*textLabel.labelString: Search for:",
	"*search*depth.titleString: Maximum Search Depth",
	"*search*matchCaseToggle.labelString: Match Case",
	"*search*searchThisDirToggle.labelString: Search this directory",
	"*search*searchThisHostToggle.labelString: Search all displayed directories of this host",
	"*search*searchAllHostsToggle.labelString: Search all displayed directories of all hosts",
	"*find_popup.title: Find",
	"*find*form.width: 270",
	"*find*patternLabel.labelString: Search for:",
	"*find*matchCaseLabel.labelString: Case Sensitivity",
	"*find*matchCaseYesToggle.labelString: Match Case",
	"*find*matchCaseNoToggle.labelString: Ignore Case",
	"*find*directionLabel.labelString: Search Direction",
	"*find*searchForwardToggle.labelString: Forward",
	"*find*searchBackwardToggle.labelString: Backward",
	"*searchMonitor_popup.title: Searching",
	"*searchMonitor.width: 450",
	"*searchMonitor*patternLabel.labelString: Pattern:",
	"*searchMonitor*hostLabel.labelString: Host:",
	"*searchMonitor*userLabel.labelString: User:",
	"*searchMonitor*dirLabel.labelString: Directory:",
	"*alert_popup.title: Error",
	"*alert.cancelLabelString: Diagnostics",
	"*editHistory_popup.title: Edit History",
	"*editHistory.width: 550",
	"*editHistory*okButton.labelString: OK",
	"*editHistory*cancelButton.labelString: Cancel",
	"*editHistory*helpButton.labelString: Help",
	"*editHistory*XmList.visibleItemCount: 9",
	"*editHistory*XmList.scrollBarDisplayPolicy: STATIC",
	"*editHistory*hostsLabel.labelString: Hosts",
	"*editHistory*deleteHostButton.labelString: Delete Host",
	"*editHistory*categoriesLabel.labelString: Categories",
	"*editHistory*itemsLabel.labelString: Items",
	"*editHistory*deleteItemButton.labelString: Delete Item",
	"*editHistory.ResizePolicy: RESIZE_NONE",
};

static String color_fallbacks[] = {
	"XDir*background: grey76",
	"XDir*foreground: brown",
	"XDir*highlightColor: brown",
	"XDir*dirWindow*llnlxdirButton.foreground: DeepSkyBlue4",
	"XDir*dirWindow*toolbarForm.tabularButton.foreground: DarkGreen",
	"XDir*dirWindow*toolbarForm.iconicButton.foreground: DarkGreen",
	"XDir*dirWindow*toolbarForm.treeButton.foreground: DarkGreen",
	"XDir*dirWindow*toolbarForm.fullInfoButton.foreground: DarkGreen",
	"XDir*dirWindow*toolbarForm.tunnelingButton.foreground: DeepSkyBlue4",
	"XDir*dirWindow*toolbarForm.dotFilesButton.foreground: DarkOrchid",
	"XDir*dirWindow*toolbarForm.cacheButton.foreground: DarkGreen",
	"XDir*dirWindow*toolbarForm.refreshDirButton.foreground: Red3",
	"XDir*dirWindow*toolbarForm.upArrowButton.foreground: Red3",
	"XDir*dirWindow*toolbarForm.homeButton.foreground: Red3",
	"XDir*dirWindow*toolbarForm.mkdirButton.foreground: Red3",
	"XDir*dirWindow*toolbarForm.deleteButton.foreground: Red3",
	"XDir*dirWindow*toolbarForm.closeButton.foreground: Red3"
};

static int nnon_color_fallbacks = XtNumber(non_color_fallbacks);
static int ncolor_fallbacks = XtNumber(color_fallbacks);


/*
 * get_fallbacks - Return set of built-in fallback resources.  If 
 *                 "use_color" is True, the resources will include
 *                 include some color specifications; otherwise, not.
 *                 Use XtFree() to release returned memory.
 */
String *
get_fallbacks(use_color)
int use_color;
{
	String *fallbacks;
	int i;

	if (use_color) {
		fallbacks = (String *)XtMalloc(sizeof(String)
			*(nnon_color_fallbacks+ncolor_fallbacks+1));
		for (i=0; i<nnon_color_fallbacks; i++)
			fallbacks[i] = non_color_fallbacks[i];
		for (i=0; i<ncolor_fallbacks; i++)
			fallbacks[nnon_color_fallbacks+i] = color_fallbacks[i];
		fallbacks[nnon_color_fallbacks+ncolor_fallbacks] = NULL;
	} else {
		fallbacks = (String *)XtMalloc(sizeof(String)*(nnon_color_fallbacks+1));
		for (i=0; i<nnon_color_fallbacks; i++)
			fallbacks[i] = non_color_fallbacks[i];
		fallbacks[nnon_color_fallbacks] = NULL;
	}
	return fallbacks;
}

