#
# Copyright (c) 1995,1996,1997 University College London
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, is permitted, for non-commercial use only, provided 
# that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by the Computer Science
#      Department at University College London
# 4. Neither the name of the University nor of the Department may be used
#    to endorse or promote products derived from this software without
#    specific prior written permission.
# Use of this software for commercial purposes is explicitly forbidden
# unless prior written permission is obtained from the authors. 
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

option add *background 			gray80 		widgetDefault
option add *foreground 			black 		widgetDefault
option add *activeBackground 		gray85 		widgetDefault
option add *selectBackground 		gray85 		widgetDefault
option add *Scale.sliderForeground 	gray80 		widgetDefault
option add *Scale.activeForeground 	gray85 		widgetDefault
option add *Scale.background 		gray80		widgetDefault
option add *Entry.background 		gray70 		widgetDefault
option add *Menu*selectColor 		forestgreen 	widgetDefault
option add *Radiobutton*selectColor 	forestgreen 	widgetDefault
option add *Checkbutton*selectColor 	forestgreen 	widgetDefault
option add *borderWidth 		1 

set statsfont     -*-courier-medium-r-*-*-12-*-*-*-*-*-iso8859-1
set titlefont     -*-helvetica-medium-r-normal--14-*-p-*-iso8859-1
set infofont      -*-helvetica-medium-r-normal--12-*-p-*-iso8859-1
set smallfont     -*-helvetica-medium-r-normal--10-*-p-*-iso8859-1
set verysmallfont -*-courier-medium-o-normal--8-*-m-*-iso8859-1

set V(class) "Mbone Applications"
set V(app)   "rat"

if { [string compare [info procs putregistry] "putregistry"] == 0} {
    set win32 1
} else {
    set win32 0
}

#dropdown list
proc dropdown {w varName command args} {

    global $varName 
    set firstValue [lindex $args 0]

    if ![info exists $varName] {
	set $varName $firstValue
    }

    menubutton $w -textvariable var -indicatoron 0 -menu $w.menu -text $firstValue -textvariable $varName -relief raised 
    menu $w.menu -tearoff 0
    foreach i $args {
	$w.menu add radiobutton -variable $varName -label $i -value $i -command "$command [lindex $i 0]" 
    }
    return $w.menu
}

#power meters
proc bargraph {frame} {
	global oh$frame

	frame $frame -bg black
	frame $frame.inner0 -width 8 -height 4 -bg green
	pack $frame.inner0 -side bottom -pady 1 -fill both -expand true
	for {set i 1} {$i < 16} {incr i} {
	  frame $frame.inner$i -width 8 -height 4 -bg black
	  pack $frame.inner$i -side bottom -pady 1 -fill both -expand true
	}
	set oh$frame 0
}

proc setHeight {frame height} {
	upvar oh$frame oh

	if {$oh > $height} {
	  for {set i [expr $height + 1]} {$i <= $oh} {incr i} {
		$frame.inner$i config -bg black
	  }
	} else {
	  for {set i [expr $oh + 1]} {$i <= $height} {incr i} {
		if {$i > 12} {
			$frame.inner$i config -bg red
		} else {
			$frame.inner$i config -bg green
	        }
	  }
	}

	set oh $height
}

set ibd	2
set iht	16
set iwd 190
set lh 0

proc update_info {index name colour} {
	global ibd iht iwd lh
	catch [.l.t.list delete t$index]
	catch [.l.t.list delete b$index]
	set by [expr ($ibd + $iht) * ($index + 1)]
	.l.t.list create rectangle \
		$ibd [expr ($ibd + $iht) * $index + $ibd] \
		[expr $iwd - $ibd] $by -outline {} -tags b$index
	.l.t.list create text [expr $ibd + 2] [expr ($ibd + $iht) * $index + $ibd + 2] -tags t$index -anchor nw -text $name -fill $colour

	if {$by > $lh} {
		set lh $by
		.l.t.list configure -scrollregion "0.0 0.0 $iwd $lh"
	}
}

proc remove_info index {
	catch [.l.t.list delete t$index]
	catch [.l.t.list delete b$index]
	catch [.l.t.list delete m$index]
}

proc activate_info index {
	catch [.l.t.list itemconfigure b$index -fill white]
}

proc gray_info index {
	catch [.l.t.list itemconfigure b$index -fill gray90]
}

proc deactivate_info index {
	catch [.l.t.list itemconfigure b$index -fill {}]
}

set cancel_info_timer 0

proc info_timer {} {
	global cancel_info_timer
	if {$cancel_info_timer == 1} {
		set cancel_info_timer 0
	} else {
		update_rec_info
		after 1000 info_timer
	}
}

proc stats_timer i {
	if {[winfo exists .stats$i]} {stats $i}
}

proc update_stats {i s} {
	global statsfont
	if {[winfo exists .stats$i] == 0} {
		# Window does not exist so create it
		toplevel .stats$i
		message .stats$i.m -width 600 -font $statsfont
		pack .stats$i.m -side top
		button .stats$i.d -highlightthickness 0 -padx 0 -pady 0 -text "Dismiss" -command "destroy .stats$i" 
		pack .stats$i.d -side bottom -fill x
		wm title .stats$i "RAT user info $i"
		wm resizable .stats$i 0 0
	}
	.stats$i.m configure -text $s
	after 1000 "stats_timer $i"
}

# Initialise RAT MAIN window
frame .r 
frame .l 
frame .l.t -relief raised
scrollbar .l.t.scr -relief flat -highlightthickness 0 -command ".l.t.list yview"
canvas .l.t.list -highlightthickness 0 -bd 0 -relief raised -width $iwd -yscrollcommand ".l.t.scr set" -yscrollincrement [expr $ibd + $iht]
frame .l.s -bd 0
button .l.s.opts -highlightthickness 0 -padx 0 -pady 0 -text Options -command "wm deiconify .b"
button .l.s.about -highlightthickness 0 -padx 0 -pady 0 -text About -command {wm deiconify .about}
button .l.s.quit -highlightthickness 0 -padx 0 -pady 0 -text Quit -command {update; destroy .; update}

# Make a click in the participants window put up participant stats
bind .l.t.list <Button-1> {
	stats [expr int(([.l.t.list canvasy %y] - $ibd) / ($ibd + $iht))]
}

# Make Button-2 mute and unmute participants
bind .l.t.list <Button-2> {
	set index [expr int(([.l.t.list canvasy %y] - $ibd) / ($ibd + $iht))]
	if {[.l.t.list gettags m$index] == ""} {
		if {[mute $index 1]} {
			set y [expr ($ibd + $iht) * $index + $ibd + $iht / 2]
			.l.t.list create line $ibd $y [expr $iwd - $ibd] $y \
				-tags m$index -width 2.0 -fill gray95
		}
	} else {
		if {[mute $index 0]} {
			catch [.l.t.list delete m$index]
		}
	}
}

pack .r -side right -fill y
frame .r.c
pack .r.c -side top -fill y -expand 1
frame .r.c.vol
frame .r.c.gain
pack .r.c.vol -side left -fill y
pack .r.c.gain -side right -fill y

pack .l -side left -fill both -expand 1
pack .l.s -side bottom -fill x
pack .l.s.opts .l.s.about .l.s.quit -side left -fill x -expand 1
pack .l.t -side top -fill both -expand 1
pack .l.t.scr -side left -fill y
pack .l.t.list -side left -fill both -expand 1

# Device output controls
button .r.c.vol.t1 -highlightthickness 0 -padx 0 -pady 0 -text mute -command toggle_play 
button .r.c.vol.l1 -highlightthickness 0 -padx 0 -pady 0 -command toggle_output_port -bitmap "speaker"
bargraph .r.c.vol.b1
scale .r.c.vol.s1 -highlightthickness 0 -font $verysmallfont -from 99 -to 0 -command set_vol -orient vertical -relief raised 

pack .r.c.vol.t1 -side top -fill x
pack .r.c.vol.l1 -side top -fill x
pack .r.c.vol.b1 -side left -fill y
pack .r.c.vol.s1 -side right -fill y

# Device input controls
button .r.c.gain.t2 -highlightthickness 0 -padx 0 -pady 0 -text mute -command toggle_send -relief sunken
button .r.c.gain.l2 -highlightthickness 0 -padx 0 -pady 0 -command toggle_input_port -bitmap "mic_mute"
bargraph .r.c.gain.b2
scale .r.c.gain.s2 -highlightthickness 0 -font $verysmallfont -from 99 -to 0 -command set_gain -orient vertical -relief raised 

pack .r.c.gain.t2 -side top -fill x
pack .r.c.gain.l2 -side top -fill x
pack .r.c.gain.b2 -side left -fill y
pack .r.c.gain.s2 -side right -fill y

proc disable_audio_ctls {} {
	.r.c.vol.t1 configure -state disabled
	.r.c.vol.l1 configure -state disabled
	.r.c.vol.s1 configure -state disabled
	.r.c.gain.t2 configure -state disabled
	.r.c.gain.l2 configure -state disabled
	.r.c.gain.s2 configure -state disabled
	.r.b.a       configure -state normal
}

proc enable_audio_ctls {} {
	.r.c.vol.t1 configure -state normal
	.r.c.vol.l1 configure -state normal
	.r.c.vol.s1 configure -state normal
	.r.c.gain.t2 configure -state normal
	.r.c.gain.l2 configure -state normal
	.r.c.gain.s2 configure -state normal
	.r.b.a       configure -state disabled
}

frame .r.b -relief raised 
pack .r.b -side bottom -fill x
label .r.b.v -highlightthickness 0 -bd 0 -font $smallfont -text $ratversion
pack .r.b.v -side bottom -fill x
label .r.b.ucl -highlightthickness 0 -bd 0 -bitmap "ucl"
pack .r.b.ucl -side bottom -fill x
button .r.b.a -padx 0 -pady 0 -highlightthickness 0 -text "Get Audio" -command {get_audio}
pack .r.b.a -side bottom -fill x

bind all <ButtonPress-3> "toggle_send"
bind all <ButtonRelease-3> "toggle_send"
bind all <q> {destroy .}

wm iconbitmap . rat_small
wm resizable . 1 1
if ([info exists geometry]) {
        wm geometry . $geometry
}

# Initialise CONTROL toplevel window
toplevel .b
wm withdraw .b

set rate_var 	"40 ms"
set output_var 	"Full duplex"
set redun 	0
set sync_var 	0
set silence_var 1
set repair_var 	"Packet Repetition"
set lecture_var	0
set bias_var	1
set meter_var	1
# These next two are updated by ui_rat.c...
set prenc  	DVI
set secenc 	NONE

frame .b.f
pack .b.f -side top -fill x

# packet format options
frame .b.f.pkt 
pack  .b.f.pkt -side top -fill both -expand 1
label .b.f.pkt.l -highlightthickness 0 -text "Packet Format"
pack  .b.f.pkt.l
# length
frame .b.f.pkt.len -relief sunken
pack  .b.f.pkt.len -side left -fill x
label .b.f.pkt.len.l -highlightthickness 0 -justify left -text  "Duration"
pack  .b.f.pkt.len.l -side top -fill both -expand 1
dropdown .b.f.pkt.len.dl rate_var rate "20 ms" "40 ms" "80 ms"  "160 ms"
pack     .b.f.pkt.len.dl -side left -fill x -expand 1
# primary
frame .b.f.pkt.pr -relief sunken
pack  .b.f.pkt.pr -side left -fill x
label .b.f.pkt.pr.l -highlightthickness 0 -justify left -text  "Primary Encoding"
pack  .b.f.pkt.pr.l -side top -fill both -expand 1
dropdown .b.f.pkt.pr.dl prenc primary "16-bit linear" "PCM (mu-law)" DVI GSM LPC
pack  .b.f.pkt.pr.dl -side left -fill x -expand 1

# secondary
frame .b.f.pkt.sec -relief sunken
pack  .b.f.pkt.sec -side left -fill x
label .b.f.pkt.sec.l -highlightthickness 0 -justify left -text  "Secondary Encoding"
pack  .b.f.pkt.sec.l -side top -fill both -expand 1
dropdown .b.f.pkt.sec.dl secenc redundancy NONE "PCM (mu-law)" DVI GSM LPC
pack  .b.f.pkt.sec.dl -side left -fill x -expand 1

# Local Options
frame .b.f.loc
pack  .b.f.loc -side top -fill both -expand 1
label .b.f.loc.l -highlightthickness 0 -text "Local Options"
pack  .b.f.loc.l -side top -fill x -expand 1

# Mode

frame .b.f.loc.mode -relief sunken -width 500
pack  .b.f.loc.mode -side left -fill x -expand 0
label .b.f.loc.mode.l -highlightthickness 0 -justify left -text  "Mode                "
pack  .b.f.loc.mode.l -side top -expand 1 -anchor w
dropdown .b.f.loc.mode.dl output_var output "Net mutes mike" "Mike mutes net" "Full duplex"
pack  .b.f.loc.mode.dl -side left -fill x -expand 1

# Receiver Repair Options
frame .b.f.loc.rep -relief sunken
pack  .b.f.loc.rep -side left  -fill x -expand 1
label .b.f.loc.rep.l -highlightthickness 0 -justify left -text "Loss Repair"
pack  .b.f.loc.rep.l -side top -expand 1 -anchor w
dropdown .b.f.loc.rep.dl repair_var repair None "Packet Repetition" 
pack  .b.f.loc.rep.dl -side left -fill x -expand 1

# Misc controls
frame .b.f2 -bd 0
pack .b.f2 -side top -fill x

# Generic toggles
frame .b.f2.l -relief sunken 
pack  .b.f2.l -side left -expand 1 -fill both
frame .b.f2.r -relief sunken 
pack  .b.f2.r -side left -expand 1 -fill both
checkbutton .b.f2.l.sil   -anchor w -highlightthickness 0 -relief flat -text "Suppress Silence"       -variable silence_var -command {silence    $silence_var}
checkbutton .b.f2.l.meter -anchor w -highlightthickness 0 -relief flat -text "Powermeters"            -variable meter_var   -command {powermeter $meter_var}
checkbutton .b.f2.l.lec   -anchor w -highlightthickness 0 -relief flat -text "Lecture Mode"           -variable lecture_var -command {lecture    $lecture_var}
checkbutton .b.f2.r.agc   -anchor w -highlightthickness 0 -relief flat -text "Automatic Gain Control" -variable agc_var     -command {agr        $agc_var} -state disabled
checkbutton .b.f2.r.syn   -anchor w -highlightthickness 0 -relief flat -text "Video Synchronisation"  -variable sync_var    -command {sync       $sync_var} -state disabled
checkbutton .b.f2.r.afb   -anchor w -highlightthickness 0 -relief flat -text "Acoustic Feedback"      -variable afb_var     -command {afb        $afb_var} -state disabled

pack .b.f2.l.sil   -side top -fill x -expand 1
pack .b.f2.l.meter -side top -fill x -expand 1
pack .b.f2.l.lec   -side top -fill x -expand 0
pack .b.f2.r.syn   -side top -fill x -expand 0
pack .b.f2.r.agc   -side top -fill x -expand 1
pack .b.f2.r.afb   -side top -fill x -expand 0

#Session Key
frame .b.crypt -bd 0
pack  .b.crypt -side top -fill x -expand 1
label .b.crypt.l -text Encryption 
pack  .b.crypt.l

label .b.crypt.kn -highlightthickness 0 -text "Key:"
pack .b.crypt.kn -side left -fill x
entry .b.crypt.name -highlightthickness 0 -width 20 -relief sunken -textvariable key
bind .b.crypt.name <Return> {UpdateKey $key .b.crypt }
bind .b.crypt.name <BackSpace> { CheckKeyErase $key .b.crypt }
bind .b.crypt.name <Any-Key> { KeyEntryCheck $key .b.crypt "%A" }
bind .b.crypt.name <Control-Key-h> { CheckKeyErase $key .b.crypt }
pack .b.crypt.name -side left -fill x -expand 1

checkbutton .b.crypt.enc -state disabled -highlightthickness 0 -relief flat -text "On/Off" -variable key_var -command {ToggleKey $key_var}
pack .b.crypt.enc -side left -fill x 


proc DisableSessionKey w {
    global key_var
 
    set key_var 0
    $w.enc configure -state disabled
}

proc EnableSessionKey w {
    global key_var

    $w.enc configure -state normal
}

proc KeyEntryCheck { key w key_val } {

  if { $key_val != "{}" } {
    if { [string length $key] == 0 } {
	EnableSessionKey $w
    }
  }
} 

proc CheckKeyErase { key w } {

  if { [string length $key] == 1 } {
    UpdateKey "" $w 
  }
}

proc UpdateKey { key w } {
  global key_var
 
  if { $key == "" } {
    DisableSessionKey $w
  } else {
    EnableSessionKey $w
    set key_var 1
  }
  InstallKey $key
}
  
proc ToggleKey { encrypt } {
  global key 

  if !($encrypt) {
    InstallKey ""
  } else {
    InstallKey $key
  }
}

set cryptpos [lsearch $argv "-crypt"]
if {$cryptpos == -1} then {
  set key_var 0
} else {
  set key   [lindex $argv [expr $cryptpos + 1]]
  UpdateKey [lindex $argv [expr $cryptpos + 1]] .b.crypt
}

# File options
frame .b.f3
pack .b.f3 -side top -fill x

# Play
set play_file infile.rat
frame .b.f3.p -relief sunken 
pack .b.f3.p -side left -fill both -expand 1
label .b.f3.p.l -highlightthickness 0 -text "Play file"
pack .b.f3.p.l -side top -fill x
frame .b.f3.p.f -bd 0
pack .b.f3.p.f -side top -fill x
label .b.f3.p.f.l -highlightthickness 0 -text "File:"
pack .b.f3.p.f.l -side left -fill x
entry .b.f3.p.f.file -highlightthickness 0 -width 10 -relief sunken -textvariable play_file
pack .b.f3.p.f.file -side right -fill x -expand 1
frame .b.f3.p.f2 -bd 0
pack .b.f3.p.f2 -side top -fill x
button .b.f3.p.f2.on -padx 0 -pady 0 -highlightthickness 0 -text "Start" -command {play $play_file}
pack .b.f3.p.f2.on -side left -fill x -expand 1
button .b.f3.p.f2.off -padx 0 -pady 0 -highlightthickness 0 -text "Stop" -command {play stop}
pack .b.f3.p.f2.off -side right -fill x -expand 1

# Record
set rec_file outfile.rat
frame .b.f3.r -relief sunken
pack .b.f3.r -side right -fill both -expand 1
label .b.f3.r.l -highlightthickness 0 -text "Record file"
pack .b.f3.r.l -side top -fill x
frame .b.f3.r.f -bd 0
pack .b.f3.r.f -side top -fill x
label .b.f3.r.f.l -highlightthickness 0 -text "File:"
pack .b.f3.r.f.l -side left -fill x
entry .b.f3.r.f.file -highlightthickness 0 -width 10 -relief sunken -textvariable rec_file
pack .b.f3.r.f.file -side right -fill x -expand 1
frame .b.f3.r.f2 -bd 0
pack .b.f3.r.f2 -side top -fill x
button .b.f3.r.f2.on -padx 0 -pady 0 -highlightthickness 0 -text "Start" -command {rec $rec_file}
pack .b.f3.r.f2.on -side left -fill x -expand 1
button .b.f3.r.f2.off -padx 0 -pady 0 -highlightthickness 0 -text "Stop" -command {rec stop}
pack .b.f3.r.f2.off -side right -fill x -expand 1

# Address...
frame .b.a -relief sunken
pack  .b.a -side top -fill x
label .b.a.l -highlightthickness 0 -text "RTP Configuration"
pack  .b.a.l -side top
label .b.a.address -highlightthickness 0 -text "Group: Port: TTL:"
pack  .b.a.address -side top -fill x
frame .b.a.rn -bd 0
pack  .b.a.rn -side top -fill x
entry .b.a.rn.name -highlightthickness 0 -width 35 -relief sunken -textvariable rtcp_name
bind  .b.a.rn.name <Return> {rtcp_name $rtcp_name; savename}
bind  .b.a.rn.name <Tab>    {rtcp_name $rtcp_name; savename}
pack  .b.a.rn.name -side right -fill x 
label .b.a.rn.l -highlightthickness 0 -text "Name:"
pack  .b.a.rn.l -side left -fill x -expand 1
frame .b.a.re -bd 0
pack  .b.a.re -side top -fill x
entry .b.a.re.name -highlightthickness 0 -width 35 -relief sunken -textvariable rtcp_email
bind  .b.a.re.name <Return> {rtcp_email $rtcp_email; savename}
bind  .b.a.re.name <Tab>    {rtcp_email $rtcp_email; savename}
pack  .b.a.re.name -side right -fill x
label .b.a.re.l -highlightthickness 0 -text "Email:"
pack  .b.a.re.l -side left -fill x -expand 1
frame .b.a.rp -bd 0
pack  .b.a.rp -side top -fill x
entry .b.a.rp.name -highlightthickness 0 -width 35 -relief sunken -textvariable rtcp_phone
bind  .b.a.rp.name <Return> {rtcp_phone $rtcp_phone; savename}
bind  .b.a.rp.name <Tab>    {rtcp_phone $rtcp_phone; savename}
pack  .b.a.rp.name -side right -fill x
label .b.a.rp.l -highlightthickness 0 -text "Phone:"
pack  .b.a.rp.l -side left -fill x -expand 1
frame .b.a.rl -bd 0
pack  .b.a.rl -side top -fill x
entry .b.a.rl.name -highlightthickness 0 -width 35 -relief sunken -textvariable rtcp_loc
bind  .b.a.rl.name <Return> {rtcp_loc $rtcp_loc; savename}
bind  .b.a.rl.name <Tab>    {rtcp_loc $rtcp_loc; savename}
pack  .b.a.rl.name -side right -fill x
label .b.a.rl.l -highlightthickness 0 -text "Location:"
pack  .b.a.rl.l -side left -fill x -expand 1

label .b.rat -bitmap rat2 -relief sunken
pack .b.rat -fill x -expand 1

button .b.d -highlightthickness 0 -padx 0 -pady 0 -text "Dismiss" -command "wm withdraw .b"
pack .b.d -side bottom -fill x

wm title .b "RAT controls"
wm resizable .b 0 0

# Initialise ABOUT toplevel window
toplevel .about
wm withdraw .about
frame .about.a
label .about.a.b -highlightthickness 0 -bitmap rat_med
message .about.a.m -text {
RAT Development Team:
    Angela Sasse
    Vicky Hardman
    Isidor Kouvelas
    Colin Perkins
    Orion Hodson
    Darren Harris
    Anna Watson 
    Mark Handley
    Jon Crowcroft
}
message .about.b -width 1000 -text {
The Robust-Audio Tool has been written in the Department of Computer
Science, University College London, UK. The work was supported by projects: 

   - Multimedia Integrated Conferencing for Europe (MICE)
   - Multimedia European Research in Conferencing Integration (MERCI)
   - Remote Language Teaching for SuperJANET (ReLaTe)
   - Robust Audio Tool (RAT)

Further information is available on the world-wide-web, please access URL:
http://www-mice.cs.ucl.ac.uk/mice/rat/

Please send comments/suggestions/bug-reports to <rat-trap@cs.ucl.ac.uk>
}
button .about.c -highlightthickness 0 -padx 0 -pady 0 -text Copyright -command {wm deiconify .copyright}
button .about.d -highlightthickness 0 -padx 0 -pady 0 -text Dismiss   -command {wm withdraw  .about}
pack .about.a .about.b .about.c .about.d -side top -fill x
pack .about.a.b -side left -fill y
pack .about.a.m -side right -fill both -expand 1
wm title .about "About RAT"
wm resizable .about 0 0
 
toplevel .copyright
wm withdraw .copyright
message   .copyright.m -text {
 Robust-Audio Tool (RAT)
 
 Copyright (C) 1995,1996,1997 University College London
 All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, is permitted, for non-commercial use only, provided 
 that the following conditions are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. All advertising materials mentioning features or use of this software
    must display the following acknowledgement:
      This product includes software developed by the Computer Science
      Department at University College London
 4. Neither the name of the University nor of the Department may be used
    to endorse or promote products derived from this software without
    specific prior written permission.
 Use of this software for commercial purposes is explicitly forbidden
 unless prior written permission is obtained from the authors. 
 
 THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.
 
 Modifications for HP-UX by Terje Vernly <terjeve@usit.uio.no> and 
 Geir Harald Hansen <g.h.hansen@usit.uio.no>.

 This software is derived, in part, from publically available source code
 with the following copyright:
 
 Copyright (c) 1991 University of Southern California
 Copyright (c) 1993,1994 AT&T Bell Laboratories
 Copyright (c) 1991-1993,1996 Regents of the University of California
 Copyright (c) 1992 Stichting Mathematisch Centrum, Amsterdam
 Copyright (c) 1991,1992 RSA Data Security, Inc
 Copyright (c) 1992 Jutta Degener and Carsten Bormann, Technische Universitaet Berlin
 Copyright (c) 1994 Henning Schulzrinne
 Copyright (c) 1994 Paul Stewart
 
 This product includes software developed by the Computer Systems
 Engineering Group and by the Network Research Group at Lawrence 
 Berkeley Laboratory.
 
 Encryption features of this software use the RSA Data Security, Inc. 
 MD5 Message-Digest Algorithm.
} 
button .copyright.d -highlightthickness 0 -padx 0 -pady 0 -text Dismiss   -command {wm withdraw  .copyright}
pack   .copyright.m .copyright.d -side top -fill x -expand 1
wm title     .copyright "RAT Copyright"
wm resizable .copyright 0 0

if {[glob ~] == "/"} {
	set rtpfname /.RTPdefaults
} else {
	set rtpfname ~/.RTPdefaults
}


proc savename {} {
    global rtpfname rtcp_name rtcp_email rtcp_phone rtcp_loc V win32
    if {$win32 == 0 } {
	set f [open $rtpfname w]
	if {$rtcp_name  != ""} {puts $f "*rtpName:  $rtcp_name"}
	if {$rtcp_email != ""} {puts $f "*rtpEmail: $rtcp_email"}
	if {$rtcp_phone != ""} {puts $f "*rtpPhone: $rtcp_phone"}
	if {$rtcp_loc   != ""} {puts $f "*rtpLoc:   $rtcp_loc"}
	close $f
    } else {
	putregistry "HKEY_CURRENT_USER\\Software\\$V(class)\\$V(app)" "*rtpName"  "$rtcp_name"
	putregistry "HKEY_CURRENT_USER\\Software\\$V(class)\\$V(app)" "*rtpEmail"  "$rtcp_email"
	putregistry "HKEY_CURRENT_USER\\Software\\$V(class)\\$V(app)" "*rtpPhone"  "$rtcp_phone"
	putregistry "HKEY_CURRENT_USER\\Software\\$V(class)\\$V(app)" "*rtpLoc"  "$rtcp_loc"
    }
}

set rtcp_name  [option get . rtpName  rat]
set rtcp_email [option get . rtpEmail rat]
set rtcp_phone [option get . rtpPhone rat]
set rtcp_loc   [option get . rtpLoc   rat]

if {$win32 == 0} {
    if {$rtcp_name == "" && [file readable $rtpfname] == 1} {
	set f [open $rtpfname]
	while {[eof $f] == 0} {
	    gets $f line
	    if {[string compare "*rtpName:"  [lindex $line 0]] == 0} {set rtcp_name  [lrange $line 1 end]}
	    if {[string compare "*rtpEmail:" [lindex $line 0]] == 0} {set rtcp_email [lrange $line 1 end]}
	    if {[string compare "*rtpPhone:" [lindex $line 0]] == 0} {set rtcp_phone [lrange $line 1 end]}
	    if {[string compare "*rtpLoc:"   [lindex $line 0]] == 0} {set rtcp_loc   [lrange $line 1 end]}
	}
	close $f
    }
} else {
    if {$rtcp_name == ""} {
	catch {set rtcp_name  [getregistry "HKEY_CURRENT_USER\\Software\\$V(class)\\$V(app)" "*rtpName"]  } 
	catch {set rtcp_email [getregistry "HKEY_CURRENT_USER\\Software\\$V(class)\\$V(app)" "*rtpEmail"] } 
	catch {set rtcp_phone [getregistry "HKEY_CURRENT_USER\\Software\\$V(class)\\$V(app)" "*rtpPhone"] } 
	catch {set rtcp_loc   [getregistry "HKEY_CURRENT_USER\\Software\\$V(class)\\$V(app)" "*rtpLoc"  ] } 
    }
}

rtcp_name  $rtcp_name
rtcp_email $rtcp_email
rtcp_phone $rtcp_phone
rtcp_loc   $rtcp_loc

if {$rtcp_name == ""} {
    toplevel .name
    wm title .name "RAT User Information"
    message .name.m -width 1000 -text {
	Please enter the following details, for transmission
	to other conference participants.
    }
	frame  .name.b
    label  .name.b.res -text "Name:"
    entry  .name.b.e -highlightthickness 0 -width 20 -relief sunken -textvariable rtcp_name
    button .name.d -highlightthickness 0 -padx 0 -pady 0 -text Done -command {rtcp_name $rtcp_name; savename; destroy .name}
    bind   .name.b.e <Return> {rtcp_name $rtcp_name; savename; destroy .name}
    
    pack .name.m -side top -fill x -expand 1
    pack .name.b -side top -fill x -expand 1
    pack .name.b.res -side left
    pack .name.b.e -side right -fill x -expand 1
    pack .name.d -side bottom -fill x -expand 1
    wm resizable .name 0 0
    update
    raise .name .
}

update

catch {
    source ~/.rat
}


