#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xsqldefs.h"

void XsqlSQLQuery(FL_OBJECT *ob, long parent)
{
   FD_Xsql    *Xsql = (FD_Xsql *)parent;
   Info_t     *I,*L;
   FD_Shower  *fd_Shw;
   m_field    *field;
   m_row      row;
   int        x,numrows;
   char       *ptr;
   FILE       *input;
   static char query[MAXQUERY] = "SELECT ";

   switch(fl_show_choices("Choose how to enter your query :",3,
			 "Manual","Read file","Cancel",1))
   {
    case 1:
      ptr=(char *)fl_show_input("Enter SQL Select statement :",query);
      if(ptr == NULL || strlen(ptr) < 1)
	return;
      strncpy(query,ptr,MAXQUERY);
      break;
    case 2:
      ptr = (char *)fl_show_fselector("Set Inputfile","","*.sql","");
      if (ptr == NULL)
	return;
      
      if((input = fopen(ptr,"r")) == NULL)
      {
	 Message("Can't open input file");
	 return;
      }
      x=fread(query,1,MAXQUERY-1,input);
      if(query[x-1] == '\n')
	query[x-1]='\0';
      else
	query[x]='\0'; /* append terminating zero */
      fclose(input);
      break;
    case 3:
      return;
   }
   
   I = (Info_t *) malloc(sizeof(Info_t));

   I->Xsql = Xsql;
   if (ExecuteQuery(I,query))
     return;
   if((I->Res = msqlStoreResult()) == NULL)
     return; /* This can happen with i.e. a DROP query ! */
   
   I->Allflds = I->Numflds = msqlNumFields(I->Res);

   /* Must malloc table as FreeResult will try to free it
    * when closing Browser !
    */
   I->Table = (char *)malloc(1);
   *I->Table = '\0'; /* don't need a tablename as selection is not allowed */
   
   I->Fields = (m_field *)malloc(I->Numflds * sizeof(m_field));

   for(x=0;x<I->Numflds;x++)
   {
      field = msqlFetchField(I->Res);
      memcpy(&I->Fields[x],field,sizeof(m_field));
      
      if((ptr = (char *)malloc(strlen(I->Fields[x].name) + 1)) == NULL)
      {
	 SqlError("Not enough memory to store fieldnames !");
	 exit(1);
      }
      strcpy(ptr,I->Fields[x].name);
      I->Fields[x].name = ptr;
      I->Fields[x].table = I->Table; /* useless to copy */
   }
   
   Message("Selection of records is disabled as it can have \n"
	   "unpredictable side effects with free queries !");
   fd_Shw = BuildShowerForm(I,"Show Free Query",PASSIVE);
   
   L = (Info_t *) fd_Shw->vdata;
   L->Res = I->Res;
   
   numrows = msqlNumRows(I->Res);/* get number of records in selection */
   
   fl_freeze_form(fd_Shw->Shower);
   
   for(x=0;x < numrows;x++)
   {
      if((row = msqlFetchRow(I->Res)) == NULL)
      {
	 SqlError("Error reading record !");
	 return;
      }
      WriteToBrowser(I,fd_Shw->Browser,row);
   }
   fl_unfreeze_form(fd_Shw->Shower);
}

