#ifndef _TEMPLATE_H_

#define _TEMPLATE_H_

#include <savutil.h>

extern int SavantVerbose, SavantDebug, SavantFollowLinks;

#define RECOGNIZE_LIMIT 500       /* num characters to look for recognition in */

/* config stuff */
typedef struct {
  int windowing;
  int lines_per_window;
  int source_field_width;
  int ellipses;
  int index_dotfiles;
} UserVars;

enum P_Tokens {STARTLINE, IGNORE, ANYORDER, ANYOF, ICASE, OPTIONAL,
		LITERAL, SUBJECT, DATE, SOURCE, LOCATION, BODY,
		LBRACE, RBRACE, PATTERN};
    
typedef struct {
  enum P_Tokens ID;
  union {
    char *str;
    struct _Pattern *pat;
  } ptr;
} Pattern_Token;

typedef struct _Pattern {
  Pattern_Token *token;
  struct _Pattern *next;
} Pattern;

typedef struct {
  char *name;
  Pattern *recognize;
  Pattern *delimiter;
  Pattern *format;
  int biases[NUM_FIELD_TYPES];
} Template;

typedef struct _List_of_Templates {
  Template *template;
  struct _List_of_Templates *next;
} List_of_Templates;

/* document processing stuff */

typedef struct _List_of_Docs {
  DB_INT doc_start;
  DB_INT body_start;
  DB_INT subject[2];
  DB_INT date[2];
  DB_INT source[2];
  DB_INT location[2];
  struct _List_of_Docs *next;
} List_of_Docs;
  
typedef struct {
  char *filename;
  DB_INT num_docs;
  List_of_Docs *docs;
  DB_INT biases[NUM_FIELD_TYPES];
} Processed_File;

typedef struct _List_of_Files{
  Processed_File *file;
  struct _List_of_Files *next;
} List_of_Files;

typedef struct {
  FILE *file;
  char *filename;
  char *owner;
  char *date; 
  struct parsedate *pd;
  size_t size;
} FileInfo;

/* from config.c */
extern int load_config(char *);
extern char *lookup_uservar(char *);
extern List_of_Templates *All_Templates;
extern UserVars Config;

/* from process.c */
extern List_of_Files *find_files(char *, char **);
extern Template *recognize(FILE *);
extern ssize_t match_pattern(FILE *, Pattern *, ssize_t, List_of_Docs *, int);

#endif /* #ifndef _TEMPLATE_H_ */  
