/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include "xgobiexterns.h"

static int button1down, button2down;
 /* pointer position in scaling */
static icoords s_w, s_ow = {40,40};
static int nsteps;

void
init_scale_vars(xg)
  xgobidata *xg;
{
  static Boolean firsttime = True;

  if (firsttime)
  {
    xg->is_scaling = False;
    xg->run_shift_proc = False;
    xg->run_scale_proc = False;
    /*
     * scale_cntr = True: use data center for scaling
     * scale_cntr = False: use plot center
    */
    xg->scale_cntr = True;
    xg->shift_scrn0 = 1;
    xg->plot_square = appdata.plotSquare;
    xg->shift_wrld.x = xg->shift_wrld.y = 0;
    xg->is.x = xg->is.y = 0;
    xg->scale0.x = xg->scale0.y = DEF_SCALE;
    xg->scale.x = xg->scale.y = DEF_SCALE;
    xg->tour_scale0.x = xg->tour_scale0.y = DEF_SCALE;
    xg->tour_scale.x = xg->tour_scale.y = DEF_SCALE;
  }
  xg->shift_scrn.x = xg->shift_scrn.y = 0;
}

void
set_shift_wrld0(xg)
    xgobidata *xg;
{
  if (!xg->is_touring)
  {
    xg->shift_wrld0.x = INT(FLOAT(xg->shift_scrn0 * 2 * PRECISION1) /
      (FLOAT(xg->minxy) * xg->scale.x));
    xg->shift_wrld0.y = INT(FLOAT(xg->shift_scrn0 * 2 * PRECISION1) /
      (FLOAT(xg->minxy) * xg->scale.y));
  }
  else
  {
    xg->shift_wrld0.x = INT(FLOAT(xg->shift_scrn0 * 2 * PRECISION1) /
      (FLOAT(xg->minxy) * xg->tour_scale.x));
    xg->shift_wrld0.y = INT(FLOAT(xg->shift_scrn0 * 2 * PRECISION1) /
      (FLOAT(xg->minxy) * xg->tour_scale.y));
  }
}

void
find_plot_center(xg)
  xgobidata *xg;
{
  int ishift;
  long lshift;

  lshift = xg->shift_wrld.x * (1 - xg->scale_cntr);
  ishift = (int) ((lshift * xg->is.x) >> EXP1);
  xg->cntr.x = xg->mid.x + ishift +
               (xg->shift_scrn.x * xg->scale_cntr);

  lshift = xg->shift_wrld.y * (1 - xg->scale_cntr);
  ishift = (int) ((lshift * xg->is.y) >> EXP1);
  xg->cntr.y = xg->mid.y - ishift +
               (xg->shift_scrn.y * xg->scale_cntr);
}

void
reinit_nsteps()
{
  nsteps = 1;
}

void
scale_proc(xg)
    xgobidata *xg;
{
  float scalefac, mult;
  /* These two should probably be defines */
  float low = 400;
  float high = 2000;

/*
 * I can get time information (using time or clock) down
 * to the second, but I can't get fractions of a second.
 
#include <time.h>
  time_t t;
  char *c;
  t = time(NULL);
  printf("time: %ld\n", t);
*/
/*
  printf("clock: %d\n", clock() / CLK_TCK);
*/

  /*
   * This makes the scaling amount get bigger the longer the
   * button is pressed, by an amount that depends on nrows_in_plot.
  */
  nsteps++ ;

  if (xg->nrows_in_plot <= low)
    scalefac = SCALE0 * .25 ;  /* small; ignore nsteps */
  else if (xg->nrows_in_plot > high)
    scalefac = SCALE0 * MIN(20., (float) nsteps) ;
  else
  {
    mult = ((float) xg->nrows_in_plot - low) / (high - low) ;
    scalefac = SCALE0 * MIN(20., (float) nsteps * mult);
  }

  if (!xg->is_touring)
  {
    switch(xg->scaling_btn)
    {
      case 0:
        xg->scale.y += scalefac;
        break;
      case 1:
        xg->scale.x += scalefac;
        xg->scale.y += scalefac;
        break;
      case 2:
        xg->scale.x += scalefac;
        break;
      case 5:
        xg->scale.x -= MIN(scalefac, xg->scale.x - SCALE_MIN);
        break;
       case 4:
        xg->scale.x -= MIN(scalefac, xg->scale.x - SCALE_MIN);
        xg->scale.y -= MIN(scalefac, xg->scale.y - SCALE_MIN);
        break;
      case 3:
        xg->scale.y -= MIN(scalefac, xg->scale.y - SCALE_MIN);
        break;
    }
  }
  else
  {
    switch(xg->scaling_btn)
    {
      case 0:
        xg->tour_scale.y += scalefac;
        break;
      case 1:
        xg->tour_scale.x += scalefac;
        xg->tour_scale.y += scalefac;
        break;
      case 2:
        xg->tour_scale.x += scalefac;
        break;
      case 5:
        xg->tour_scale.x -= MIN(scalefac, xg->tour_scale.x - SCALE_MIN);
        break;
      case 4:
        xg->tour_scale.x -= MIN(scalefac, xg->tour_scale.x - SCALE_MIN);
        xg->tour_scale.y -= MIN(scalefac, xg->tour_scale.y - SCALE_MIN);
        break;
      case 3:
        xg->tour_scale.y -= MIN(scalefac, xg->tour_scale.y - SCALE_MIN);
        break;
    }
  }

  set_shift_wrld0(xg);

  find_plot_center(xg);
  plane_to_screen(xg);

  if (xg->is_xyplotting)
  {
    /* use minindex and ticks0 to set the axes */
    convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    /* now rescale the ticks for the current x and y */
    convert_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    extend_axes(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    build_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
  }

  else if (xg->is_dotplotting)
  {
    /* use minindex and ticks0 to set the axes */
    convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    /* now rescale the ticks for the current y */
    convert_ticks((int)NULL, xg->dotplot_vars.y, &xg->ticks, xg);
    extend_axes((int)NULL, xg->dotplot_vars.y, &xg->ticks, xg);
    build_ticks((int)NULL, xg->dotplot_vars.y, &xg->ticks, xg);
  }

  plot_once(xg);
}

void
shift_proc(xg)
  xgobidata *xg;
{
/*
 * Not using the increasing method that used for scaling, rather
 * the shift step remains the same.
*/
  int shiftfac = 1;
  int high = 2000;
  if (xg->nrows_in_plot > high) shiftfac = 2;

  switch(xg->scaling_btn)
  {
    case 3:  /* shift left */
      if (xg->scale_cntr)
        xg->shift_scrn.x -= (shiftfac * xg->shift_scrn0);
      else
        xg->shift_wrld.x -= (shiftfac * xg->shift_wrld0.x);
      break;

    case 1:   /* shift right */
      if (xg->scale_cntr)
        xg->shift_scrn.x += (shiftfac * xg->shift_scrn0);
      else
        xg->shift_wrld.x += (shiftfac * xg->shift_wrld0.x);
      break;

    case 2:  /* shift down */
      if (xg->scale_cntr)
        xg->shift_scrn.y += (shiftfac * xg->shift_scrn0);
      else
        xg->shift_wrld.y += (shiftfac * xg->shift_wrld0.y);
      break;

    case 0:  /* shift up */
      if (xg->scale_cntr)
        xg->shift_scrn.y -= (shiftfac * xg->shift_scrn0);
      else
        xg->shift_wrld.y -= (shiftfac * xg->shift_wrld0.y);
      break;
  }

  find_plot_center(xg);
  plane_to_screen(xg);

  if (xg->is_xyplotting)
  {
    /* use minindex and ticks0 to set the axes */
    convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    /* now rescale the ticks for the current x and y */
    convert_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    extend_axes(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
    build_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
  }

  else if (xg->is_dotplotting)
  {
    /* use minindex and ticks0 to set the axes */
    convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
    convert_axes(&xg->ticks0, xg);
    /* now rescale the ticks for the current x and y */
    convert_ticks((int)NULL, xg->dotplot_vars.y, &xg->ticks, xg);
    extend_axes((int)NULL, xg->dotplot_vars.y, &xg->ticks, xg);
    build_ticks((int)NULL, xg->dotplot_vars.y, &xg->ticks, xg);
  }

  plot_once(xg);
}

/*
 * Event handler for button presses when in scaling mode.  Modeled
 * after brush_button in brush.c.
*/
/* ARGSUSED */
XtEventHandler
scale_button_event(w, xg, evnt)
   Widget w;
   xgobidata *xg;
   XEvent *evnt;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;
  int root_x, root_y, win_x, win_y;
  unsigned int kb;
  Window root, child;

  if (xg->is_scaling)
  {
    switch (xbutton->type)
    {
    case ButtonPress:
      switch (xbutton->button)
      {
      case 1:
        button1down = 1;
        /* Set initial pointer position. */
        if (XQueryPointer(display, xg->plot_window, &root, &child,
          &root_x, &root_y, &win_x, &win_y, &kb))
        {
          s_ow.x = s_w.x = win_x;
          s_ow.y = s_w.y = win_y;
        }
        break;
      case 2:
        button2down = 1;
        /* Set initial pointer position. */
        if (XQueryPointer(display, xg->plot_window, &root, &child,
          &root_x, &root_y, &win_x, &win_y, &kb))
        {
          s_ow.x = s_w.x = win_x;
          s_ow.y = s_w.y = win_y;
        }
        break;
      }
    break;
    case ButtonRelease:
      switch (xbutton->button)
      {
      case 1:
        button1down = 0;
        break;
      case 2:
        button2down = 0;
        break;
      }
    break;
    }
  }
}

/*
 * Checks if the pointer has moved since the last time "pointer_moved"
 * was called.  It does this by checking the current pointer
 * coordinates against win.x, win.y which are initialized in
 * main().  Returns (win.x,win.y) as globals representing the current
 * position of the pointer.
*/

int
pointer_moved(icoords *pos, icoords *prev_pos, xgobidata *xg)
{
  int root_x, root_y, win_x, win_y;
  int moved = 0;
  unsigned int kb;
  Window root, child;

  if ( XQueryPointer(display, xg->plot_window, &root, &child,
    &root_x, &root_y, &win_x, &win_y, &kb) &&
    (win_x != pos->x  || win_y != pos->y) )
  {
    prev_pos->x = pos->x;
    prev_pos->y = pos->y;
    pos->x = win_x;
    pos->y = win_y;
    moved = 1;
  }
  return(moved);
}

/*
 * Button 1 is pressed.  We are in scaling mode.  The mouse has moved
 * to s_w.x, s_w.y from s_ow.x, s_ow.y.  Change shift_scrn.x and
 * shift_scrn.y by the appropriate amounts.
*/
void
move_by_mouse(xgobidata *xg)
{
  if (xg->scale_cntr)
  {
    xg->shift_scrn.x += s_w.x - s_ow.x;
    xg->shift_scrn.y += s_w.y - s_ow.y;
  }
  else
  {
    if (!xg->is_touring)
    {
      xg->shift_wrld.x +=
        INT(FLOAT((s_w.x-s_ow.x) * 2 * PRECISION1)/
           (FLOAT(xg->minxy) * xg->scale.x )) ;
      xg->shift_wrld.y +=
        INT(FLOAT((s_w.y-s_ow.y) * 2 * PRECISION1)/
           (FLOAT(xg->minxy) * xg->scale.y ));
    }
    else
    {
      xg->shift_wrld.x +=
        INT(FLOAT((s_w.x-s_ow.x) * 2 * PRECISION1)/
           (FLOAT(xg->minxy) * xg->tour_scale.x )) ;
      xg->shift_wrld.y +=
        INT(FLOAT((s_w.y-s_ow.y) * 2 * PRECISION1)/
           (FLOAT(xg->minxy) * xg->tour_scale.y ));
    }
  }
}

/*
 * Button 2 is pressed.  We are in scaling mode.  The mouse has moved
 * to s_w.x, s_w.y from s_ow.x, s_ow.y and the center of the
 * figure is at mid.x, mid.y.  Change scale.x and scale.y by the
 * appropriate amounts.
*/
void
scale_by_mouse(xgobidata *xg)
{
  int center_x = xg->mid.x + xg->shift_scrn.x,
      center_y = xg->mid.y + xg->shift_scrn.y;

  if (!xg->is_touring)
  {
  /* Scale the scaler if far enough from center. */
    if (
      (s_ow.x <
        INT(FLOAT(xg->shift_scrn.x) + FLOAT(xg->mid.x) * (1.0 - SCALE_MIN))) ||
      (s_ow.x >
        INT(FLOAT(xg->shift_scrn.x) + FLOAT(xg->mid.x) * (1.0 + SCALE_MIN)))
     )
      xg->scale.x *= FLOAT(s_w.x - center_x) / FLOAT(s_ow.x - center_x);

    if (
      (s_ow.y <
         INT(FLOAT(xg->shift_scrn.y) + FLOAT(xg->mid.y) * (1.0 - SCALE_MIN))) ||
      (s_ow.y >
         INT(FLOAT(xg->shift_scrn.y) + FLOAT(xg->mid.y) * (1.0 + SCALE_MIN)))
    )
      xg->scale.y *= FLOAT(s_w.y - center_y) / FLOAT(s_ow.y - center_y);

  /* Restore if too small. */
    xg->scale.x = MAX(SCALE_MIN, xg->scale.x);
    xg->scale.y = MAX(SCALE_MIN, xg->scale.y);
  }
  else
  {
  /* Scale the scaler if far enough from center. */
    if (
      (s_ow.x <
        INT(FLOAT(xg->shift_scrn.x) + FLOAT(xg->mid.x) * (1.0 - SCALE_MIN))) ||
      (s_ow.x >
        INT(FLOAT(xg->shift_scrn.x) + FLOAT(xg->mid.x) * (1.0 + SCALE_MIN)))
     )
      xg->tour_scale.x *= FLOAT(s_w.x - center_x) / FLOAT(s_ow.x - center_x);

    if (
      (s_ow.y <
         INT(FLOAT(xg->shift_scrn.y) + FLOAT(xg->mid.y) * (1.0 - SCALE_MIN))) ||
      (s_ow.y >
         INT(FLOAT(xg->shift_scrn.y) + FLOAT(xg->mid.y) * (1.0 + SCALE_MIN)))
    )
      xg->tour_scale.y *= FLOAT(s_w.y - center_y) / FLOAT(s_ow.y - center_y);

  /* Restore if too small. */
    xg->tour_scale.x = MAX(SCALE_MIN, xg->tour_scale.x);
    xg->tour_scale.y = MAX(SCALE_MIN, xg->tour_scale.y);
  }

  set_shift_wrld0(xg);
  find_plot_center(xg);
}

/*
 * Procedure executed for interactive scaling and translating.  ML.
 * Modeled after brush.c.  If a button is pressed and the pointer has
 * moved, scale or translate as appropriate and replot.
*/
void
scaling_proc(xg)
  xgobidata *xg;
{
  if (button1down || button2down)
    {
    if (pointer_moved(&s_w, &s_ow, xg))
    {
      if (button1down)
        move_by_mouse(xg);
      if (button2down)
        scale_by_mouse(xg);
      find_plot_center(xg);
      plane_to_screen(xg);

      if (xg->is_xyplotting)
      {
        /* use minindex and ticks0 to set the axes */
        convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
        convert_axes(&xg->ticks0, xg);
        /* now rescale the ticks for the current x and y */
        convert_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
        extend_axes(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
        build_ticks(xg->xy_vars.x, xg->xy_vars.y, &xg->ticks, xg);
      }

      else if (xg->is_dotplotting)
      {
        /* use minindex and ticks0 to set the axes */
        convert_ticks(xg->minindex, xg->minindex, &xg->ticks0, xg);
        convert_axes(&xg->ticks0, xg);
        /* now rescale the ticks for the current x and y */
        convert_ticks((int)NULL, xg->dotplot_vars.y,
          &xg->ticks, xg);
        extend_axes((int)NULL, xg->dotplot_vars.y,
          &xg->ticks, xg);
        build_ticks((int)NULL, xg->dotplot_vars.y,
          &xg->ticks, xg);
      }

      plot_once(xg);
    }
  }
}
