/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include "xgobiexterns.h"

/* Send vector for linked line brushing */
static unsigned long *lbsenddata;

int
glyph_color_pointtype(xg, rownum)
  xgobidata *xg;
  int rownum;
{
  int i;
  int pointtype = -1;
/*
 * Fold the color and glyph information into a single
 * identifier.  In this way, 4 times as much brushing information
 * can be sent.
*/

  if (mono) {
    pointtype = 1000 * (xg->glyph_now[rownum].size - 1) +
                 100 * (xg->glyph_now[rownum].type - 1) +
             ncolors * xg->erased[rownum];
  }
  else {
    for (i=0; i<ncolors; i++) {
      if (xg->color_now[rownum] == color_nums[i]) {
        pointtype = 1000 * (xg->glyph_now[rownum].size - 1) +
                     100 * (xg->glyph_now[rownum].type - 1) +
                 ncolors * xg->erased[rownum] +
                           i ;
      }
    }
  }

  return(pointtype);
}

static void
senddata_to_linecolors(xgobidata *xg, long *pointtypes, int *rownums, int npts)
{
  int n, rownum, pointtype;
  int remainder;

  if (!mono) {
    for (n=0; n<npts; n++) {
      rownum = rownums[n];
      pointtype = (int) pointtypes[n];

      remainder = pointtype / 1000 + 1 ;
      remainder = pointtype % 1000 ;
      remainder = remainder % 100 ;
      remainder = remainder % ncolors ;
      xg->line_color_now[rownum] = color_nums[remainder] ;
    }
  }
}

static void
senddata_to_glyphs_and_colors(xgobidata *xg, long *pointtypes, int *rownums,
int npts, int sending_colors, int sending_glyphs, int sending_erase)
{
  int n, rownum, pointtype;
  int remainder;

  for (n=0; n<npts; n++) {
    rownum = rownums[n];
    pointtype = (int) pointtypes[n];

    /*
      fprintf(stderr, "row %d %ld: ", rownum, pointtype);
    */

    if (sending_glyphs && xg->link_glyph_brushing)
    {
      xg->glyph_now[rownum].size = pointtype / 1000 + 1 ;
      if (xg->glyph_now[rownum].size < 1 ||
          xg->glyph_now[rownum].size > NGLYPHSIZES)
      {
        (void) fprintf(stderr, "impossible point size %d in row %d\n",
          xg->glyph_now[rownum].size, rownum);
      }
    }

    remainder = pointtype % 1000 ;

    /*
      fprintf(stderr, "size %d r %d, ", xg->glyph_now[rownum].size, remainder);
    */

    if (sending_glyphs && xg->link_glyph_brushing)
    {
      xg->glyph_now[rownum].type = remainder / 100 + 1 ;
      if (xg->glyph_now[rownum].type < 1 ||
          xg->glyph_now[rownum].type > NGLYPHTYPES)
      {
        (void) fprintf(stderr, "impossible point type %d in row %d\n",
          xg->glyph_now[rownum].type, rownum);
      }
    }
    /*
      fprintf(stderr, "type %d r %d, ", xg->glyph_now[rownum].type, remainder);
    */

    remainder = remainder % 100 ;
    if (sending_erase && xg->link_erase_brushing)
    {
      xg->erased[rownum] = remainder / ncolors ;
      if (xg->erased[rownum] != 0 && xg->erased[rownum] != 1)
      {
        (void) fprintf(stderr, "impossible value for erase %d in row %d\n",
          xg->erased[rownum], rownum);
        fprintf(stderr, "pointtype %d, ", pointtype);
        fprintf(stderr, "size %d, ", xg->glyph_now[rownum].size );
        fprintf(stderr, "type %d, ", xg->glyph_now[rownum].type );
        fprintf(stderr, "\n");
      }
    }
/*
  fprintf(stderr, "erased %d, ", xg->erased[rownum]);
*/

    if (!mono && sending_colors && xg->link_color_brushing)
    {
      remainder = remainder % ncolors ;
      xg->color_now[rownum] = color_nums[remainder] ;
    }
/*
  fprintf(stderr, "r %d, ", remainder);
  fprintf(stderr, "color %d\n", xg->color_now[rownum]);
*/
  }
}

/* ARGSUSED */
XtSelectionDoneProc
pack_brush_done(w, selection, target)
  Widget w;
  Atom *selection;
  Atom *target;
{
/*
 * This routine does nothing; its only purpose in life is to
 * prevent the Intrinsics from freeing the selection value.
*/
}

/* ARGSUSED  */
XtLoseSelectionProc
pack_brush_lose(w, selection, xgobi)
  Widget w;
  Atom *selection;
  XtPointer xgobi;
{
/*
 * This routine does nothing; its only purpose in life is to
 * prevent the Intrinsics from freeing the selection value.
*/
}

void
announce_brush_data(xg)
  xgobidata *xg;
{
/*
 * This sends an event to tell other XGobi windows to
 * execute XtGetSelection().  It sends no data.
*/
  XChangeProperty( display,
    RootWindowOfScreen(XtScreen(xg->shell)),
    XG_NEWPAINT_ANNC, XG_NEWPAINT_ANNC_TYPE,
    (int) 32, (int) PropModeReplace,
    (unsigned char *) NULL, 0);
}

/* ARGSUSED */
XtConvertSelectionProc
pack_brush_data(w, selection, target,
type_ret, retdata, length_ret, format_ret )
  Widget w;          /* owning widget, xg->workspace */
  Atom *selection;   /* XG_NEWPAINT */
  Atom *target;      /* XG_NEWPAINT_TYPE */
  Atom *type_ret;    /* XG_NEWPAINT_TYPE again */
  XtPointer *retdata;         /* brushing data itself */
  unsigned long *length_ret;  /* length of retdata */
  int *format_ret;            /* type of retdata */
{
/*
 * When another XGobi requests the brushing data from the server,
 * this function is executed by the active XGobi.  It provides
 * the brushing data to the requestor.
 * It is declared by the call to XtOwnSelection().
*/
  extern xgobidata xgobi;

  if (*target == XG_NEWPAINT_TYPE)
  {
    *type_ret = XG_NEWPAINT_TYPE ;
    *retdata = (XtPointer) xgobi.senddata ;
    *length_ret = (unsigned long) (2*xgobi.nrows_in_plot + 9) ;
    *format_ret = (int) 32 ;
  }
}

/* ARGSUSED */
XtSelectionCallbackProc
unpack_brush_data(w, xgobiptr, atom, atom_type, retdata, lendata, fmt)
  Widget w;
  XtPointer xgobiptr;
  Atom *atom;         /* should be XG_NEWPAINT */
  Atom *atom_type;    /* should be XG_NEWPAINT_TYPE */
  XtPointer retdata;
  unsigned long *lendata;
  int *fmt;           /* should be 32 */
{
  xgobidata *xg = (xgobidata *) xgobiptr;
  long i;
  int j, npts, trans, nr;
  int *brushed;
  unsigned long *rdata;
  int link_p2p, link_l2l, link_p2l;
  int sending_colors, sending_glyphs, sending_erase;

  if (*atom == XG_NEWPAINT &&
      *atom_type &&
      /**atom_type != NULL &&*/
      *atom_type != XT_CONVERT_FAIL)
  {
    if (*lendata > 0) {
      rdata = (unsigned long *) retdata;

      nr = (int) *rdata++ ;
      npts = (int) *rdata++ ;
      link_p2p = (int) *rdata++ ;
      link_l2l = (int) *rdata++ ;
      link_p2l = (int) *rdata++ ;
      sending_colors = (int) *rdata++ ;
      sending_glyphs = (int) *rdata++ ;
      sending_erase = (int) *rdata++ ;
      trans = (int) *rdata++ ;

/*
fprintf(stderr, "reading: nr %d xg->nrows %d xg->nrows_in_plot %d\n",
nr, xg->nrows, xg->nrows_in_plot);
*/
      /*
       * We already know that the receiver hasn't disabled linked
       * brushing for points (either xg->link_points_to_points or
       * xg->link_points_to_lines is true), otherwise read_paint
       * wouldn't have been called.
       * Let both the receiving value and the sending value together
       * (link_p2p or link_p2l)
       * determine whether to assign the colors to points or lines.
      */
      if (npts > 0 &&
          ((xg->link_points_to_points && link_p2p && nr == xg->nlinkable) ||
           (xg->link_points_to_lines && link_p2l && nr == xg->nlines)) )
      {
        brushed = (int *) XtMalloc((Cardinal) npts * sizeof(int));

        /*
         * Assign the new values to the current arrays.
        */
        for (i=0; i<npts; i++)
          brushed[i] = (int) *rdata++;  /* rows_in_plot */

        if (link_p2p) {
          senddata_to_glyphs_and_colors(xg,
            (long *) rdata, brushed, npts,
            sending_colors, sending_glyphs, sending_erase);
        }
        else if (link_p2l)
        {
          fprintf(stderr, "doing point->line brushing\n");
          senddata_to_linecolors(xg, (long *) rdata, brushed, npts);
        }

        /*
         * If the painting mode of the sending window is
         * persistent or undo, then make these changes permanent.
         * The changes aren't fully permanent unless they're in
         * senddata[], but I'll do that when a ButtonPress is
         * received, so it should be ok.
        */
        if (!trans) {
          for (i=0; i<npts; i++)
          {
            j = brushed[i];
            if (link_p2p) {
              if (sending_colors && xg->link_color_brushing)
                xg->color_ids[j] = xg->color_now[j];
              if (sending_glyphs && xg->link_color_brushing) {
                xg->glyph_ids[j].type = xg->glyph_now[j].type;
                xg->glyph_ids[j].size = xg->glyph_now[j].size;
              }
            } else {
              xg->line_color_ids[j] = xg->line_color_now[j];
            }
          }
        }
        XtFree((XtPointer) brushed);
        xg->got_new_paint = 1;
        plot_once(xg);

        if (xg->is_cprof_plotting)
          cprof_plot_once(xg);
      }
    }
  }
  XtFree((XtPointer) retdata);

  plot_once(xg);

#ifdef RPC_USED
  xfer_brushinfo(xg);
#endif
}

void
read_paint(xg)
  xgobidata *xg;
{
    XtGetSelectionValue(
      xg->workspace,
      (Atom) XG_NEWPAINT,
      (Atom) XG_NEWPAINT_TYPE,
      (XtSelectionCallbackProc) unpack_brush_data,
      (XtPointer) xg,
      (Time) XtLastTimestampProcessed(display) );
      /*(Time) CurrentTime );*/
}

void
announce_rows_in_plot(xg)
  xgobidata *xg;
{
/*
 * This sends an event to tell other XGobi windows to
 * execute XtGetSelection().  It sends no data.
*/
  XChangeProperty( display,
    RootWindowOfScreen(XtScreen(xg->shell)),
    XG_ROWSINPLOT_ANNC, XG_ROWSINPLOT_ANNC_TYPE,
    (int) 32, (int) PropModeReplace,
    (unsigned char *) NULL, 0);
}

/* ARGSUSED */
XtConvertSelectionProc
pack_rowsinplot_data(w, selection, target,
type_ret, retdata, length_ret, format_ret )
  Widget w;          /* owning widget, xg->workspace */
  Atom *selection;   /* XG_ROWSINPLOT */
  Atom *target;      /* XG_ROWSINPLOT_TYPE */
  Atom *type_ret;    /* XG_ROWSINPLOT_TYPE again */
  XtPointer *retdata;         /* brushing data itself */
  unsigned long *length_ret;  /* length of retdata */
  int *format_ret;            /* type of retdata */
{
/*
 * When another XGobi requests the brushing data from the server,
 * this function is executed by the active XGobi.  It provides
 * the rows_in_plot[] data to the requestor.
 * It is declared by the call to XtOwnSelection().
*/
  extern xgobidata xgobi;

  if (*target == XG_ROWSINPLOT_TYPE)
  {
    *type_ret = XG_ROWSINPLOT_TYPE ;
    *retdata = (XtPointer) xgobi.senddata ;
    /*
     * Send only the first part of senddata
    */
    *length_ret = (unsigned long) (xgobi.nrows_in_plot + 9) ;
    *format_ret = (int) 32 ;
  }
}

/* ARGSUSED */
XtSelectionCallbackProc
unpack_rowsinplot_data(w, xgobiptr, atom, atom_type, retdata, lendata, fmt)
  Widget w;
  XtPointer xgobiptr;
  Atom *atom;         /* should be XG_ROWSINPLOT */
  Atom *atom_type;    /* should be XG_ROWSINPLOT_TYPE */
  XtPointer retdata;
  unsigned long *lendata;
  int *fmt;           /* should be 32 */
{
  xgobidata *xg = (xgobidata *) xgobiptr;
  long i;
  int npts, nr;
  unsigned long *rdata;

  if (*atom == XG_ROWSINPLOT &&
      *atom_type &&
      /**atom_type != NULL &&*/
      *atom_type == XG_ROWSINPLOT_TYPE )
  {
    if (*lendata > 0)
    {
      rdata = (unsigned long *) retdata;

      nr = (int) *rdata++ ;    /* nlinkable */
      npts = (int) *rdata++ ;  /* nrows_in_plot */
      *rdata++ ;    /* skip over link_p2p */
      *rdata++ ;    /* skip over link_l2l */
      *rdata++ ;    /* skip over link_p2l */
      *rdata++ ;    /* skip over sending_colors */
      *rdata++ ;    /* skip over sending_glyphs */
      *rdata++ ;    /* skip over sending_erase */
      *rdata++ ;    /* skip over is_transient */

      if (nr == xg->nrows && npts > 0)
      {
        /*
         * Assign the new values to the current arrays.
        */
        xg->nrows_in_plot = npts;
        for (i=0; i<xg->nrows_in_plot; i++)
          xg->rows_in_plot[i] = (int) *rdata++;

        /*
         * Let's also erase everything that's not in the plot ...
        */
        for (i=0; i<xg->nrows; i++)
          xg->erased[i] = 1;
        for (i=0; i<xg->nrows_in_plot; i++)
          xg->erased[ xg->rows_in_plot[i] ] = 0;
        /* */

/*
 * This could become a parameter that is passed from the linked xgobi
*/
        /*reset_rows_in_plot(xg, True);*/
        reset_rows_in_plot(xg, False);
        plot_once(xg);

        /* I'm not sure if this belongs here, but I bet it does */
        passive_update_cprof_plot(xg);


/*
fprintf(stderr, "nr %d xg->nrows %d xg->nrows_in_plot %d\n",
nr, xg->nrows, xg->nrows_in_plot);
*/
      }
    }
  }
  XtFree((XtPointer) retdata);
}

void
read_rows_in_plot(xg)
  xgobidata *xg;
{
    XtGetSelectionValue(
      xg->workspace,
      (Atom) XG_ROWSINPLOT,
      (Atom) XG_ROWSINPLOT_TYPE,
      (XtSelectionCallbackProc) unpack_rowsinplot_data,
      (XtPointer) xg,
      (Time) XtLastTimestampProcessed(display) );
      /*(Time) CurrentTime );*/
}

/************* Section for linked line brushing *******************/

/* ARGSUSED */
XtSelectionDoneProc
pack_line_brush_done(w, selection, target)
  Widget w;
  Atom *selection;
  Atom *target;
{
/*
 * This routine does nothing; its only purpose in life is to
 * prevent the Intrinsics from freeing the selection value.
*/
}

/* ARGSUSED  */
XtLoseSelectionProc
pack_line_brush_lose(w, selection, xgobi)
  Widget w;
  Atom *selection;
  XtPointer xgobi;
{
/*
 * This routine does nothing; its only purpose in life is to
 * prevent the Intrinsics from freeing the selection value.
*/
}

void
announce_line_brush_data(xg)
  xgobidata *xg;
{
/*
 * This sends an event to tell other XGobi windows to
 * execute XtGetSelection().  It sends no data.
*/
  XChangeProperty( display,
    RootWindowOfScreen(XtScreen(xg->shell)),
    XG_NEWLINEPAINT_ANNC, XG_NEWLINEPAINT_ANNC_TYPE,
    (int) 32, (int) PropModeReplace,
    (unsigned char *) NULL, 0);
}

/* ARGSUSED */
XtConvertSelectionProc
pack_line_brush_data(w, selection, target,
type_ret, retdata, length_ret, format_ret )
  Widget w;          /* owning widget, xg->workspace */
  Atom *selection;   /* XG_NEWLINEPAINT */
  Atom *target;      /* XG_NEWLINEPAINT_TYPE */
  Atom *type_ret;    /* XG_NEWLINEPAINT_TYPE again */
  XtPointer *retdata;         /* brushing data itself */
  unsigned long *length_ret;  /* length of retdata */
  int *format_ret;            /* type of retdata */
{
/*
 * When another XGobi requests the brushing data from the server,
 * this function is executed by the active XGobi.  It provides
 * the brushing data to the requestor.
 * It is declared by the call to XtOwnSelection().
*/
  extern xgobidata xgobi;
  static Boolean initd = False;
  static int nlinkable = 0;
  static int nlines = 0;
  int k;

  if (!initd || nlinkable != xgobi.nlinkable || nlines != xgobi.nlines)
  {
    nlinkable = xgobi.nlinkable;
    nlines = xgobi.nlines;
    lbsenddata = (unsigned long *) XtRealloc((char *) lbsenddata, 
      (Cardinal) (5 + nlines) * sizeof(unsigned long));
    initd = True;
  }

  if (*target == XG_NEWLINEPAINT_TYPE)
  {
    lbsenddata[0] = (unsigned long) xgobi.nlinkable;
    lbsenddata[1] = (unsigned long) xgobi.nlines;
    lbsenddata[2] = (unsigned long) xgobi.link_lines_to_lines;
    lbsenddata[3] = (unsigned long) xgobi.link_points_to_lines;
    if (xgobi.brush_mode == transient)
      lbsenddata[4] = (unsigned long) True;
    else
      lbsenddata[4] = (unsigned long) False;

    /*
     * and now pack up the line colors themselves.
    */
    for (k=0; k<xgobi.nlines; k++)
      lbsenddata[5+k] = xgobi.line_color_now[k];

    *type_ret = XG_NEWLINEPAINT_TYPE ;
    *retdata = (XtPointer) lbsenddata ;
    *length_ret = (unsigned long) (xgobi.nlines + 5) ;
    *format_ret = (int) 32 ;
  }
}

/* ARGSUSED */
XtSelectionCallbackProc
unpack_line_brush_data(w, xgobiptr, atom, atom_type, retdata, lendata, fmt)
  Widget w;
  XtPointer xgobiptr;
  Atom *atom;         /* should be XG_NEWLINEPAINT */
  Atom *atom_type;    /* should be XG_NEWLINEPAINT_TYPE */
  XtPointer retdata;
  unsigned long *lendata;
  int *fmt;           /* should be 32 */
{
  xgobidata *xg = (xgobidata *) xgobiptr;
  long i;
  int trans;
  int link_l2l, link_p2l;
  int nlines, nlinkable;
  unsigned long *rdata;

  if (*atom == XG_NEWLINEPAINT &&
      *atom_type &&
      *atom_type != XT_CONVERT_FAIL)
  {
    if (*lendata > 0)
    {
      rdata = (unsigned long *) retdata;

      nlinkable = (int) *rdata++ ;
      nlines = (int) *rdata++ ;
      link_l2l = (int) *rdata++ ;
      link_p2l = (int) *rdata++ ;
      trans = (int) *rdata++ ;

      /*
       * We already know that the receiver hasn't disabled linked
       * brushing for lines (either xg->link_points_to_points or
       * xg->link_lines_to_lines is true), otherwise read_line_paint
       * wouldn't have been called.
       * Let both the receiving value and the sending value together
       * (link_l2l or link_p2l)
       * determine whether to assign the colors to points or lines.
      */

      if (xg->link_lines_to_lines && link_l2l &&
          nlines > 0 && nlines == xg->nlines)
      {
        /*
         * If the painting mode of the sending window is
         * persistent or undo, then make these changes permanent.
        */

        if (trans)
          for (i=0; i<nlines; i++)
            xg->line_color_now[i] = (unsigned long) *rdata++ ;
        else
          for (i=0; i<nlines; i++)
            xg->line_color_ids[i] = xg->line_color_now[i] =
              (unsigned long) *rdata++ ;
      } 
      else if (xg->link_points_to_lines && link_p2l &&
               nlines > 0 && nlines == xg->nrows)
      {
        if (trans)
          for (i=0; i<nlines; i++)
            xg->color_now[i] = (unsigned long) *rdata++ ;
        else
          for (i=0; i<nlines; i++)
            xg->color_ids[i] = xg->color_now[i] =
              (unsigned long) *rdata++ ;
      }

      xg->got_new_paint = 1;
      plot_once(xg);
    }
  }
  if (retdata != NULL)
    XtFree((XtPointer) retdata);
}

void
read_line_paint(xg)
  xgobidata *xg;
{
    XtGetSelectionValue(
      xg->workspace,
      (Atom) XG_NEWLINEPAINT,
      (Atom) XG_NEWLINEPAINT_TYPE,
      (XtSelectionCallbackProc) unpack_line_brush_data,
      (XtPointer) xg,
      (Time) XtLastTimestampProcessed(display) );
      /*(Time) CurrentTime );*/
}
