.TH fstabst 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
fstabst - Youla's parametrization
.SH CALLING SEQUENCE
.nf
[J]=fstabst(P,r)
.fi
.SH PARAMETERS
.TP 10
P
: \fVsyslin\fR list (linear system)
.TP
r
: 1x2 row vector, dimension of \fVP22\fR
.TP
J
: \fVsyslin\fR list (linear system in state-space representation)
.SH DESCRIPTION
Parameterization of all stabilizing feedbacks.
.LP
\fVP\fR is partitioned as follows:
.nf 
P=[ P11 P12;
    P21 P22]  
.fi
(in state-space or transfer form: automatic conversion in state-space is
done for the computations)
.LP
\fVr\fR = size of  \fVP22\fR subsystem, (2,2) block of \fVP\fR
.nf  
          J =[ J11 J12;
               J21 J22]
.fi
\fVK\fR is a stabilizing controller for \fVP\fR (i.e. \fVP22\fR) iff 
\fVK=lft(J,r,Q)\fR with \fVQ\fR stable.
.LP
The central part of \fVJ\fR , \fVJ11\fR is the lqg regulator for \fVP\fR
.LP
This \fVJ\fR is such that defining \fVT\fR as the 2-port \fVlft\fR of \fVP\fR
and \fVJ\fR : \fV[T,rt]=lft(P,r,J,r)\fR one has that \fVT12\fR is inner
and \fVT21\fR is co-inner.
.SH EXAMPLE
.nf
ny=2;nu=3;nx=4;
P22=ssrand(ny,nu,nx);
bigQ=rand(nx+nu,nx+nu);bigQ=bigQ*bigQ';
bigR=rand(nx+ny,nx+ny);bigR=bigR*bigR';
[P,r]=lqg2stan(P22,bigQ,bigR);
J=fstabst(P,r);
Q=ssrand(nu,ny,1);Q('A')=-1;  //Stable Q
K=lft(J,r,Q);
A=h_cl(P,r,K); spec(A)
.fi
.SH SEE ALSO
obscont, lft, lqg, lqg2stan

