.TH errcatch 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
errcatch - error trapping
.SH CALLING SEQUENCE
.nf
errcatch(n [,'action'] [,'option']) 
.fi
.SH PARAMETERS
.TP 20
n
: integer 
.TP 20
action, option 
: strings
.SH DESCRIPTION
\fVerrcatch\fR gives an "action" (error-handler)  to be 
performed when an error of type \fVn\fR occurs.
\fVn\fR has the followin meaning:
.PP
if \fVn>0\fR, \fVn\fR is the error number to trap
.PP
if \fVn<0\fR  all errors are to be trapped
.LP
\fVaction\fR is one of the following character strings:
.RS
.RS
.TP 12
"pause"
: a pause is executed when trapping the error. This option is useful
for debugging purposes.
.TP
"continue"
: next instruction in the function or exec files is executed, current
instruction is ignored. This option is useful for error recovery.
.TP
"kill"
: default mode, all intermediate functions are killed, scilab goes
back to the level 0 prompt.
.TP
"stop"
: interrupts the current Scilab session (useful when 
Scilab is called from an external program).
.RE
.RE
.LP
\fVoption\fR is the character string \fV'nomessage'\fR for killing
error message.
.SH SEE ALSO
errclear, iserror
