\section{Examples of Haskore in Action}
\label{examples}

{\small\begin{verbatim} 

> module HaskoreExamples (module Haskore,
>                         module ChildSong6, module SelfSim)
>        where
>
> import Haskore

> import ChildSong6
> import SelfSim

Simple examples of Haskore in action.  Note that this module also
imports modules ChildSong6 and SelfSim.

-----------------------------------------------------------------------------

From the tutorial, try things such as pr12, cMajArp, cMajChd, etc. and
try applying inversions, retrogrades, etc. on the same examples.  Also
try "childSong6" imported from module ChildSong.  For example:

> t0 = test (Instr "piano" childSong6)

-----------------------------------------------------------------------------

C Major scale for use in examples below:

> cMajScale = Tempo 2 1
>             (line [c 4 en [], d 4 en [], e 4 en [], f 4 en [], 
>                    g 4 en [], a 4 en [], b 4 en [], c 5 en []])
>
> cms = cMajScale

Test of various articulations and dynamics:

> t1 = test (Instr "piano"
>        (Phrase [Art (Staccato 0.1)] cms :+:
>         cms                             :+:
>         Phrase [Art (Legato   1.1)] cms    ))
>
> t2 = test (Instr "vibes" 
>        (Phrase [Dyn (Diminuendo 0.75)] cms :+:
>         Phrase [Dyn (Crescendo 4.0), Dyn (Loudness 25)] cms))
>
> t3 = test (Instr "flute" 
>        (Phrase [Dyn (Accelerando 0.3)] cms :+:
>         Phrase [Dyn (Ritardando  0.6)] cms    ))

-----------------------------------------------------------------------------

A function to recursively apply transformations f (to elements in a
sequence) and g (to accumulated phrases):

> rep :: (Music -> Music) -> (Music -> Music) -> Int -> Music -> Music
> rep f g 0 m = Rest 0
> rep f g n m = m :=: g (rep f g (n-1) (f m))

An example using "rep" three times, recursively, to create a "cascade"
of sounds.

> run       = rep (Trans 5) (delay tn) 8 (c 4 tn [])
> cascade   = rep (Trans 4) (delay en) 8 run
> cascades  = rep  id       (delay sn) 2 cascade
> t4' x     = test (Instr "piano" x)
> t4        = test (Instr "piano" 
>               (cascades :+: revM cascades))

What happens if we simply reverse the f and g arguments?

> run'      = rep (delay tn) (Trans 5) 4 (c 4 tn [])
> cascade'  = rep (delay en) (Trans 4) 6 run'
> cascades' = rep (delay sn)  id       2 cascade'
> t5        = test (Instr "piano" cascades')

-----------------------------------------------------------------------------

Example from the SelfSim module.

> t10s   = test (rep (delay durss) (Trans 4) 2 ss)

-----------------------------------------------------------------------------

Example from the ChildSong6 module.

> cs6 = test childSong6

-----------------------------------------------------------------------------

Midi percussion test.  Plays all "notes" in a range.  (Requires adding
an instrument for percussion to the UserPatchMap.)

> drums a b = Instr "drums" 
>                   (line (map (\p-> Note (pitch p) sn []) [a..b]))
> t11 a b = test (drums a b)

-----------------------------------------------------------------------------

\end{verbatim} }
