module Mime where

{-
MIME types (last modified: Friday, March 07, 1997)

Erik Meijer (erik@cs.ruu.nl)
-}

{-
A type a is in class Mime whenever it can be parsed and unparsed
and moreover it has a method mimeType for printing its MIME type.

This is a VERY naive view of MIME types. Read the documentation for
more excitement: http://andrew2.andrew.cmu.edu/rfc/rfc1521.html.

However, all PERL libraries I have seen so far are even more
primitive. Tehy just dump raw data on stdout.
-}

class (Show a, Read a) => Mime a where
  mimeType :: a -> String

{-
Defining a new MIMI type instance usual takes the following steps:
(a) Define a newtype synonym or algebraic data type that describes
the decoded form of the type.
(b) Make that type instance of Show by providing an unparser, and
an instance of Read by providing a parser. For all but the most
simple types you cannot use deriving.
(c) Make the type an instance of Mime by telling what the MIME type
is.

Here is the most simple one: text/plain.

It is a shame that we cannot make String an instance of Mime
directly. We have to define a type synonym :-( I want Gofer!
-}

newtype TextPlain
 = TextPlain String

instance Read TextPlain where
   readsPrec _ = \s -> [(TextPlain s,"")]

instance Show TextPlain where
   showsPrec _ (TextPlain s) = showString s

instance Mime TextPlain where
  mimeType _ = "text/plain"

{-
In module PrettyHtml we define the MIME type text/html.
In module UrlEncoded we define the MIME type application/x-www-form-url-encoded.
-}
