module Display (displaym) where

import Color
import Polygon(Poly)
import qualified Polygon as Poly
import Utility
import Movie(Movie, picsOf)
import qualified Picture as Pic
import qualified Xlib as X
import Monad(unless)
import Array

displaym :: String -> Int -> Movie -> IO ()

displaym host n movie =
  let
{-
    movie' = cycle (take n (map (map translatePoly) movie))
-}
    movie' = take n $ map (map translatePoly . Pic.polysOf) (picsOf movie)
  in
  (X.xOpenDisplay host 
    `catch` \ err -> 
    fail (userError ("Unable to open X display " ++ host))
    ) >>= \ display ->
  let screen    = X.xDefaultScreenOfDisplay display
      fg_color  = X.xBlackPixelOfScreen screen
      bg_color  = X.xWhitePixelOfScreen screen
      depth     = X.xDefaultDepthOfScreen screen
      root      = X.xRootWindowOfScreen screen
      color_map = X.xDefaultColormapOfScreen screen

      getPixel :: Color -> IO X.Pixel
      getPixel c = 
     	(X.xAllocNamedColor display color_map name >>= \ ((pixel,_,_,_,_),_) ->
         return pixel
        ) `catch` \ err -> 
          fail (userError ("Unable to allocate colour " ++ name 
                         ++ " - I'll bet you're running Netscape."))
       where
        name = colorName c
  in
  mapM getPixel [minColor..maxColor]     >>= \ pixels ->
  let
    pixelArray :: Array Color X.Pixel
    pixelArray = listArray (minColor, maxColor) pixels
  in

  -- ToDo: resurrect the old code for constructing attribute sets
  X.alloc >>= \ attributes ->
  X.set_background_pixel attributes bg_color          >>
  X.set_event_mask       attributes X.buttonPressMask >>
  let attrmask = X.cWBackPixel `X.orMask` X.cWEventMask in
  X.xCreateWindow display root 
      100 100 -- x, y
      500 500 -- width, height
      1       -- border_width
      depth
      X.inputOutput
      (X.xDefaultVisualOfScreen screen)
      attrmask
      attributes
  >>= \window ->
  X.free attributes >>

  X.xCreateGC display window                 >>= \ gcontext ->
  X.xSetBackground display gcontext bg_color >>
  X.xSetForeground display gcontext fg_color >>

  X.xCreateGC display window                       >>= \ blank_gcontext ->
  X.xSetBackground display blank_gcontext bg_color >>
  X.xSetForeground display blank_gcontext fg_color >>

  X.xCreatePixmap display window 500 500 depth >>= \ pixmap ->
  X.xMapWindow display window >>
  let
    dispFrame :: Pic' -> IO ()
    dispFrame m = 
      X.xFillRectangle display pixmap blank_gcontext 0 0 500 500 >>
      dispPic m                                               >>
      X.xCopyArea display pixmap window gcontext 0 0 500 500 0 0 >>
      X.xFlush display

    dispPic :: Pic' -> IO ()
    dispPic = mapM_ dispPoly

    dispPoly :: Poly' -> IO ()
    dispPoly (c, vec) =
      -- ADRNote: Recommended X style is to use one GC per colour
      -- not to use one GC and keep changing colour.
      X.xSetForeground display gcontext (pixelArray!c) >>
      X.xFillPolygon display pixmap gcontext vec X.complex X.coordModeOrigin

    untilButton (frame:frames) = 
--      printExp movie' 10 >>
--      printThread 20 >>
--      printVar 870 10 >>
--      printName "test" 10 >>
      X.xPending display >>= \count ->
      dispFrame frame >>
      if count == 0 then 
        untilButton frames
      else
	X.alloc                     >>= \ xevent ->
        X.xNextEvent display xevent >>
	X.getXEventPtr xevent       >>= \ etype ->
	X.free xevent               >>
        unless (etype == X.buttonPress) (untilButton frames)
    untilButton [] = untilButton movie'
  in
  putStr "Click button to end.\n" >>
  untilButton movie'              >>
  X.xFreePixmap display pixmap    >>
  X.xCloseDisplay display

type Movie' = [Pic']
type Pic' = [Poly']
type Poly' = (Color, [(X.Position,X.Position)])

translatePoly :: Poly -> Poly'
translatePoly p = (Poly.colorOf p, 
	           [ (x `div` 2, 500 - y `div` 2) | (x,y) <- Poly.vecsOf p ])

